import compiler
import compiler.ast

groups = ['ace_beginning_nt',
          'adenine',
          'ala_sidechain',
          'alanine',
          'alanine_ct',
          'alanine_nt',
          'arg_sidechain',
          'arginine',
          'arginine_ct',
          'arginine_nt',
          'asn_sidechain',
          'asp_sidechain',
          'asp_sidechain_neutral',
          'asparagine',
          'asparagine_ct',
          'asparagine_nt',
          'aspartic_acid',
          'aspartic_acid_ct',
          'aspartic_acid_neutral',
          'aspartic_acid_nt',
          'cym_sidechain',
          'cys_sidechain',
          'cysteine',
          'cysteine_ct',
          'cysteine_nt',
          'cysteine_with_negative_charge',
          'cystine_ss',
          'cystine_ss_ct',
          'cystine_ss_nt',
          'cytosine',
          'cyx_sidechain',
          'd-adenosine',
          'd-adenosine_3ter',
          'd-adenosine_5ter',
          'd-adenosine_5ter_3ter',
          'd-cytosine',
          'd-cytosine_3ter',
          'd-cytosine_5ter',
          'd-cytosine_5ter_3ter',
          'd-guanosine',
          'd-guanosine_3ter',
          'd-guanosine_5ter',
          'd-guanosine_5ter_3ter',
          'd-thymine',
          'd-thymine_3ter',
          'd-thymine_5ter',
          'd-thymine_5ter_3ter',
          'desoxyribose',
          'desoxyribose_3ter',
          'desoxyribose_5ter',
          'desoxyribose_5ter_3ter',
          'gln_sidechain',
          'glu_sidechain',
          'glu_sidechain_neutral',
          'glutamic_acid',
          'glutamic_acid_ct',
          'glutamic_acid_neutral',
          'glutamic_acid_nt',
          'glutamine',
          'glutamine_ct',
          'glutamine_nt',
          'gly_nt_sidechain',
          'gly_sidechain',
          'glycine',
          'glycine_ct',
          'glycine_nt',
          'guanine',
          'hid_sidechain',
          'hie_sidechain',
          'hip_sidechain',
          'histidine',
          'histidine_ct',
          'histidine_deltah',
          'histidine_deltah_ct',
          'histidine_deltah_nt',
          'histidine_epsilonh',
          'histidine_epsilonh_ct',
          'histidine_epsilonh_nt',
          'histidine_nt',
          'histidine_plus',
          'histidine_plus_ct',
          'histidine_plus_nt',
          'ile_sidechain',
          'isoleucine',
          'isoleucine_ct',
          'isoleucine_nt',
          'leu_sidechain',
          'leucine',
          'leucine_ct',
          'leucine_nt',
          'lys_sidechain',
          'lys_sidechain_neutral',
          'lysine',
          'lysine_ct',
          'lysine_neutral',
          'lysine_neutral_ct',
          'lysine_neutral_nt',
          'lysine_nt',
          'met_sidechain',
          'methionine',
          'methionine_ct',
          'methionine_nt',
          'na_phosphate',
          'nmethyl_ct',
          'peptide',
          'peptide_ct',
          'peptide_nt',
          'peptide_nt_ct',
          'peptide_proline',
          'peptide_proline_ct',
          'peptide_proline_nt',
          'phe_sidechain',
          'phenylalanine',
          'phenylalanine_ct',
          'phenylalanine_nt',
          'pro_sidechain',
          'pro_sidechain_nt',
          'proline',
          'proline_ct',
          'proline_nt',
          'r-adenosine',
          'r-adenosine_3ter',
          'r-adenosine_5ter',
          'r-adenosine_5ter_3ter',
          'r-cytosine',
          'r-cytosine_3ter',
          'r-cytosine_5ter',
          'r-cytosine_5ter_3ter',
          'r-guanosine',
          'r-guanosine_3ter',
          'r-guanosine_5ter',
          'r-guanosine_5ter_3ter',
          'r-uracil',
          'r-uracil_3ter',
          'r-uracil_5ter',
          'r-uracil_5ter_3ter',
          'ribose',
          'ribose_3ter',
          'ribose_5ter',
          'ribose_5ter_3ter',
          'ser_sidechain',
          'serine',
          'serine_ct',
          'serine_nt',
          'thr_sidechain',
          'threonine',
          'threonine_ct',
          'threonine_nt',
          'thymine',
          'trp_sidechain',
          'tryptophan',
          'tryptophan_ct',
          'tryptophan_nt',
          'tyr_sidechain',
          'tyrosine',
          'tyrosine_ct',
          'tyrosine_nt',
          'uracil',
          'val_sidechain',
          'valine',
          'valine_ct',
          'valine_nt']

for filename in groups:

    ast = compiler.parse(file(filename).read())
    stmts = ast.getChildren()[1].getChildren()

    vars = set()
    for stmt in stmts:
        if isinstance(stmt, compiler.ast.Assign):
            var_name = stmt.getChildren()[0].getChildren()[0]
            vars.add(var_name)
    if 'amber_atom_type' in vars \
            and 'amber12_atom_type' not in vars:
        print filename
        with file(filename, 'a') as f:
            f.write("amber12_atom_type = amber_atom_type\n")
