### Empty
{
	type => "tfn",
	name => "normalisePathWin",
	input => "",
	output => "",
	ret => 0,
},

### Nothing but switch slashes
{
	type => "tfn",
	name => "normalisePathWin",
	input => "\\foo\\bar\\baz",
	output => "/foo/bar/baz",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "\\foo\\bar\0\\baz",
	output => "/foo/bar\0/baz",
	ret => 1,
},

### Basics
{
	type => "tfn",
	name => "normalisePathWin",
	input => "x",
	output => "x",
	ret => 0,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => ".",
	output => "",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => ".\\",
	output => "",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => ".\\..",
	output => "..",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => ".\\..\\",
	output => "../",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "..",
	output => "..",
	ret => 0,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "..\\",
	output => "../",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "..\\.",
	output => "..",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "..\\.\\",
	output => "../",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "..\\..",
	output => "../..",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "..\\..\\",
	output => "../../",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "\\dir\\foo\\\\bar",
	output => "/dir/foo/bar",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\foo\\\\bar\\",
	output => "dir/foo/bar/",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\..\\foo",
	output => "foo",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\..\\..\\foo",
	output => "../foo",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\.\\..\\.\\..\\..\\foo\\bar",
	output => "../../foo/bar",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\.\\..\\.\\..\\..\\foo\\bar\\.",
	output => "../../foo/bar",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\.\\..\\.\\..\\..\\foo\\bar\\.\\",
	output => "../../foo/bar/",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\.\\..\\.\\..\\..\\foo\\bar\\..",
	output => "../../foo",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\.\\..\\.\\..\\..\\foo\\bar\\..\\",
	output => "../../foo/",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\.\\..\\.\\..\\..\\foo\\bar\\",
	output => "../../foo/bar/",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\\\.\\\\..\\\\.\\\\..\\\\..\\\\foo\\\\bar",
	output => "../../foo/bar",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\\\.\\\\..\\\\.\\\\..\\\\..\\\\foo\\\\bar\\\\",
	output => "../../foo/bar/",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\subdir\\subsubdir\\subsubsubdir\\..\\..\\..",
	output => "dir",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\.\\subdir\\.\\subsubdir\\.\\subsubsubdir\\..\\..\\..",
	output => "dir",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "dir\\.\\subdir\\..\\subsubdir\\..\\subsubsubdir\\..",
	output => "dir",
	ret => 1,
},
{
	type => "tfn",
	name => "normalisePathWin",
	input => "\\dir\\.\\subdir\\..\\subsubdir\\..\\subsubsubdir\\..\\",
	output => "/dir/",
	ret => 1,
},

### With NUL
{
	type => "tfn",
	name => "normalisePathWin",
	input => "\\.\\..\\.\\..\\..\\..\\..\\..\\..\\..\\\0\\..\\etc\\.\\passwd",
	output => "/etc/passwd",
	ret => 1,
},
