from typing import Any

class BaseCache:
    default_timeout = ...  # type: Any
    def __init__(self, default_timeout=300): ...
    def get(self, key): ...
    def delete(self, key): ...
    def get_many(self, *keys): ...
    def get_dict(self, *keys): ...
    def set(self, key, value, timeout=None): ...
    def add(self, key, value, timeout=None): ...
    def set_many(self, mapping, timeout=None): ...
    def delete_many(self, *keys): ...
    def has(self, key): ...
    def clear(self): ...
    def inc(self, key, delta=1): ...
    def dec(self, key, delta=1): ...

class NullCache(BaseCache): ...

class SimpleCache(BaseCache):
    clear = ...  # type: Any
    def __init__(self, threshold=500, default_timeout=300): ...
    def get(self, key): ...
    def set(self, key, value, timeout=None): ...
    def add(self, key, value, timeout=None): ...
    def delete(self, key): ...
    def has(self, key): ...

class MemcachedCache(BaseCache):
    key_prefix = ...  # type: Any
    def __init__(self, servers=None, default_timeout=300, key_prefix=None): ...
    def get(self, key): ...
    def get_dict(self, *keys): ...
    def add(self, key, value, timeout=None): ...
    def set(self, key, value, timeout=None): ...
    def get_many(self, *keys): ...
    def set_many(self, mapping, timeout=None): ...
    def delete(self, key): ...
    def delete_many(self, *keys): ...
    def has(self, key): ...
    def clear(self): ...
    def inc(self, key, delta=1): ...
    def dec(self, key, delta=1): ...
    def import_preferred_memcache_lib(self, servers): ...

GAEMemcachedCache = ...  # type: Any

class RedisCache(BaseCache):
    key_prefix = ...  # type: Any
    def __init__(self, host='', port=6379, password=None, db=0, default_timeout=300, key_prefix=None, **kwargs): ...
    def dump_object(self, value): ...
    def load_object(self, value): ...
    def get(self, key): ...
    def get_many(self, *keys): ...
    def set(self, key, value, timeout=None): ...
    def add(self, key, value, timeout=None): ...
    def set_many(self, mapping, timeout=None): ...
    def delete(self, key): ...
    def delete_many(self, *keys): ...
    def has(self, key): ...
    def clear(self): ...
    def inc(self, key, delta=1): ...
    def dec(self, key, delta=1): ...

class FileSystemCache(BaseCache):
    def __init__(self, cache_dir, threshold=500, default_timeout=300, mode=384): ...
    def clear(self): ...
    def get(self, key): ...
    def add(self, key, value, timeout=None): ...
    def set(self, key, value, timeout=None): ...
    def delete(self, key): ...
    def has(self, key): ...

class UWSGICache(BaseCache):
    cache = ...  # type: Any
    def __init__(self, default_timeout=300, cache=''): ...
    def get(self, key): ...
    def delete(self, key): ...
    def set(self, key, value, timeout=None): ...
    def add(self, key, value, timeout=None): ...
    def clear(self): ...
    def has(self, key): ...
