// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepFill_OffsetWire_HeaderFile
#define _BRepFill_OffsetWire_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopoDS_Face.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <TopoDS_Shape.hxx>
#include <GeomAbs_JoinType.hxx>
#include <BRepFill_IndexedDataMapOfOrientedShapeListOfShape.hxx>
#include <BRepMAT2d_BisectingLocus.hxx>
#include <BRepMAT2d_LinkTopoBilo.hxx>
#include <TopTools_DataMapOfShapeShape.hxx>
class Standard_ConstructionError;
class Standard_NoSuchObject;
class TopoDS_Face;
class BRepMAT2d_BisectingLocus;
class BRepMAT2d_LinkTopoBilo;
class TopoDS_Shape;
class TopTools_ListOfShape;
class BRepFill_IndexedDataMapOfOrientedShapeListOfShape;
class BRepFill_DataMapOfOrientedShapeListOfShape;
class TopTools_SequenceOfShape;
class TColgp_SequenceOfPnt;
class Bisector_Bisec;
class BRepFill_TrimEdgeTool;


//! Constructs a Offset Wire to a spine (wire or face)
//! on the left of spine.
//! The Wire or the Face must be planar.
class BRepFill_OffsetWire 
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT BRepFill_OffsetWire();
  
  Standard_EXPORT BRepFill_OffsetWire(const TopoDS_Face& Spine, const GeomAbs_JoinType Join = GeomAbs_Arc, const Standard_Boolean IsOpenResult = Standard_False);
  
  //! Initialize the evaluation of Offseting.
  Standard_EXPORT   void Init (const TopoDS_Face& Spine, const GeomAbs_JoinType Join = GeomAbs_Arc, const Standard_Boolean IsOpenResult = Standard_False) ;
  
  //! Performs  an OffsetWire at  an altitude <Alt> from
  //! the  face ( According  to  the orientation of  the
  //! face)
  Standard_EXPORT   void Perform (const Standard_Real Offset, const Standard_Real Alt = 0.0) ;
  
  //! Performs an  OffsetWire
  Standard_EXPORT   void PerformWithBiLo (const TopoDS_Face& WSP, const Standard_Real Offset, const BRepMAT2d_BisectingLocus& Locus, BRepMAT2d_LinkTopoBilo& Link, const GeomAbs_JoinType Join = GeomAbs_Arc, const Standard_Real Alt = 0.0) ;
  
  Standard_EXPORT   Standard_Boolean IsDone()  const;
  
  Standard_EXPORT  const  TopoDS_Face& Spine()  const;
  
  //! returns the generated shape.
  Standard_EXPORT  const  TopoDS_Shape& Shape()  const;
  
  //! Returns   the  shapes  created  from   a  subshape
  //! <SpineShape> of the spine.
  //! Returns the last computed Offset.
  Standard_EXPORT  const  TopTools_ListOfShape& GeneratedShapes (const TopoDS_Shape& SpineShape) ;
  
  Standard_EXPORT   GeomAbs_JoinType JoinType()  const;




protected:





private:

  
  Standard_EXPORT   BRepFill_IndexedDataMapOfOrientedShapeListOfShape& Generated() ;
  
  //! Prepare the spine as follow
  //! - Cut the spine-Edges at the extrema of curvature and
  //! at the inflexion points.
  Standard_EXPORT   void PrepareSpine() ;
  
  //! Add the OffsetWire <Other> to <me> and update <myMap>
  Standard_EXPORT   void Add (const BRepFill_OffsetWire& Other) ;
  
  Standard_EXPORT   void UpdateDetromp (BRepFill_DataMapOfOrientedShapeListOfShape& Detromp, const TopoDS_Shape& Shape1, const TopoDS_Shape& Shape2, const TopTools_SequenceOfShape& Vertices, const TColgp_SequenceOfPnt& Params, const Bisector_Bisec& Bisec, const Standard_Boolean SOnE, const Standard_Boolean EOnE, const BRepFill_TrimEdgeTool& Trim)  const;
  
  //! Constructs the wires with the trimmed offset edges.
  Standard_EXPORT   void MakeWires() ;
  
  //! Fix holes between open wires where it is possible
  Standard_EXPORT   void FixHoles() ;


  TopoDS_Face mySpine;
  TopoDS_Face myWorkSpine;
  Standard_Real myOffset;
  Standard_Boolean myIsOpenResult;
  TopoDS_Shape myShape;
  Standard_Boolean myIsDone;
  GeomAbs_JoinType myJoinType;
  BRepFill_IndexedDataMapOfOrientedShapeListOfShape myMap;
  BRepMAT2d_BisectingLocus myBilo;
  BRepMAT2d_LinkTopoBilo myLink;
  TopTools_DataMapOfShapeShape myMapSpine;
  Standard_Boolean myCallGen;


};







#endif // _BRepFill_OffsetWire_HeaderFile
