// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Prs3d_HeaderFile
#define _Prs3d_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <Quantity_Length.hxx>
#include <Standard_Real.hxx>
#include <Handle_Prs3d_Drawer.hxx>
class gp_Pnt;
class TopoDS_Shape;
class Prs3d_Drawer;
class Prs3d_Presentation;
class Prs3d_BasicAspect;
class Prs3d_PointAspect;
class Prs3d_LineAspect;
class Prs3d_ShadingAspect;
class Prs3d_TextAspect;
class Prs3d_IsoAspect;
class Prs3d_ArrowAspect;
class Prs3d_PlaneAspect;
class Prs3d_DimensionAspect;
class Prs3d_DatumAspect;
class Prs3d_Drawer;
class Prs3d_Projector;
class Prs3d_PlaneSet;
class Prs3d_Root;
class Prs3d_Text;
class Prs3d_ShapeTool;
class Prs3d_Arrow;


//! The Prs3d package provides the following services
//! -   a presentation object (the context for all
//! modifications to the display, its presentation will be
//! displayed in every view of an active viewer)
//! -   an attribute manager governing how objects such
//! as color, width, and type of line are displayed;
//! these are generic objects, whereas those in
//! StdPrs are specific geometries and topologies.
//! -   generic   algorithms providing default settings for
//! objects such as points, curves, surfaces and shapes
//! -   a root object which provides the abstract
//! framework for the DsgPrs definitions at work in
//! display of dimensions, relations and trihedra.
class Prs3d 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! draws an arrow at a given location, with respect
  //! to a given direction.
  Standard_EXPORT static   Standard_Boolean MatchSegment (const Quantity_Length X, const Quantity_Length Y, const Quantity_Length Z, const Quantity_Length aDistance, const gp_Pnt& p1, const gp_Pnt& p2, Quantity_Length& dist) ;
  
  //! Computes the absolute deflection value depending on
  //! the type of deflection in theDrawer:
  //! <ul>
  //! <li><b>Aspect_TOD_RELATIVE</b>: the absolute deflection is computed using the relative
  //! deviation coefficient from theDrawer and the shape's bounding box;</li>
  //! <li><b>Aspect_TOD_ABSOLUTE</b>: the maximal chordial deviation from theDrawer is returned.</li>
  //! </ul>
  //! This function should always be used to compute the deflection value for building
  //! discrete representations of the shape (triangualtion, wireframe) to avoid incosistencies
  //! between different representations of the shape and undesirable visual artifacts.
  Standard_EXPORT static   Standard_Real GetDeflection (const TopoDS_Shape& theShape, const Handle(Prs3d_Drawer)& theDrawer) ;




protected:





private:




friend class Prs3d_Presentation;
friend class Prs3d_BasicAspect;
friend class Prs3d_PointAspect;
friend class Prs3d_LineAspect;
friend class Prs3d_ShadingAspect;
friend class Prs3d_TextAspect;
friend class Prs3d_IsoAspect;
friend class Prs3d_ArrowAspect;
friend class Prs3d_PlaneAspect;
friend class Prs3d_DimensionAspect;
friend class Prs3d_DatumAspect;
friend class Prs3d_Drawer;
friend class Prs3d_Projector;
friend class Prs3d_PlaneSet;
friend class Prs3d_Root;
friend class Prs3d_Text;
friend class Prs3d_ShapeTool;
friend class Prs3d_Arrow;

};







#endif // _Prs3d_HeaderFile
