// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _SelectMgr_SelectionManager_HeaderFile
#define _SelectMgr_SelectionManager_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_SelectMgr_SelectionManager.hxx>

#include <TColStd_MapOfTransient.hxx>
#include <SelectMgr_DataMapOfObjectSelectors.hxx>
#include <MMgt_TShared.hxx>
#include <Handle_SelectMgr_ViewerSelector.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_SelectMgr_SelectableObject.hxx>
#include <Standard_Integer.hxx>
#include <SelectMgr_TypeOfUpdate.hxx>
class SelectMgr_ViewerSelector;
class SelectMgr_SelectableObject;
class TCollection_AsciiString;


//! A framework to manage selection from the point of
//! view of viewer selectors. These can be added and
//! removed, and selection modes can be activated and
//! deactivated. In addition, objects may be known to all
//! selectors or only to some.
class SelectMgr_SelectionManager : public MMgt_TShared
{

public:

  
  //! Constructs an empty selection manager object.
  Standard_EXPORT SelectMgr_SelectionManager();
  
  //! Adds the viewer selector aSelector to this framework.
  Standard_EXPORT   void Add (const Handle(SelectMgr_ViewerSelector)& aSelector) ;
  
  Standard_EXPORT   void Remove (const Handle(SelectMgr_ViewerSelector)& aSelector) ;
  

  //! Returns true if this framework contains the viewer selector aSelector.
  Standard_EXPORT   Standard_Boolean Contains (const Handle(SelectMgr_ViewerSelector)& aSelector)  const;
  
  //! Returns true if this framework contains the
  //! selectable object aSelectableObject.
  Standard_EXPORT   Standard_Boolean Contains (const Handle(SelectMgr_SelectableObject)& aSelectableObject)  const;
  
  //! Loads and computes one  mode of
  //! selection if  <aMode> notequal -1 ;
  //! if  <anObject> already has a
  //! selection with this mode, it's emptied and the sensitive
  //! entities are computed  for this mode else one  Selection
  //! is created with this mode before computing.
  Standard_EXPORT   void Load (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Integer aMode = -1) ;
  
  //! Local    object  available for
  //! <aSelector> Only.  the sensitive entities for  selection
  //! of mode <aMode> are computed if <aMode> not equal -1.
  //! if <aMode> =-1 oc compute is done
  Standard_EXPORT   void Load (const Handle(SelectMgr_SelectableObject)& anObject, const Handle(SelectMgr_ViewerSelector)& aSelector, const Standard_Integer aMode = -1) ;
  
  //! removes the object from All the ViewerSelectors where it was;
  Standard_EXPORT   void Remove (const Handle(SelectMgr_SelectableObject)& anObject) ;
  
  //! removes the object from aSelector;
  Standard_EXPORT   void Remove (const Handle(SelectMgr_SelectableObject)& anObject, const Handle(SelectMgr_ViewerSelector)& aSelector) ;
  
  //! Activates the selection mode aMode in a selector
  //! for the selectable object anObject.
  Standard_EXPORT   void Activate (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Integer aMode = 0, const Standard_Boolean AutomaticProj = Standard_True) ;
  
  //! Activates the selection mode aMode in the selector
  //! aSelector for the selectable object anObject.
  Standard_EXPORT   void Activate (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Integer aMode, const Handle(SelectMgr_ViewerSelector)& aSelector, const Standard_Boolean AutomaticProj = Standard_True) ;
  
  //! Deactivate all the activated modes in any
  //! Selector for <anObject>
  Standard_EXPORT   void Deactivate (const Handle(SelectMgr_SelectableObject)& anObject) ;
  
  //! Deactivates the Mode <aMode> in every Selector where
  //! it was activated
  Standard_EXPORT   void Deactivate (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Integer aMode) ;
  
  //! Deactivates the selection mode aMode in the
  //! selector aSelector for the selectable object anObject.
  Standard_EXPORT   void Deactivate (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Integer aMode, const Handle(SelectMgr_ViewerSelector)& aSelector) ;
  
  //! Deactivates all selection modes in the selector
  //! aSelector for the selectable object anObject.
  Standard_EXPORT   void Deactivate (const Handle(SelectMgr_SelectableObject)& anObject, const Handle(SelectMgr_ViewerSelector)& aSelector) ;
  
  //! Ensures that no object in the selector aSelector will be active.
  Standard_EXPORT   void Sleep (const Handle(SelectMgr_ViewerSelector)& aSelector) ;
  
  //! the objet is temporarily deactivated everywhere it was activated.
  Standard_EXPORT   void Sleep (const Handle(SelectMgr_SelectableObject)& anObject) ;
  
  //! Different from Deactivate; this method
  //! deactivates the activated modes of an object,
  //! but just for a time; when the Awake Method is called
  //! the sleeping modes are reactivated.
  Standard_EXPORT   void Sleep (const Handle(SelectMgr_SelectableObject)& anObject, const Handle(SelectMgr_ViewerSelector)& aSelector) ;
  
  //! activates all the deactivated objects in a selector.
  Standard_EXPORT   void Awake (const Handle(SelectMgr_ViewerSelector)& aSelector, const Standard_Boolean AutomaticProj = Standard_True) ;
  
  Standard_EXPORT   void Awake (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Boolean AutomaticProj = Standard_True) ;
  
  //! activates all the deactivated modes
  //! of an object in a selector
  Standard_EXPORT   void Awake (const Handle(SelectMgr_SelectableObject)& anObject, const Handle(SelectMgr_ViewerSelector)& aSelector, const Standard_Boolean AutomaticProj = Standard_True) ;
  
  //! Returns true if the selection is active for the selectable object anObject.
  Standard_EXPORT   Standard_Boolean IsActivated (const Handle(SelectMgr_SelectableObject)& anObject)  const;
  
  //! Returns true if the selection mode aMode is active for the selectable object anObject.
  Standard_EXPORT   Standard_Boolean IsActivated (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Integer aMode)  const;
  
  //! Returns true if the selection mode aMode is active for the selectable
  //! object anObject in the viewer selector aSelector.
  Standard_EXPORT   Standard_Boolean IsActivated (const Handle(SelectMgr_SelectableObject)& anObject, const Handle(SelectMgr_ViewerSelector)& aSelector, const Standard_Integer aMode)  const;
  
  //! computes Selections in <anIObj> if they are
  //! activated in at least one Selector.
  //! puts a recompute flag in each selection which is not active.
  //! if <aMode>=-1 all the selection modes will have to be
  //! recomputed.
  //! if <ForceUpdate>  = True, all selections are recomputed,
  //! even if they are not active.
  Standard_EXPORT   void RecomputeSelection (const Handle(SelectMgr_SelectableObject)& anIObj, const Standard_Boolean ForceUpdate = Standard_False, const Standard_Integer aMode = -1) ;
  
  //! updates the selectionModes of <anObject>
  //! According to
  //! . the stored type of update in each selection
  //! mode,
  //! . the activation status of each selection mode
  //! if <ForceUpdate> == True Recompute
  Standard_EXPORT   void Update (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Boolean ForceUpdate = Standard_True) ;
  
  Standard_EXPORT   void Update (const Handle(SelectMgr_SelectableObject)& anObject, const Handle(SelectMgr_ViewerSelector)& aSelector, const Standard_Boolean ForceUpdate = Standard_True) ;
  
  Standard_EXPORT   void SetUpdateMode (const Handle(SelectMgr_SelectableObject)& anObject, const SelectMgr_TypeOfUpdate aType) ;
  
  Standard_EXPORT   void SetUpdateMode (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Integer aSelMode, const SelectMgr_TypeOfUpdate aType) ;
  
  Standard_EXPORT   TCollection_AsciiString Status()  const;
  
  Standard_EXPORT   TCollection_AsciiString Status (const Handle(SelectMgr_SelectableObject)& anObject)  const;




  DEFINE_STANDARD_RTTI(SelectMgr_SelectionManager)

protected:




private: 

  
  Standard_EXPORT   void LoadMode (const Handle(SelectMgr_SelectableObject)& anObject, const Standard_Integer aMode) ;

  TColStd_MapOfTransient myselectors;
  TColStd_MapOfTransient myglobal;
  SelectMgr_DataMapOfObjectSelectors mylocal;


};







#endif // _SelectMgr_SelectionManager_HeaderFile
