// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeUpgrade_ShellSewing_HeaderFile
#define _ShapeUpgrade_ShellSewing_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopTools_IndexedMapOfShape.hxx>
#include <Handle_ShapeBuild_ReShape.hxx>
#include <Standard_Real.hxx>
#include <Standard_Integer.hxx>
class ShapeBuild_ReShape;
class TopoDS_Shape;


//! This class provides a tool for applying sewing algorithm from
//! BRepBuilderAPI: it takes a shape, calls sewing for each shell,
//! and then replaces sewed shells with use of ShapeBuild_ReShape
class ShapeUpgrade_ShellSewing 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Creates a ShellSewing, empty
  Standard_EXPORT ShapeUpgrade_ShellSewing();
  
  //! Builds a new shape from a former one, by calling Sewing from
  //! BRepBuilderAPI. Rebuilt solids are oriented to be "not infinite"
  //!
  //! If <tol> is not given (i.e. value 0. by default), it is
  //! computed as the mean tolerance recorded in <shape>
  //!
  //! If no shell has been sewed, this method returns the input
  //! shape
  Standard_EXPORT   TopoDS_Shape ApplySewing (const TopoDS_Shape& shape, const Standard_Real tol = 0.0) ;




protected:





private:

  
  Standard_EXPORT   void Init (const TopoDS_Shape& shape) ;
  
  Standard_EXPORT   Standard_Integer Prepare (const Standard_Real tol) ;
  
  Standard_EXPORT   TopoDS_Shape Apply (const TopoDS_Shape& shape, const Standard_Real tol) ;


  TopTools_IndexedMapOfShape myShells;
  Handle(ShapeBuild_ReShape) myReShape;


};







#endif // _ShapeUpgrade_ShellSewing_HeaderFile
