%%NAME
%%  equisci  - encode/decode  vector with QUISCI-cipher
%%
%%SYNOPSIS
%%  [code,checksum]=equisci(code,key)
%%
%%PARAMETER(S)
%%  code        vector for encoding/decoding
%%  key         key 
%%  checksum    for testing keys
%% 
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010
function [code,checksum]=equisci(code,key)
  if (nargin<2)
    eusage('[code,checksum] = equisci(code,key)');
  end

  % init box
  randInit=1357135753;
  mask=4294967295;
  csmask=65535;
  boxsize=512;
  boxsizeMin1=boxsize-1;
  s=zeros(boxsize,1);
  key=key+0;

  % setup key
  i=randInit;
  l=length(key);
  for k=1:l;
    i=bitand(mask,i+randInit);
    i=bitand(mask,i+key(k));
    s(k)=i;
  end
  j=1;
  for k=l+1:boxsize
    i=bitand(mask,i+randInit);
    i=bitand(mask,i+s(j));
    s(k)=i;
    j=j+1;
  end
  x=i;
  j=bitand(boxsizeMin1,i)+1;
  checksum=bitand(csmask,i);

  %loop
  code=floor(code);
  for k=1:length(code) 
    i=bitand(mask,i+s(j));
    if i==0
      i=bitxor(mask,s(j));
      s(j)=x;
      code(k)=bitxor(code(k),i);
    else
      x=bitxor(i,s(j));
      s(j)=i;
      j=bitand(boxsizeMin1,i)+1;
      code(k)=bitxor(code(k),x);
    end
  end
