%%NAME
%%  etxt2shtml  - encode text to secret html-file 
%%
%%SYNOPSIS
%%  checksum=etxt2shtml(text,htmlFilename,key[,title[,legend[,mineTye]]])
%%
%%PARAMETER(S)
%%  text           vector of unsigned char 
%%                 or string
%%                 or filename of text-file
%%  htmlFilename   string of html-filename
%%  key            vector of unsigned char
%%                 or string
%%  title          title of encoded file
%%  legend         legend under password entry
%%  mineType       default='text/html'
%%  checksum       checksum of cipher
% written by stefan.mueller@fhr.fraunhofer.de (C) 2012

function checksum=etxt2shtml(text,htmlFile,key,title,legend,mineType)
  if nargin<3 || nargin >6
    eusage('checksum=etxt2shtml(text,htmlFilename,key[,title[,legend[,mineType]]])');
  end
  if nargin<6
    mineType='text/html';
  end
  if nargin<5
    legend='Please enter password!<br><br><p>Important:  Please, klick Close-Button after you have read the document !!!</p>';
  end
  if nargin<4
    title='';
  end
  if length(key)<12
    diff=12-length(key);
    message=sprintf('Warning: Your key is unsafe. Use %d character more !',diff); 
    disp(message);
  end
  textL=length(text);
  if textL<80
    if exist(text)==2
      txtFileName=text;
      [text textL]=etxtread(txtFileName);
    end
  end
  if nargout>0
    message=0;
  else
    message=1;
  end
  eglobpar;
  if exist('eFac')
    if isempty(eFac)
      einit;
    end
  else
    einit;
  end

  % encode text 
  [code codeL]=etxt2int(text);
  timeValue=3600*24*(now-719529);
  identNo=sprintf('%f',timeValue);
  key=[char(key) identNo];

  [code checksum]=equisci(code,key);

  % read includes
  [decodeFunction n]=etxtread([ePath 'quisci.inc']);
  [htmlTemplate n]=etxtread([ePath 'shtmltxt.inc']);
  
  % write shtml
  fid=fopen(htmlFile,'wb');
  fprintf(fid,'<!-- Created by etxt2shtml, a function of EpsTk,\n');
  fprintf(fid,'     written by stefan.mueller@fhr.fraunhofer.de 2012    -->\n');
  fprintf(fid,'<script language=''JavaScript'' type=''text/javascript''>\n');
  fprintf(fid,'<!--\n// text data\n');
  fprintf(fid,'var myTextChecksum = %d;\n',checksum);
  fprintf(fid,'var myMineType = ''%s'';\n',mineType);
  fprintf(fid,'var myIdentNo = ''%s'';\n',identNo);
  fprintf(fid,'var myTitle = ''%s'';\n',title);
  fprintf(fid,'var myLegend = ''%s'';\n',legend);
  fprintf(fid,'var myArray = [\n');
  fprintf(fid,'%ld,',code(1:codeL-1));
  fprintf(fid,'%ld\n',code(codeL));
  fprintf(fid,'];\n');
  fwrite(fid,decodeFunction,'uchar');
  fwrite(fid,htmlTemplate,'uchar');
  if message
    message=sprintf('%s is written',htmlFile); 
    disp(message);
  end
  fclose(fid);
  eglobpar
  eFileName=htmlFile;
