/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_BIOSString.h"

CMPIObjectPath* BIOS_OpenDRIM_BIOSString_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BIOSString& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_BIOSString_classnames[0], OpenDRIM_BIOSString_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* BIOS_OpenDRIM_BIOSString_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BIOSString& instance) {
	_E_;
	Objectpath op(broker, BIOS_OpenDRIM_BIOSString_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.AttributeName_isNULL)
		ci.setProperty("AttributeName", instance.AttributeName);

	if (!instance.CurrentValue_isNULL)
		ci.setProperty("CurrentValue", instance.CurrentValue);

	if (!instance.DefaultValue_isNULL)
		ci.setProperty("DefaultValue", instance.DefaultValue);

	if (!instance.PendingValue_isNULL)
		ci.setProperty("PendingValue", instance.PendingValue);

	if (!instance.IsOrderedList_isNULL)
		ci.setProperty("IsOrderedList", instance.IsOrderedList);

	if (!instance.IsReadOnly_isNULL)
		ci.setProperty("IsReadOnly", instance.IsReadOnly);

	if (!instance.StringType_isNULL)
		ci.setProperty("StringType", instance.StringType);

	if (!instance.MinLength_isNULL)
		ci.setProperty("MinLength", instance.MinLength);

	if (!instance.MaxLength_isNULL)
		ci.setProperty("MaxLength", instance.MaxLength);

	if (!instance.ValueExpression_isNULL)
		ci.setProperty("ValueExpression", instance.ValueExpression);

	_L_;
	return ci.getHdl();
}

void BIOS_OpenDRIM_BIOSString_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BIOSString& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void BIOS_OpenDRIM_BIOSString_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BIOSString& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("AttributeName", instance.AttributeName) == OK)
		instance.AttributeName_isNULL = false;

	if (inst.getProperty("CurrentValue", instance.CurrentValue) == OK)
		instance.CurrentValue_isNULL = false;

	if (inst.getProperty("DefaultValue", instance.DefaultValue) == OK)
		instance.DefaultValue_isNULL = false;

	if (inst.getProperty("PendingValue", instance.PendingValue) == OK)
		instance.PendingValue_isNULL = false;

	if (inst.getProperty("IsOrderedList", instance.IsOrderedList) == OK)
		instance.IsOrderedList_isNULL = false;

	if (inst.getProperty("IsReadOnly", instance.IsReadOnly) == OK)
		instance.IsReadOnly_isNULL = false;

	if (inst.getProperty("StringType", instance.StringType) == OK)
		instance.StringType_isNULL = false;

	if (inst.getProperty("MinLength", instance.MinLength) == OK)
		instance.MinLength_isNULL = false;

	if (inst.getProperty("MaxLength", instance.MaxLength) == OK)
		instance.MaxLength_isNULL = false;

	if (inst.getProperty("ValueExpression", instance.ValueExpression) == OK)
		instance.ValueExpression_isNULL = false;

	_L_;
}

