#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
#################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SSHSettingData.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SSHSettingData provider module";
Name = "SSH_OpenDRIM_SSHSettingDataModule";
Location = "cmpiSSH_OpenDRIM_SSHSettingDataProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SSHSettingData provider";
Name = "SSH_OpenDRIM_SSHSettingDataProvider";
ProviderModuleName = "SSH_OpenDRIM_SSHSettingDataModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SSHSettingData provider capabilities";
ProviderModuleName = "SSH_OpenDRIM_SSHSettingDataModule";
ProviderName = "SSH_OpenDRIM_SSHSettingDataProvider";
ClassName = "OpenDRIM_SSHSettingData";
ProviderType = {2};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "Generation", "InstanceID", "ElementName", "ConfigurationName", "ChangeableType", "EnabledSSHVersions", "OtherEnabledSSHVersion", "SSHVersion", "OtherSSHVersion", "EnabledEncryptionAlgorithms", "OtherEnabledEncryptionAlgorithm", "EncryptionAlgorithm", "OtherEncryptionAlgorithm", "IdleTimeout", "KeepAlive", "ForwardX11", "Compression"};
CapabilityID = "SSH_OpenDRIM_SSHSettingData";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SSHSettingData.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SSHSettingData]   
   provider: SSH_OpenDRIM_SSHSettingDataProvider
   location: cmpiSSH_OpenDRIM_SSHSettingDataProvider
   type: instance
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SSHSettingData.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SSHSettingData-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SSHSettingData.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
