/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Allocate.h"

#include "../MemoryManager_p.h"

#include "../MemoryModelConfig_p.h"

extern "C" {

void* gtl_malloc( int _size )
{
#ifdef _USE_GTL_MM_
  return GTLCore::MemoryManager::allocate(_size);
#else
#ifndef _USE_OS_MM_
#error _USE_OS_MM_ or _USE_GTL_MM_ should be defined
#endif
  return malloc(_size);
#endif
}

void gtl_free( void* _ptr )
{
#ifdef _USE_GTL_MM_
  GTLCore::MemoryManager::desallocate(_ptr);
#else
#ifndef _USE_OS_MM_
#error _USE_OS_MM_ or _USE_GTL_MM_ should be defined
#endif
  free(_ptr);
#endif
}

}
