/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLFRAGMENT_COMPILER_H_
#define _GTLFRAGMENT_COMPILER_H_

#include <GTLCore/String.h>
#include <GTLCore/CompilerBase_p.h>
#include <GTLFragment/WhichStdLibrary_p.h>

#include "Library.h"

#include <map>

namespace llvm {
  class Module;
}

namespace GTLCore {
  class ModuleData;
  class Value;
}

namespace GTLFragment {
  struct ParameterInfo;
  /**
   * @internal
   * @ingroup GTLFragment
   */
  class Compiler : public GTLCore::CompilerBase {
    public:
      Compiler( Library::Type _type, int _channelsNb );
      ~Compiler();
      bool compile(WhichStdLibrary _stdLibrary, const GTLCore::String& _sourceCode, const GTLCore::String& _kernelName, GTLCore::ModuleData* _moduleData, llvm::Module* _module, GTLCore::String& _nameSpace, const std::vector< ParameterInfo>& parameters );
      bool importModule(const GTLCore::String& name);
      virtual GTLCore::TypesManager* typesManager();
      Library::Type libraryType() const;
      WhichStdLibrary whichStdLibrary() const;
      const std::map< GTLCore::String, GTLCore::Value >& parameters() const;
      int channelsNb() const;
    public:
      GTLCore::AST::Expression* standardConstant( const GTLCore::String& _name );
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
