Minutes from 116th OpenVDB TSC meeting, January 11th, 2022, (EDT)

Attendees: *Ken* M., *Jeff* L., *Dan* B., *Andre* P., *Nick* A., *Rich* J.

Additional Attendees: JT Nelson (Blender), Greg Hurst (United Therapeutics),
Kyle Wardlow (United Therapeutics), Bruce Cherniak (Intel), Sebastian Gaida,
Karl Marrett (UCLA)

Regrets: None

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) BLOSC
5) Google Summer Code 2022
6) Eval Min Max PR
7) VDB tools
8) Nix Package Manager
9) Next Meeting

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Andre Pradhana.

3) Forum

(a) Build Issues

Nick will look at the build issues in the forum.

(b) PR-1282

Ken will take a look at it. This is a PR on addLeaf and addTile function
not working on non-standard tree. If the tree depth is larger than 3, then
addLeaf and addTile function does not work.

(c) Build Issue with OSX

Ken reported a build issue with explicit template instantiation on OSX
(Monterey and Big Sur). It's not blocking because we can turn off
template instantiation. Dan has not been able to reproduce. The symptom
is that it successfully compiles, but it gives a linker error.

There is a PR for adding MAC OS 11 CI. We are currently
only testing on 10.15. The symptom is that it compiles fine, but it's
complaining about missing symbols.

4) BLOSC

Ken encounters a problem with the unit test for the compressed stream that is
caused by a version of blosc. Nick says VDB is compatible with Blosc 1.17
onwards. This has something to do with the way the unit-tests are structured
because there is some buffer change in a particular version of blosc,
which means that the stream position in the test is incorrect, but is still
compatible with the library. Dan will make sure that the CI tests against
blosc 1.17 - 1.21.

5) Google Summer Code 2022

We need a project proposal by tomorrow. Andre volunteers to mentor the student.

Some ideas are improving logging and adding vectorization to the core library.

Andre will email Ken about it.

6) Eval Min Max PR

Greg has refactored the PR. He asks for people to take a look at the PR.

7) VDB tools

Ken presents his VDB tool. A few cool things that Ken shows:
(a) This is a command-line tool to expose some of the high-level tools in the
OpenVDB library without the need to use a DCC, such as Houdini. There are no
dependencies other than the OpenVDB library itself. You can opt-in and add
support for various file formats. Ken wrote the command-line parsing himself.

(b) Ken shows an example of how to create level-set sphere with various
parameters from the command line. You can view the sphere in openvdb_render.
There is an option to control verboseness in what is printed out.

(c) Ken shows that you can do geometry processing using this tool, e.g.
reading a teapot, convert to level-set, rendering the result. Geometries are
defined as mesh, polygon, or points.

(d) Ken explains how to pass in arguments. He shows that by passing in
'default', this applies to all the tools-invocation to the right of it.

(e) Ken emphasizes that the processes are read from left to read. The
tool will create a stack of geometries as it processes the command.

(f) Ken shows that you can write to a configuration file that spells out
what you did and the hidden arguments that are not spelled out.

(g) Following Nick and Jeff comments, Ken implemented how to do piping
with this tool. An example that he shows is writing a VDB file and
compressing the file.

(h) It supports for loop from the command line. Internally, the geometries
will be tagged according to the loop variable. The loop variable can be
integers or floats. There is another loop called each which goes through
a list that a user specifies.

(g) Ken shows an example of doing the Enright test: advecting a sphere
with the 'Enright' field.

Some notes from TSC members:

(a) They are all really interested. Jeff thinks that we need something
like this. The ideas behind it are solid.

(b) The config file is powerful and very useful. We may need to formalize
a file format for this. It is useful for debugging and profiling. This
config file can be the primary way of feeding into the tool.

Nick brings up the need to think about the syntax carefully, e.g. how
the for loop and for each logic can be invoked with more complex
arguments. A user may consider doing either a for loop using this tool
or using Python-binding.

There is a need to define a scope for this tool. The idea is to have
a simple command-line tool and is powerful enough to perform 70% of high-level
VDB functions. Nick says that we need to think about how complex it can get,
e.g. whether if-statements are going to be supported.

Questions such as whether if statement will come up in the syntax and
how complex it can get should be considered.

(c) Nick comments that it introduces an API and a domain-specific language,
which is minimal at this point. There is a need to be careful, e.g. in
changing default arguments.

(d) This gives VDB another interface other than the Python binding.

(e) Andre asks about NanoVDB support, whether it can convert OpenVDB to NanoVDB
and uses it in the NanoVDB viewer. Ken thinks that it is a good idea.

8) Nix Package Manager

Karl Marrett wants to make a contribution to support Nix package manager. It consists of
config files that allows you to install OpenVDB from Nyx package manager.
Ken thinks it's useful. Nick would like to see a PR.

9) Next Meeting

Next meeting is January 25, 2022.

