#ifndef JobInformationDialog_h
#define JobInformationDialog_h

/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "CustomDialog.h"
#include "Job.h"
#include "JobRecord.h"
#include "Key.h"
#include "RecordHistogram.h"

#include <QCloseEvent>
#include <QLabel>
#include <QResizeEvent>
#include <QTabWidget>

class GridLayoutItem;

class JobInformationDialog: public CustomDialog, public Base::Key
{

    Q_OBJECT

    public:

    //! constructor
    JobInformationDialog( QWidget* );

    //! destructor
    virtual ~JobInformationDialog( void )
    {}

    //!@name accessors
    //@{

    //! job
    const Job& job( void ) const
    { return job_; }

    //! record
    const JobRecord& record( void ) const
    { return record_; }

    //@}

    //!@name modifiers
    //@{

    //! job
    void setJob( const Job&, const JobRecord& );

    //@}

    Q_SIGNALS:

    //! emmitted when dialog is closed
    void closed( JobRecord );

    public Q_SLOTS:

    //! update from job set
    void update( Job::Set );

    protected:

    //! resize event
    virtual void closeEvent( QCloseEvent* );

    //! resize event
    virtual void resizeEvent( QResizeEvent* );

    private Q_SLOTS:

    //! configuration
    void _updateConfiguration( void );

    private:

    //! update job information
    void _updateJobInformation( void );

    //! update from record
    void _updateHistograms( void );

    //! job
    Job job_;

    //! record
    JobRecord record_;

    //! true if associate job is alive
    bool alive_;

    //! tab widget
    QTabWidget* tabWidget_;

    //! icon label
    QLabel* iconLabel_;

    //! name
    GridLayoutItem* nameLabel_;

    //! id
    GridLayoutItem* idLabel_;

    //! parentId
    GridLayoutItem* parentIdLabel_;

    //! user
    GridLayoutItem* userLabel_;

    //! command
    GridLayoutItem* commandLabel_;

    //! start time
    GridLayoutItem* startTimeLabel_;

    //! start time
    GridLayoutItem* completionTimeLabel_;

    //! Histogram bar
    RecordHistogram* cpuHistogram_;

    //! Histogram bar
    RecordHistogram* memoryHistogram_;

};

#endif
