from __future__ import print_function
from _mock import _Mock

Qt = __import__('taurus.external.qt.Qt', fromlist=['Qt'])
jdraw_parser = __import__('taurus.qt.qtgui.graphic.jdraw.jdraw_parser', fromlist=['jdraw_parser'])
taurus = __import__('taurus', fromlist=['taurus'])


SynopticSelectionStyle = _Mock()

jdraw_view_main = _Mock()

os = _Mock()

parseTangoUri = _Mock()

traceback = _Mock()

TAURUS_ATTR_MIME_TYPE = 'application/taurus-attribute'

TAURUS_DEV_MIME_TYPE = 'application/taurus-device'

TAURUS_MODEL_MIME_TYPE = 'application/taurus-model'

class AttributeNameValidator(_Mock):
  pass
  attr = "/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  complete_name = "(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})/(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  normal_name = "((?P<scheme>tango)://)?(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  protocol_prefix = 'tango://'
  short_name = "(?P<devalias>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  w = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"

class DeviceNameValidator(_Mock):
  pass
  complete_name = "(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})/(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  dev = "(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  normal_name = "((?P<scheme>tango)://)?(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  protocol_prefix = 'tango://'
  short_name = "(?P<devalias>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  w = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"

class TaurusBaseWidget(_Mock):
  pass
  Critical = 50
  Debug = 10
  DftLogLevel = 20
  DftLogMessageFormat = '%(threadName)-14s %(levelname)-8s %(asctime)s %(name)s: %(message)s'
  Error = 40
  Fatal = 50
  Info = 20
  ModelChangedSignal = 'modelChanged(const QString &)'
  Trace = 5
  Warning = 30
  _UseParentMsg = False
  _dragEnabled = False
  _eventBufferPeriod = 0
  _modifiableByUser = False
  _showQuality = True
  defaultConfigRecursionDepth = -1
  log_level = 10
  root_inited = True

class TaurusGraphicsItem(_Mock):
  pass
  Critical = 50
  Debug = 10
  DftLogLevel = 20
  DftLogMessageFormat = '%(threadName)-14s %(levelname)-8s %(asctime)s %(name)s: %(message)s'
  Error = 40
  Fatal = 50
  Info = 20
  Trace = 5
  Warning = 30
  _eventBufferPeriod = 0
  _modifiableByUser = False
  _showQuality = True
  defaultConfigRecursionDepth = -1
  log_level = 10
  root_inited = True

class TaurusJDrawSynopticsView(_Mock):
  pass
  AnchorUnderMouse = 2
  AnchorViewCenter = 1
  BoundingRectViewportUpdate = 4
  Box = 1
  CacheBackground = 1
  CacheNone = 0
  Critical = 50
  Debug = 10
  DftLogLevel = 20
  DftLogMessageFormat = '%(threadName)-14s %(levelname)-8s %(asctime)s %(name)s: %(message)s'
  DontAdjustForAntialiasing = 4
  DontClipPainter = 1
  DontSavePainterState = 2
  DrawChildren = 2
  DrawWindowBackground = 1
  Error = 40
  Fatal = 50
  FullViewportUpdate = 0
  HLine = 4
  IgnoreMask = 4
  Info = 20
  MinimalViewportUpdate = 1
  ModelChangedSignal = 'modelChanged(const QString &)'
  NoAnchor = 0
  NoDrag = 0
  NoFrame = 0
  NoViewportUpdate = 3
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RubberBandDrag = 2
  ScrollHandDrag = 1
  Shadow_Mask = 240
  Shape_Mask = 15
  SmartViewportUpdate = 2
  StyledPanel = 6
  Sunken = 48
  Trace = 5
  VLine = 5
  Warning = 30
  WinPanel = 3
  _UseParentMsg = False
  _dragEnabled = False
  _eventBufferPeriod = 0
  _modifiableByUser = False
  _showQuality = True
  defaultConfigRecursionDepth = -1
  log_level = 10
  root_inited = True

