/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import scala.tools.jline.AnsiWindowsTerminal;
import scala.tools.jline.Terminal;
import scala.tools.jline.UnixTerminal;
import scala.tools.jline.UnsupportedTerminal;
import scala.tools.jline.internal.Configuration;
import scala.tools.jline.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalFactory {
    public static final String JLINE_TERMINAL = "jline.terminal";
    public static final String AUTO = "auto";
    public static final String UNIX = "unix";
    public static final String WIN = "win";
    public static final String WINDOWS = "windows";
    public static final String NONE = "none";
    public static final String OFF = "off";
    public static final String FALSE = "false";
    private static final InheritableThreadLocal<Terminal> holder = new InheritableThreadLocal();
    private static final Map<Flavor, Class<? extends Terminal>> FLAVORS = new HashMap<Flavor, Class<? extends Terminal>>();

    public static synchronized Terminal create() {
        Terminal terminal;
        block13: {
            String string;
            if (Log.TRACE) {
                Log.trace(new Throwable("CREATE MARKER"));
            }
            if ((string = Configuration.getString(JLINE_TERMINAL)) == null) {
                string = AUTO;
            }
            Log.debug("Creating terminal; type=", string);
            try {
                String string2 = string.toLowerCase();
                if (string2.equals(UNIX)) {
                    terminal = TerminalFactory.getFlavor(Flavor.UNIX);
                    break block13;
                }
                if (string2.equals(WIN) | string2.equals(WINDOWS)) {
                    terminal = TerminalFactory.getFlavor(Flavor.WINDOWS);
                    break block13;
                }
                if (string2.equals(NONE) || string2.equals(OFF) || string2.equals(FALSE)) {
                    terminal = new UnsupportedTerminal();
                    break block13;
                }
                if (string2.equals(AUTO)) {
                    String string3 = Configuration.getOsName();
                    Flavor flavor = Flavor.UNIX;
                    if (string3.contains(WINDOWS)) {
                        flavor = Flavor.WINDOWS;
                    }
                    terminal = TerminalFactory.getFlavor(flavor);
                    break block13;
                }
                try {
                    terminal = (Terminal)Thread.currentThread().getContextClassLoader().loadClass(string).newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(MessageFormat.format("Invalid terminal type: {0}", string), exception);
                }
            }
            catch (Exception exception) {
                Log.error("Failed to construct terminal; falling back to unsupported", exception);
                terminal = new UnsupportedTerminal();
            }
        }
        Log.debug("Created Terminal: ", terminal);
        try {
            terminal.init();
        }
        catch (Exception exception) {
            Log.error("Terminal initialization failed; falling back to unsupported", exception);
            return new UnsupportedTerminal();
        }
        return terminal;
    }

    public static synchronized void reset() {
        holder.remove();
    }

    public static synchronized void resetIf(Terminal terminal) {
        if (holder.get() == terminal) {
            TerminalFactory.reset();
        }
    }

    public static synchronized void configure(String string) {
        assert (string != null);
        System.setProperty(JLINE_TERMINAL, string);
    }

    public static synchronized void configure(Type type) {
        assert (type != null);
        TerminalFactory.configure(type.name().toLowerCase());
    }

    public static synchronized Terminal get() {
        Terminal terminal = (Terminal)holder.get();
        if (terminal == null) {
            terminal = TerminalFactory.create();
            holder.set(terminal);
        }
        return terminal;
    }

    public static Terminal getFlavor(Flavor flavor) throws Exception {
        Class<? extends Terminal> clazz = FLAVORS.get((Object)flavor);
        if (clazz != null) {
            return clazz.newInstance();
        }
        throw new InternalError();
    }

    public static void registerFlavor(Flavor flavor, Class<? extends Terminal> clazz) {
        FLAVORS.put(flavor, clazz);
    }

    static {
        TerminalFactory.registerFlavor(Flavor.WINDOWS, AnsiWindowsTerminal.class);
        TerminalFactory.registerFlavor(Flavor.UNIX, UnixTerminal.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flavor {
        WINDOWS,
        UNIX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AUTO,
        WINDOWS,
        UNIX,
        NONE;

    }
}

