// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2013 - Scilab Enterprises - Paul Bignier
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- ENGLISH IMPOSED -->
// <-- NO CHECK REF -->
//
// <-- XCOS TEST -->
//

assert_checktrue(importXcosDiagram("SCI/modules/xcos/tests/unit_tests/Solvers/ODE/Temperature_Controller.zcos"));

CVode_val_ref = [
-3.6548088    0.0000044    16.066667    19.721476
-3.6499578    0.0000040    16.066667    19.716625
-3.6451087    0.0000036    16.066667    19.711776
-3.6402617    0.0000033    16.066667    19.706929
-3.6354167    0.0000030    16.066667    19.702084
-3.6305738    0.0000027    16.066667    19.697241
-3.6257328    0.0000025    16.066667    19.6924
-3.6208938    0.0000023    16.066667    19.687561
-3.6160569    0.0000021    16.066667    19.682724
-3.611222     0.0000019    16.066667    19.677889
-3.6063891    0.0000017    16.066667    19.673056
-3.6015582    0.0000015    16.066667    19.668225
-3.5967293    0.0000014    16.066667    19.663396
-3.5919024    0.0000013    16.066667    19.658569
-3.5870775    0.0000012    16.066667    19.653745
-3.5822547    0.0000011    16.066667    19.648922
-3.5774338    0.0000010    16.066667    19.644101
-3.572615     0.0000009    16.066667    19.639282
-3.5677982    0.0000008    16.066667    19.634465
-3.5629834    0.0000007    16.066667    19.62965  ];
CVode_time_ref = (28720.1:10:29990.1)';

for i=1:4

    scs_m.props.tol(6) = i; // Solver
    try scicos_simulate(scs_m); catch disp(lasterror()); end; // CVode

    assert_checkalmostequal(res.values($-19:$, :), CVode_val_ref, [], 1d-4);
    assert_checkalmostequal(res.time, CVode_time_ref);

end
