/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.xml.dtd.om.Choice;
import com.thaiopensource.xml.dtd.om.ElementRef;
import com.thaiopensource.xml.dtd.om.EnumGroup;
import com.thaiopensource.xml.dtd.om.EnumGroupMember;
import com.thaiopensource.xml.dtd.om.EnumGroupRef;
import com.thaiopensource.xml.dtd.om.EnumValue;
import com.thaiopensource.xml.dtd.om.ModelGroup;
import com.thaiopensource.xml.dtd.om.ModelGroupRef;
import com.thaiopensource.xml.dtd.om.Name;
import com.thaiopensource.xml.dtd.om.NameSpecRef;
import com.thaiopensource.xml.dtd.om.OneOrMore;
import com.thaiopensource.xml.dtd.om.Optional;
import com.thaiopensource.xml.dtd.om.Pcdata;
import com.thaiopensource.xml.dtd.om.Sequence;
import com.thaiopensource.xml.dtd.om.ZeroOrMore;
import com.thaiopensource.xml.dtd.parse.DtdBuilder;
import com.thaiopensource.xml.dtd.parse.Entity;
import java.util.Enumeration;
import java.util.Vector;

class Particle {
    static final int REFERENCE = 0;
    static final int GROUP = 1;
    static final int ELEMENT_NAME = 2;
    static final int NMTOKEN = 3;
    static final int PCDATA = 4;
    static final int REFERENCE_END = 5;
    static final int CONNECT_OR = 6;
    static final int CONNECT_SEQ = 7;
    final int type;
    char occur;
    Vector particles;
    Entity entity;
    String value;

    Particle(int n) {
        this.type = n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Particle)) {
            return false;
        }
        Particle particle = (Particle)object;
        if (this.type != particle.type) {
            return false;
        }
        if (this.occur != particle.occur) {
            return false;
        }
        if (this.entity != particle.entity) {
            return false;
        }
        if (this.value != null && !this.value.equals(particle.value)) {
            return false;
        }
        if (this.particles != null) {
            int n = this.particles.size();
            if (particle.particles.size() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.particles.elementAt(i).equals(particle.particles.elementAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    ModelGroup createModelGroup() {
        ModelGroup modelGroup;
        switch (this.type) {
            case 1: {
                modelGroup = Particle.particlesToModelGroup(this.particles);
                break;
            }
            case 2: {
                modelGroup = new ElementRef(new Name(this.value));
                break;
            }
            case 4: {
                modelGroup = new Pcdata();
                break;
            }
            default: {
                return null;
            }
        }
        switch (this.occur) {
            case '?': {
                modelGroup = new Optional(modelGroup);
                break;
            }
            case '+': {
                modelGroup = new OneOrMore(modelGroup);
                break;
            }
            case '*': {
                modelGroup = new ZeroOrMore(modelGroup);
            }
        }
        return modelGroup;
    }

    static ModelGroup particlesToModelGroup(Vector vector) {
        Vector<ModelGroup> vector2 = new Vector<ModelGroup>();
        int n = vector.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ModelGroup modelGroup = null;
            Particle particle = (Particle)vector.elementAt(i);
            switch (particle.type) {
                case 0: {
                    switch (particle.entity.semantic) {
                        case 1: {
                            modelGroup = new ModelGroupRef(particle.entity.name, particle.entity.modelGroup);
                            if (particle.entity.parsed.size() == 0 && (particle.entity.groupFlags & 2) != 0) {
                                bl = true;
                            }
                            i = Particle.indexOfReferenceEnd(vector, i);
                            break;
                        }
                        case 6: {
                            modelGroup = new ElementRef(new NameSpecRef(particle.entity.name, particle.entity.nameSpec));
                            i = Particle.indexOfReferenceEnd(vector, i);
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    modelGroup = particle.createModelGroup();
                    break;
                }
                case 7: {
                    bl = true;
                }
            }
            if (modelGroup == null) continue;
            vector2.addElement(modelGroup);
        }
        if (vector2.size() == 0) {
            return null;
        }
        if (vector2.size() == 1) {
            return (ModelGroup)vector2.elementAt(0);
        }
        ModelGroup[] modelGroupArray = new ModelGroup[vector2.size()];
        for (int i = 0; i < modelGroupArray.length; ++i) {
            modelGroupArray[i] = (ModelGroup)vector2.elementAt(i);
        }
        if (bl) {
            return new Sequence(modelGroupArray);
        }
        return new Choice(modelGroupArray);
    }

    private static int indexOfReferenceEnd(Vector vector, int n) {
        int n2 = 0;
        while (true) {
            Particle particle = (Particle)vector.elementAt(++n);
            if (particle.type == 0) {
                ++n2;
                continue;
            }
            if (particle.type == 5 && n2-- == 0) break;
        }
        return n;
    }

    static EnumGroup particlesToEnumGroup(Vector vector) {
        int n = vector.size();
        Vector<EnumValue> vector2 = new Vector<EnumValue>();
        for (int i = 0; i < n; ++i) {
            EnumGroupMember enumGroupMember = null;
            Particle particle = (Particle)vector.elementAt(i);
            switch (particle.type) {
                case 0: {
                    if (particle.entity.semantic != 3) break;
                    enumGroupMember = new EnumGroupRef(particle.entity.name, particle.entity.enumGroup);
                    int n2 = 0;
                    while (true) {
                        particle = (Particle)vector.elementAt(++i);
                        if (particle.type == 0) {
                            ++n2;
                            continue;
                        }
                        if (particle.type == 5 && n2-- == 0) break;
                    }
                    break;
                }
                case 3: {
                    enumGroupMember = new EnumValue(particle.value);
                }
            }
            if (enumGroupMember == null) continue;
            vector2.addElement((EnumValue)enumGroupMember);
        }
        EnumGroupMember[] enumGroupMemberArray = new EnumGroupMember[vector2.size()];
        for (int i = 0; i < enumGroupMemberArray.length; ++i) {
            enumGroupMemberArray[i] = (EnumGroupMember)vector2.elementAt(i);
        }
        return new EnumGroup(enumGroupMemberArray);
    }

    static void examineElementNames(DtdBuilder dtdBuilder, Enumeration enumeration) {
        Entity entity = null;
        while (enumeration.hasMoreElements()) {
            Particle particle = (Particle)enumeration.nextElement();
            Entity entity2 = null;
            switch (particle.type) {
                case 0: {
                    entity2 = particle.entity;
                    break;
                }
                case 2: {
                    dtdBuilder.noteElementName(particle.value, entity);
                    break;
                }
                case 1: {
                    Particle.examineElementNames(dtdBuilder, particle.particles.elements());
                }
            }
            entity = entity2;
        }
    }
}

