# Python Social Auth - Django

Python Social Auth is an easy to setup social authentication/registration
mechanism with support for several frameworks and auth providers.

## Description

This is the [Django](https://www.djangoproject.com/) component of the
[python-social-auth ecosystem](https://github.com/python-social-auth/social-core),
it implements the needed functionality to integrate
[social-auth-core](https://github.com/python-social-auth/social-core)
in a Django based project.

## Django version

This project will focus on the currently supported Django releases as
stated on the [Django Project Supported Versions table](https://www.djangoproject.com/download/#supported-versions).

Backward compatibility with unsupported versions won't be enforced.

## Documentation

Project documentation is available at https://python-social-auth.readthedocs.io/.

## Setup

```shell
$ pip install social-auth-app-django
```

## Contributing

Contributions are welcome!

Only the core and Django modules are currently in development. All others are in maintenance only mode, and maintainers are especially welcome there.

See the [https://github.com/python-social-auth/.github/blob/main/CONTRIBUTING.md](CONTRIBUTING.md) document for details.

## Versioning

This project follows [Semantic Versioning 2.0.0](https://semver.org/spec/v2.0.0.html).

## License

This project follows the BSD license. See the [LICENSE](LICENSE) for details.

## Donations

This project welcomes donations to make the development sustainable, you can fund Python Social Auth on following platforms:

- [GitHub Sponsors](https://github.com/sponsors/python-social-auth/)
- [Open Collective](https://opencollective.com/python-social-auth)
