3.5 Teil-Samples

# Teil-Samples

Dieses Kapitel schließt unsere Erkundung von Sonic Pi's Sample-Player 
ab. Fassen wir noch einmal zusammen. Wir haben uns angesehen, wie wir 
Samples abspielen können:

```
sample :loop_amen
```

Dann haben wir gesehen, dass wir die Samplerate ändern können - etwa um 
ein Sample mit halber Geschwindigkeit abzuspielen:

```
sample :loop_amen, rate: 0.5
```

Als nächstes haben wir einen Blick darauf geworfen, wie wir ein Sample 
ein- und ausblenden lassen (hier zum Beispiel mit halber
Geschwindigkeit):

```
sample :loop_amen, rate: 0.5, attack: 1
```

Wir haben uns auch angeschaut, wie wir ein Sample am Anfang perkussiver 
klingen lassen können, indem wir `sustain:` ausdrücklich einen Wert 
zuweisen, und sowohl der Attack als auch der Release kurze Werte 
bekommen:

```
sample :loop_amen, rate: 2, attack: 0.01, sustain: 0, release: 0.35
```

Wäre es aber nicht toll, wenn wir ein Sample nicht immer vom Anfang 
starten lassen müssten? Wäre es nicht auch prima, wenn das Ende des 
klingenden Sample nicht immer seinem wirklichen Ende entsprechen 
müsste?

## Einen Startpunkt bestimmen

Es ist möglich, einen beliebigen Startpunkt eines Sample als Wert 
zwischen 0 und auszuwählen, wobei 0 der Anfang, 1 das Ende und 0.5 die 
Mitte des Samples darstellt. Spielen wir die zweite Hälfte des Amen 
Break:

```
sample :loop_amen, start: 0.5
```

Oder vielleicht das letzte Viertel des Sample:

```
sample :loop_amen, start: 0.75
```

## Einen Endpunkt bestimmen

Gleichermaßen können wir über einen Wert zwischen 0 und 1 einen 
beliebigen Endpunkt im Sample festlegen. Beenden wir den Amen-Break 
nach der ersten Hälfte:

```
sample :loop_amen, finish: 0.5
```

## Start- und Endpunkt bestimmen

Natürlich können das auch kombinieren und einen beliebigen Abschnitt 
des Sample abspielen. Wie wäre es mit einem kurzen Abschnitt aus der 
Mitte:

```
sample :loop_amen, start: 0.4, finish: 0.6
```

Was passiert, wenn wir eine Startposition nach der Endposition 
auswählen?

```
sample :loop_amen, start: 0.6, finish: 0.4
```

Cool! Dann spielt es rückwärts!

## In Kombination mit der Samplerate

Diese neue Fähigkeit, beliebige Abschnitte eines Klangs zu spielen,
lässt sich mit unserem Freund `rate:` kombinieren. Zum Beispiel können 
wir einen sehr kurzen Abschnitt des Amen-Breaks sehr langsam spielen:

```
sample :loop_amen, start: 0.5, finish: 0.7, rate: 0.2
```

## In Kombination mit Hüllkurven

Schließlich können wir all dies mit unseren ADSR-Hüllkurven kombinieren 
und interessante Ergebnisse damit erzielen:

```
sample :loop_amen, start: 0.5, finish: 0.8, rate: -0.2, attack: 0.3, release: 1
```

Jetzt leg los und hab Spaß, Samples mit diesem Zeug aufzumischen...
