9.3 Mehrere Live-Loops

# Mehrere Live-Loops

Schau Dir den folgenden Live-Loop an:

```
live_loop :foo do
  play 50
  sleep 1
end
```

Vielleicht fragst Du Dich, warum er den Namen `:foo` braucht. Dieser 
Name ist wichtig, weil er sicherstellt, dass sich dieser Live-Loop von 
allen anderen Live-Loops unterscheidet.

*Es können nie zwei Live-Loops mit dem selben Namen gleichzeitig 
laufen*.

Wir müssen also unterschiedliche Namen vergeben, damit wir mehrere
gleichzeitig laufende Live-Loops spielen können. 

```
live_loop :foo do
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end

live_loop :bar do
  sample :bd_haus
  sleep 0.5
end
```

Jetzt kannst Du beide Live-Loops unabhängig voneinander verändern 
und alles funktioniert - einfach so.

## Live-Loops synchronisieren

Du hast vielleicht schon bemerkt, dass Live-Loops automatisch mit dem 
Thread-Cue-Mechanismus arbeiten, den wir uns im Abschnitt über
Thread-Synchronisation bereits angeschaut haben.

In jedem Durchlauf des Live-Loops generiert er ein neues `cue`-Event 
mit dem Namen des Loops. Anhand dieser Cues können wir für unsere Loops 
mit `sync` sicherstellen, dass sie zueinander synchron laufen, ohne
dass wir das Abspielen zwischendurch stoppen müssen.

Schau Dir diesen schlecht synchronisierten Code an:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.4
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

Jetzt versuchen wir, das Timing zu korrigieren ohne den Loop zu 
stoppen. Zuerst reparieren wir den Loop `:foo`, indem wir die 
Sleep-Dauer zu einem Faktor von 1 machen - dafür funktioniert zum 
Beispiel `0.5`.

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

Damit sind wir aber noch nicht ganz fertig. Du hörst schon, dass die 
Beats nicht so recht zusammenpassen. Der Grund dafür ist, dass diese 
Loops *out of phase* sind. Das können wir reparieren, indem wir 
einen Loop mit dem anderen synchronisieren:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sync :foo
  sample :bd_haus
  sleep 1
end
```

Wow, jetzt passt alles genau zusammen - und das, ohne dass wir die 
Loops anhalten mussten.

Jetzt fangt an und coded live in Live-Loops!
