7.3 パラメータのスライド

# パラメータのスライド

シンセやエフェクトの引数を探索しながら、`_slide`で終わるパラメータがあることに気づいたかもしれません。それらを呼び出しても、何の効果を示さなかった可能性があります。これは正常のパラメータではなく、前回のセクションで紹介したように、シンセを制御するときのみ動作をする特別なパラメータです。

次の例を考えてみましょう。

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

ここでは、各`control`の呼び出し後、すぐにシンセのピッチの変更を聞くことができますが、ピッチが変化する間にスライドさせたくなるかもしれません。その場合、スライドを追加するために、`note:`パラメータを制御するように、シンセの`note_slide`パラメータを追加する必要があります。

```
s = play 60, release: 5, note_slide: 1
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

`control`の呼び出しの間の音程が滑らかに繋がっていることがわかるはずです。いい感じではないでしょうか。`note_slide: 0.2` よりも短いスライド時間を使うことで、スライドをスピードアップすることができますし、もっと長い時間を使ってテンポを遅くすることができます。

## ネバネバするスライド

一度、実行しているシンセの `_slidee`パラメータを設定したら、それは記憶され、
対応するパラメータがスライドする度に使用されます。
スライドを停止するためには、次の`control`を呼び出す前に`0`に`_slide`値を設定する必要があります。

## エフェクト・パラメータのスライド

また、エフェクトパラメータをスライドさせることも可能です。

```
with_fx :wobble, phase: 1, phase_slide: 5 do |e|
 use_synth :dsaw
 play 50, release: 5
 control e, phase: 0.025
end
```

さあ、操作に従って、滑らかな変調を楽しみましょう。
