use core:lang;
use lang:bs:macro;

// Custom highlighting for Basic Storm. Allows specifying what production the language starts at.
// Additional parameters may be "use=<package>" for additional syntax includes.
InfoParser? highlight_bsfragment(Str[] parts) on Compiler {
	Str rule = parts[0];
	parts.remove(0);
	highlightBS(rule, parts);
}

// Custom highlighting for a single segment.
InfoParser? highlight_bsstmt(Str[] parts) on Compiler {
	highlightBS(named{BSStmtList}, parts);
}

// Custom highlighting for class members.
InfoParser? highlight_bsclass(Str[] parts) on Compiler {
	highlightBS(named{lang:bs:SClassBody}, parts);
}


// The main logic:
InfoParser? highlightBS(Str rootRule, Str[] parts) on Compiler {
	// Find the root rule:
	Scope scope = rootScope.child(named{lang:bs});
	unless (rule = scope.find(parseSimpleName(rootRule)) as lang:bnf:Rule)
		return null;

	highlightBS(rule, parts);
}

// Supply a pre-resolved Rule:
InfoParser highlightBS(lang:bnf:Rule rootRule, Str[] parts) on Compiler {
	InfoParser parser(rootRule);

	// Add the default syntax in case the root rule is not already in the proper package.
	parser.addSyntax(named{lang:bs});

	// Add any other syntax we were asked to add.
	for (part in parts) {
		if (part.startsWith("use=")) {
			if (pkg = rootScope.find(parseSimpleName(part.cut(part.begin + 4))) as core:lang:Package) {
				parser.addSyntax(pkg);
			} else {
				print("WARNING: Could not find package for ${part}");
			}
		} else if (part == "placeholders") {
			parser.addSyntax(named{placeholders});
		}
	}

	return parser;
}
