/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-explore.
 * 
 *   Swac-explore is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-explore is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-explore.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _SQLITE3PP_HH
#define _SQLITE3PP_HH

#include <sqlite3.h>
#include <vector>
#include <glibmm/ustring.h>

typedef std::vector<std::string> SqlQueryResultRaw;
typedef std::vector<SqlQueryResultRaw> SqlQueryResult;
class SqlQuery;

class SqlDatabase { 
	friend class SqlQuery;
private:
	sqlite3 *handle;
public:
	void errorMsg();
	bool open(Glib::ustring const path);
	bool close();
	int lastInsertRowId();
	int changes();
	Glib::ustring str(Glib::ustring str);

	bool exec(Glib::ustring const sql, int (*callback)(void*,int,char**,char**), void *params);
	bool exec(Glib::ustring const sql, SqlQueryResult &result);
	bool exec(Glib::ustring const sql);
};

class SqlQuery {
private:
	sqlite3_stmt *handle;
	SqlDatabase *database;
public:
	SqlQuery(SqlDatabase *parent);
	~SqlQuery();

	int prepare(Glib::ustring const sql);
	int step();
	int reset();
	bool exec(SqlQueryResult &result);

	int bind(Glib::ustring const value, int const n);
	int bind(int const value, int const n);
	int bindParameterCount();
	int clearBindings();

	int columnCount();
	Glib::ustring columnName(int const iCol);
	Glib::ustring columnText(int const iCol);
	int columnInt(int const iCol);
	double columnDouble(int const iCol);
};

#endif
