from _typeshed import Incomplete
from collections.abc import Mapping
from typing_extensions import deprecated

from jwcrypto.common import JWException, JWKeyNotFound
from jwcrypto.jwk import JWK, JWKSet

JWTClaimsRegistry: Mapping[str, str]
JWT_expect_type: bool

class JWTExpired(JWException):
    def __init__(self, message: str | None = None, exception: BaseException | None = None) -> None: ...

class JWTNotYetValid(JWException):
    def __init__(self, message: str | None = None, exception: BaseException | None = None) -> None: ...

class JWTMissingClaim(JWException):
    def __init__(self, message: str | None = None, exception: BaseException | None = None) -> None: ...

class JWTInvalidClaimValue(JWException):
    def __init__(self, message: str | None = None, exception: BaseException | None = None) -> None: ...

class JWTInvalidClaimFormat(JWException):
    def __init__(self, message: str | None = None, exception: BaseException | None = None) -> None: ...

@deprecated("")
class JWTMissingKeyID(JWException):
    def __init__(self, message: str | None = None, exception: BaseException | None = None) -> None: ...

class JWTMissingKey(JWKeyNotFound):
    def __init__(self, message: str | None = None, exception: BaseException | None = None) -> None: ...

class JWT:
    deserializelog: Incomplete
    def __init__(
        self,
        header: dict[Incomplete, Incomplete] | str | None = None,
        claims: dict[Incomplete, Incomplete] | str | None = None,
        jwt: Incomplete | None = None,
        key: JWK | JWKSet | None = None,
        algs: Incomplete | None = None,
        default_claims: Incomplete | None = None,
        check_claims: Incomplete | None = None,
        expected_type: Incomplete | None = None,
    ) -> None: ...
    @property
    def header(self): ...
    @header.setter
    def header(self, h) -> None: ...
    @property
    def claims(self): ...
    @claims.setter
    def claims(self, data) -> None: ...
    @property
    def token(self): ...
    @token.setter
    def token(self, t) -> None: ...
    @property
    def leeway(self): ...
    @leeway.setter
    def leeway(self, lwy) -> None: ...
    @property
    def validity(self): ...
    @validity.setter
    def validity(self, v) -> None: ...
    @property
    def expected_type(self): ...
    @expected_type.setter
    def expected_type(self, v) -> None: ...
    def norm_typ(self, val): ...
    def make_signed_token(self, key) -> None: ...
    def make_encrypted_token(self, key) -> None: ...
    def validate(self, key) -> None: ...
    def deserialize(self, jwt, key: Incomplete | None = None) -> None: ...
    def serialize(self, compact: bool = True): ...
    @classmethod
    def from_jose_token(cls, token): ...
    def __eq__(self, other: object) -> bool: ...
