/* libwnck-3.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Wnck", gir_namespace = "Wnck", gir_version = "3.0", lower_case_cprefix = "wnck_")]
namespace Wnck {
	namespace Version {
		[CCode (cheader_filename = "libwnck/libwnck.h", cname = "WNCK_MAJOR_VERSION")]
		public const int MAJOR_VERSION;
		[CCode (cheader_filename = "libwnck/libwnck.h", cname = "WNCK_MICRO_VERSION")]
		public const int MICRO_VERSION;
		[CCode (cheader_filename = "libwnck/libwnck.h", cname = "WNCK_MINOR_VERSION")]
		public const int MINOR_VERSION;
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_action_menu_get_type ()")]
	public class ActionMenu : Gtk.Menu, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ActionMenu (Wnck.Window window);
		[NoAccessorMethod]
		public void* window { get; construct; }
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_application_get_type ()")]
	public class Application : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Application ();
		public static unowned Wnck.Application @get (ulong xwindow);
		public unowned Gdk.Pixbuf get_icon ();
		public bool get_icon_is_fallback ();
		public unowned string get_icon_name ();
		public unowned Gdk.Pixbuf get_mini_icon ();
		public int get_n_windows ();
		public unowned string get_name ();
		public int get_pid ();
		public unowned string get_startup_id ();
		public unowned GLib.List<Wnck.Window> get_windows ();
		public ulong get_xid ();
		public virtual signal void icon_changed ();
		public virtual signal void name_changed ();
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_class_group_get_type ()")]
	public class ClassGroup : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ClassGroup ();
		public static unowned Wnck.ClassGroup @get (string id);
		public unowned Gdk.Pixbuf get_icon ();
		public unowned string get_id ();
		public unowned Gdk.Pixbuf get_mini_icon ();
		public unowned string get_name ();
		public unowned string get_res_class ();
		public unowned GLib.List<Wnck.Window> get_windows ();
		public virtual signal void icon_changed ();
		public virtual signal void name_changed ();
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_pager_get_type ()")]
	public class Pager : Gtk.Widget, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Pager ();
		public void set_display_mode (Wnck.PagerDisplayMode mode);
		public bool set_n_rows (int n_rows);
		public bool set_orientation (Gtk.Orientation orientation);
		public void set_shadow_type (Gtk.ShadowType shadow_type);
		public void set_show_all (bool show_all_workspaces);
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_screen_get_type ()")]
	public class Screen : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Screen ();
		public void calc_workspace_layout (int num_workspaces, int space_index, Wnck.WorkspaceLayout layout);
		public void change_workspace_count (int count);
		public void force_update ();
		public static void free_workspace_layout (Wnck.WorkspaceLayout layout);
		public static unowned Wnck.Screen @get (int index);
		public unowned Wnck.Window get_active_window ();
		public unowned Wnck.Workspace get_active_workspace ();
		public ulong get_background_pixmap ();
		public static unowned Wnck.Screen get_default ();
		public static unowned Wnck.Screen get_for_root (ulong root_window_id);
		public int get_height ();
		public int get_number ();
		public unowned Wnck.Window get_previously_active_window ();
		public bool get_showing_desktop ();
		public int get_width ();
		public unowned string get_window_manager_name ();
		public unowned GLib.List<Wnck.Window> get_windows ();
		public unowned GLib.List<Wnck.Window> get_windows_stacked ();
		public unowned Wnck.Workspace get_workspace (int workspace);
		public int get_workspace_count ();
		public unowned GLib.List<Wnck.Workspace> get_workspaces ();
		public void move_viewport (int x, int y);
		public bool net_wm_supports (string atom);
		public void release_workspace_layout (int current_token);
		public void toggle_showing_desktop (bool show);
		public int try_set_workspace_layout (int current_token, int rows, int columns);
		public virtual signal void active_window_changed (Wnck.Window previous_window);
		public virtual signal void active_workspace_changed (Wnck.Workspace previous_workspace);
		public virtual signal void application_closed (Wnck.Application app);
		public virtual signal void application_opened (Wnck.Application app);
		public virtual signal void background_changed ();
		public virtual signal void class_group_closed (Wnck.ClassGroup class_group);
		public virtual signal void class_group_opened (Wnck.ClassGroup class_group);
		public virtual signal void showing_desktop_changed ();
		public virtual signal void viewports_changed ();
		public virtual signal void window_closed (Wnck.Window window);
		public virtual signal void window_manager_changed ();
		public virtual signal void window_opened (Wnck.Window window);
		public virtual signal void window_stacking_changed ();
		public virtual signal void workspace_created (Wnck.Workspace space);
		public virtual signal void workspace_destroyed (Wnck.Workspace space);
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_selector_get_type ()")]
	public class Selector : Gtk.MenuBar, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Selector ();
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_tasklist_get_type ()")]
	public class Tasklist : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Tasklist ();
		public int get_size_hint_list (int n_elements);
		public void set_button_relief (Gtk.ReliefStyle relief);
		public void set_grouping (Wnck.TasklistGroupingType grouping);
		public void set_grouping_limit (int limit);
		public void set_include_all_workspaces (bool include_all_workspaces);
		public void set_switch_workspace_on_unminimize (bool switch_workspace_on_unminimize);
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_window_get_type ()")]
	public class Window : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Window ();
		public void activate (uint32 timestamp);
		public void activate_transient (uint32 timestamp);
		public void close (uint32 timestamp);
		public static unowned Wnck.Window @get (ulong xwindow);
		public Wnck.WindowActions get_actions ();
		public unowned Wnck.Application get_application ();
		public unowned Wnck.ClassGroup get_class_group ();
		public unowned string get_class_group_name ();
		public unowned string get_class_instance_name ();
		public void get_client_window_geometry (out int xp, out int yp, out int widthp, out int heightp);
		public void get_geometry (out int xp, out int yp, out int widthp, out int heightp);
		public ulong get_group_leader ();
		public unowned Gdk.Pixbuf get_icon ();
		public bool get_icon_is_fallback ();
		public unowned string get_icon_name ();
		public unowned Gdk.Pixbuf get_mini_icon ();
		public unowned string get_name ();
		public int get_pid ();
		public unowned Wnck.Screen get_screen ();
		public unowned string get_session_id ();
		public unowned string get_session_id_utf8 ();
		public int get_sort_order ();
		public Wnck.WindowState get_state ();
		public unowned Wnck.Window get_transient ();
		public Wnck.WindowType get_window_type ();
		public unowned Wnck.Workspace get_workspace ();
		public ulong get_xid ();
		public bool has_icon_name ();
		public bool has_name ();
		public bool is_above ();
		public bool is_active ();
		public bool is_below ();
		public bool is_fullscreen ();
		public bool is_in_viewport (Wnck.Workspace workspace);
		public bool is_maximized ();
		public bool is_maximized_horizontally ();
		public bool is_maximized_vertically ();
		public bool is_minimized ();
		public bool is_most_recently_activated ();
		public bool is_on_workspace (Wnck.Workspace workspace);
		public bool is_pinned ();
		public bool is_shaded ();
		public bool is_skip_pager ();
		public bool is_skip_tasklist ();
		public bool is_sticky ();
		public bool is_visible_on_workspace (Wnck.Workspace workspace);
		public void keyboard_move ();
		public void keyboard_size ();
		public void make_above ();
		public void make_below ();
		public void maximize ();
		public void maximize_horizontally ();
		public void maximize_vertically ();
		public void minimize ();
		public void move_to_workspace (Wnck.Workspace space);
		public bool needs_attention ();
		public bool or_transient_needs_attention ();
		public void pin ();
		public void set_fullscreen (bool fullscreen);
		public void set_geometry (Wnck.WindowGravity gravity, Wnck.WindowMoveResizeMask geometry_mask, int x, int y, int width, int height);
		public void set_icon_geometry (int x, int y, int width, int height);
		public void set_skip_pager (bool skip);
		public void set_skip_tasklist (bool skip);
		public void set_sort_order (int order);
		public void set_window_type (Wnck.WindowType wintype);
		public void shade ();
		public void stick ();
		public bool transient_is_most_recently_activated ();
		public void unmake_above ();
		public void unmake_below ();
		public void unmaximize ();
		public void unmaximize_horizontally ();
		public void unmaximize_vertically ();
		public void unminimize (uint32 timestamp);
		public void unpin ();
		public void unshade ();
		public void unstick ();
		public virtual signal void actions_changed (Wnck.WindowActions changed_mask, Wnck.WindowActions new_actions);
		public virtual signal void geometry_changed ();
		public virtual signal void icon_changed ();
		public virtual signal void name_changed ();
		public virtual signal void state_changed (Wnck.WindowState changed_mask, Wnck.WindowState new_state);
		public virtual signal void workspace_changed ();
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", type_id = "wnck_workspace_get_type ()")]
	public class Workspace : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Workspace ();
		public void activate (uint32 timestamp);
		public void change_name (string name);
		public int get_height ();
		public int get_layout_column ();
		public int get_layout_row ();
		public unowned string get_name ();
		public unowned Wnck.Workspace get_neighbor (Wnck.MotionDirection direction);
		public int get_number ();
		public unowned Wnck.Screen get_screen ();
		public int get_viewport_x ();
		public int get_viewport_y ();
		public int get_width ();
		public bool is_virtual ();
		public virtual signal void name_changed ();
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", has_type_id = false)]
	public struct ResourceUsage {
		public ulong total_bytes_estimate;
		public ulong pixmap_bytes;
		public uint n_pixmaps;
		public uint n_windows;
		public uint n_gcs;
		public uint n_pictures;
		public uint n_glyphsets;
		public uint n_fonts;
		public uint n_colormap_entries;
		public uint n_passive_grabs;
		public uint n_cursors;
		public uint n_other;
		[CCode (cname = "wnck_pid_read_resource_usage")]
		public static Wnck.ResourceUsage pid_read (Gdk.Display gdk_display, ulong pid);
		[CCode (cname = "wnck_xid_read_resource_usage")]
		public static Wnck.ResourceUsage xid_read (Gdk.Display gdk_display, ulong xid);
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", has_type_id = false)]
	public struct WorkspaceLayout {
		public int rows;
		public int cols;
		public int grid;
		public int grid_area;
		public int current_row;
		public int current_col;
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_CLIENT_TYPE_")]
	public enum ClientType {
		APPLICATION,
		PAGER
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_MOTION_")]
	public enum MotionDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_PAGER_DISPLAY_")]
	public enum PagerDisplayMode {
		NAME,
		CONTENT
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_TASKLIST_")]
	public enum TasklistGroupingType {
		NEVER_GROUP,
		AUTO_GROUP,
		ALWAYS_GROUP
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_WINDOW_ACTION_")]
	[Flags]
	public enum WindowActions {
		MOVE,
		RESIZE,
		SHADE,
		STICK,
		MAXIMIZE_HORIZONTALLY,
		MAXIMIZE_VERTICALLY,
		CHANGE_WORKSPACE,
		CLOSE,
		UNMAXIMIZE_HORIZONTALLY,
		UNMAXIMIZE_VERTICALLY,
		UNSHADE,
		UNSTICK,
		MINIMIZE,
		UNMINIMIZE,
		MAXIMIZE,
		UNMAXIMIZE,
		FULLSCREEN,
		ABOVE,
		BELOW
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_WINDOW_GRAVITY_")]
	public enum WindowGravity {
		CURRENT,
		NORTHWEST,
		NORTH,
		NORTHEAST,
		WEST,
		CENTER,
		EAST,
		SOUTHWEST,
		SOUTH,
		SOUTHEAST,
		STATIC
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_WINDOW_CHANGE_")]
	[Flags]
	public enum WindowMoveResizeMask {
		X,
		Y,
		WIDTH,
		HEIGHT
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_WINDOW_STATE_")]
	[Flags]
	public enum WindowState {
		MINIMIZED,
		MAXIMIZED_HORIZONTALLY,
		MAXIMIZED_VERTICALLY,
		SHADED,
		SKIP_PAGER,
		SKIP_TASKLIST,
		STICKY,
		HIDDEN,
		FULLSCREEN,
		DEMANDS_ATTENTION,
		URGENT,
		ABOVE,
		BELOW
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cprefix = "WNCK_WINDOW_")]
	public enum WindowType {
		NORMAL,
		DESKTOP,
		DOCK,
		DIALOG,
		TOOLBAR,
		MENU,
		UTILITY,
		SPLASHSCREEN
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cname = "_WnckLayoutCorner", cprefix = "WNCK_LAYOUT_CORNER_")]
	public enum _LayoutCorner {
		TOPLEFT,
		TOPRIGHT,
		BOTTOMRIGHT,
		BOTTOMLEFT
	}
	[CCode (cheader_filename = "libwnck/libwnck.h", cname = "_WnckLayoutOrientation", cprefix = "WNCK_LAYOUT_ORIENTATION_")]
	public enum _LayoutOrientation {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "libwnck/libwnck.h")]
	public static void set_client_type (Wnck.ClientType ewmh_sourceindication_client_type);
}
