/***************************************************************************
         dcusercommandedit.h  -  Valknut User Command Editor Dialog
                             -------------------
    begin                : Sun May 25 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCUSERCOMMANDEDITOR_H
#define DCUSERCOMMANDEDITOR_H

#include <QDialog>

#include "ui/DCDialogUserCommandEditor.h"

class DC_UserMenuCommand;

/**
 * @author Edward Sheldrake
 */
class DCUserCommandEditor: public QDialog, private Ui::DCDialogUserCommandEditor {
Q_OBJECT

public:
	/** Constructor */
	DCUserCommandEditor( QWidget * parent );
	/** Destructor */
	virtual ~DCUserCommandEditor();
	
	/** Initialises the values in the dialog to the given usercommand */
	void SetUMC( DC_UserMenuCommand * usercommand );
	/**
	 * Creates a new DC_UserMenuCommand object, fills in the values
	 * to what has been entered, and returns it.
	 */
	DC_UserMenuCommand * GetUMC();

public slots:
	/** checks name/command are not empty */
	virtual void accept();

private:
	/** Get command prefix e.g. "<%[myNI]> " */
	QString getCurrentPrefix();
	/** Get command suffix e.g. "|" */
	QString getCurrentSuffix();

private slots:
	/** the type of the command was changed, enable/disable items */
	void slotTypeChanged( bool checked );
	/** the command text changed, update preview */
	void slotCommandChanged( const QString & text );
};

#endif // DCUSERCOMMANDEDITOR_H
