/*
 * ============
 * VDK Builder
 * Version 1.2
 * Revision 4
 * November 2000
 * ============
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_GNOME
#if ENABLE_NLS
#include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
#else
#define _(str) str
#define N_(str) str 
#endif
#endif
#include <vdkb2/vdkb_edhint.h>
#include <vdkb2/vdkb.h>
#include <./pixmaps/add.xpm>
#include <./pixmaps/trash.xpm>
#include <./pixmaps/edit.xpm>
#include <./pixmaps/savefile.xpm>
#include <./pixmaps/quit.xpm>
static char buff[256];
extern HintBTree* hint_tree;
extern VDKBuilder* TheApp;
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(VdkbEdHintForm,VDKForm);
DEFINE_EVENT_LIST(VdkbEdHintForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(VdkbEdHintForm,VDKForm)
ON_SIGNAL(addButton,clicked_signal,OnaddButtonClick),
ON_SIGNAL(removeButton,clicked_signal,OnremoveButtonClick),
ON_SIGNAL(changeButton,clicked_signal,OnchangeButtonClick),
ON_SIGNAL(closeandsaveButton,clicked_signal,OncloseandsaveButtonClick),
ON_SIGNAL(quitButton,clicked_signal,OnquitButtonClick),
ON_SIGNAL(customlist0,select_row_signal,Oncustomlist0SelectRow),
ON_SIGNAL(text0,realize_signal,Ontext0Realize),
ON_SIGNAL(key,changed_signal,OnKeyChanged)
END_SIGNAL_MAP

// VdkbEdHint MAIN FORM  CLASS
/*
main form constructor
*/
VdkbEdHintForm::VdkbEdHintForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
}

/*
main form destructor
*/
VdkbEdHintForm::~VdkbEdHintForm()
{
}

/*
main form setup
*/
void
VdkbEdHintForm::Setup(void)
{
  GUISetup();
  // put your code below here
  // load keywords on custom list
  LoadList();
}

void
VdkbEdHintForm::LoadList(void)
{

 if(hint_tree)
    {
      customlist0->Freeze();
      customlist0->Clear();
      HintBTree::Iterator bi(*hint_tree);
      for(;bi;bi++)
	{
	  char* key = (char*) bi.current().key;
	  customlist0->AddRow(&key);
	}
      customlist0->Thaw();
    }
}

//signal response method
bool
VdkbEdHintForm::OnKeyChanged(VDKObject* sender)
{
  addButton->Enabled = strlen(key->Text) > 0;
  return true;
}
//signal response method
bool
VdkbEdHintForm::Ontext0Realize(VDKObject* sender)
{
  text0->Font = new VDKFont(this,"courier medium 11");
  customlist0->SelectRow(0,0);
  return true;
}

//signal response method
bool
VdkbEdHintForm::Oncustomlist0SelectRow(VDKObject* sender)
{
  int row = customlist0->Selected.Row();
  if(row >= 0)
    {
      VDKString key = customlist0->Tuples[row][0];
      VDKHint h((char*) key,"");
      VDKHint *hint = hint_tree->find(h);
      if(hint)
	{
	  text0->Clear();
	  text0->TextInsert((char*) hint->hint);
	}
    }
  return true;
}
//signal response method
bool
VdkbEdHintForm::OnquitButtonClick(VDKObject* sender)
{
  Close();
  return true;
}

//signal response method
bool
VdkbEdHintForm::OncloseandsaveButtonClick(VDKObject* sender)
{
  Save();
  Close();
  return true;
}

// pay attention defines duplicate from vdkb.cc
#define HINT  "HINT{"
#define HINT_END  "}"
#define HINT_KEY   "KEY["
#define TEXT_KEY   "TEXT["
#define KEY_END  "]"
/*
 */
bool
VdkbEdHintForm::Save(void)
{
  FILE* fp;
  sprintf(buff,"%s/.vdkb2/%s",
	  (char*) TheApp->user_home, VDKB_HINT_FILE);
  if ( !(fp = fopen(buff,"w+")) )
    return false;
  if(hint_tree)
    {
      HintBTree::Iterator bi(*hint_tree);
      for(;bi;bi++)
	{
	  fprintf(fp,"%s\n%s%s%s\n%s%s%s\n%s\n",
		  HINT,
		  HINT_KEY,
		  (char*) bi.current().key,
		  KEY_END,
		  TEXT_KEY,
		  (char*) bi.current().hint,
		  KEY_END,
		  HINT_END);
	}
    }
  fclose(fp);
  return true;
}
//signal response method
bool
VdkbEdHintForm::OnchangeButtonClick(VDKObject* sender)
{
  int row = customlist0->Selected.Row();
  if(row >= 0)
    {
      VDKString key = customlist0->Tuples[row][0];
      VDKHint h((char*) key,"");
      VDKHint *hint = hint_tree->find(h);
      if(hint)
	{
	  char* hint_text = text0->GetChars(0,-1);
	  if(strlen(hint_text))
	    hint->hint = hint_text;
	  g_free(hint_text);
	}
    }
  return true;
}

//signal response method
bool
VdkbEdHintForm::OnremoveButtonClick(VDKObject* sender)
{
  int row = customlist0->Selected.Row();
  if(row >= 0)
    {
      VDKString key = customlist0->Tuples[row][0];
      VDKHint h((char*) key,"");
      VDKHint *hint = hint_tree->find(h);
      if(hint)
	  hint_tree->unlink(*hint);
      LoadList();
      customlist0->SelectRow(0,0);
    }
  return true;
}

//signal response method
bool
VdkbEdHintForm::OnaddButtonClick(VDKObject* sender)
{
  char* key_text = key->Text;
  char* hint_text = text0->GetChars(0,-1);
  if(strlen(key_text) && strlen(hint_text))
    {
      VDKHint h(key_text,hint_text);
      VDKHint* found = hint_tree->find(h);
      if(!found)
	{
	  hint_tree->add(h);
	  LoadList();
	  Select(key_text);
	  key->Text = "";
	}
      else
	TheApp->VDKMessageBox(APPNAME,
	   _("Hint key already here"),
          VDK_ICONINFORMATION|VDK_OK,
	  _(user_messages[user_ok]),
	  NULL,
	  3000
	  );
    }
  return true;
}

void
VdkbEdHintForm::Select(const char* key_text)
{
  int t = 0;
  VDKString s_key = VDKString(key_text);
  for(;customlist0->Tuples.size();t++)
    {
      if (customlist0->Tuples[t][0] == s_key)
	{
	  customlist0->SelectRow(t,0);
	  return;
	}
    }
  customlist0->SelectRow(0,0);
}

/*
main form setup
*/
void
VdkbEdHintForm::GUISetup(void)
{
  SetSize(-1,350);
  Title = _("VDKBuilder Hints editor");
  hbox4 = new VDKBox(this,h_box);
  Add(hbox4,0,1,1,0);
  hbox4->BorderWidth(2);
  char* customlist0Titles[] = { _("Keywords") };
  customlist0 = new VDKCustomList(this,1, customlist0Titles,(GtkSelectionMode) 0);
  customlist0->SetSize(150,-1);
  customlist0->AutoResize = true;
  customlist0->BorderShadow = (GtkShadowType) shadow_in;
  hbox4->Add(customlist0,0,1,1,0);
  vbox2 = new VDKBox(this,v_box);
  hbox4->Add(vbox2,0,1,1,0);
  vbox2->BorderWidth(2);
  text0 = new VDKTextView(this);
  text0->SetSize(400,250);
  vbox2->Add(text0,0,1,1,0);
  table2 = new VDKTable(this,2,3,false);
  table2->RowSpacing = 2;
  table2->ColSpacing = 2;
  vbox2->Add(table2,0,1,1,0);
  table2->BorderWidth(2);

  vbox18 = new VDKBox(this,v_box);
  table2->AddToCell(vbox18,0,0);
  key = new VDKEntry(this);
  vbox18->Add(key,0,1,1,0);
  key->SetTip(_("Enter hint key here before add an hint"));
  vbox19 = new VDKBox(this,v_box);
  table2->AddToCell(vbox19,0,1);
  addButton = new VDKCustomButton(this,(const char**) add_xpm,_("_Add"),16,(GtkPositionType) 1);
  vbox19->Add(addButton,0,1,1,0);
  addButton->Enabled = false;

  vbox20 = new VDKBox(this,v_box);
  table2->AddToCell(vbox20,0,2);
  removeButton = new VDKCustomButton(this,(const char**) trash_xpm,_("_Remove"),16,(GtkPositionType) 1);
  vbox20->Add(removeButton,0,1,1,0);


  vbox21 = new VDKBox(this,v_box);
  table2->AddToCell(vbox21,1,0);
  changeButton = new VDKCustomButton(this,(const char**) edit_xpm, _("_Change"),16,(GtkPositionType) 1);
  vbox21->Add(changeButton,0,1,1,0);

  vbox22 = new VDKBox(this,v_box);
  table2->AddToCell(vbox22,1,1);
  closeandsaveButton = new VDKCustomButton(this,(const char**) savefile_xpm, 
					   _("_Save and quit"), 16,(GtkPositionType) 1);
  vbox22->Add(closeandsaveButton,0,1,1,0);

  vbox23 = new VDKBox(this,v_box);
  table2->AddToCell(vbox23,1,2);
  quitButton = new VDKCustomButton(this,(const char**) quit_xpm, _("_Quit"),16,(GtkPositionType) 1);
  vbox23->Add(quitButton,0,1,1,0);

}
