/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb2/vdkb_signal.h>
#include <vdkb2/vdkb_object.h>
static char buff[256];
/*
 */

VDKBSignal::VDKBSignal(char* name, VDKBObject* sender, char* nickname,
		       char* slot):
  signal(name),nickname(nickname),sender(sender)
{ 
  if(!slot)
    {
      sprintf(buff,"On%s%s", 
	      (char*) VDKBSignal::sender->Name(),
	      (char*) VDKBSignal::nickname);
    VDKBSignal::slot = buff;
    }
   connected = slotFixed = false;

}

bool 
VDKBSignal::operator==(VDKBSignal& p)
{ return 
    sender->Name() == p.sender->Name() && 
    signal == p.signal &&
    slot == p.slot; 
}


VDKBObject* 
VDKBSignal::Sender() 
{ 
return sender; 
}
