/*****************************************************************************
 * filters.h: VAAPI filters helper for VLC
 *****************************************************************************
 * Copyright (C) 2017 VLC authors, VideoLAN and VideoLabs
 *
 * Authors: Thomas Guillem <thomas@gllm.fr>
 *          Petri Hintukainen <phintuka@gmail.com>
 *          Victorien Le Couviour--Tuffet <victorien.lecouviour.tuffet@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#ifndef VLC_VAAPI_FILTERS_H
# define VLC_VAAPI_FILTERS_H

#include "vlc_vaapi.h"

/* chroma filters callbacks */
int  vlc_vaapi_OpenChroma(vlc_object_t *obj);
void vlc_vaapi_CloseChroma(vlc_object_t *obj);

/* Get and hold the VADisplay instance from a filter */
struct vlc_vaapi_instance *
vlc_vaapi_FilterHoldInstance(filter_t *filter, VADisplay *dpy);

void
vlc_vaapi_FilterReleaseInstance(filter_t *filter,
                                struct vlc_vaapi_instance *va_inst);

#endif /* VLC_VAAPI_FILTERS_H */
