/*
 * Copyright (C) 2017 Austin English
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef _NSERROR_H
#define _NSERROR_H

/* Facility codes */
#define FACILITY_NS_WIN32                                             0x7
#define FACILITY_NS                                                   0xD

/* Severity codes */
#define STATUS_SEVERITY_WARNING                                       0x2
#define STATUS_SEVERITY_SUCCESS                                       0x0
#define STATUS_SEVERITY_INFORMATIONAL                                 0x1
#define STATUS_SEVERITY_ERROR                                         0x3

/* Success events */
#define NS_S_CALLPENDING                                              _HRESULT_TYPEDEF_(0x000d0000)
#define NS_S_CALLABORTED                                              _HRESULT_TYPEDEF_(0x000d0001)
#define NS_S_STREAM_TRUNCATED                                         _HRESULT_TYPEDEF_(0x000d0002)

/* Warning events */
#define NS_W_SERVER_BANDWIDTH_LIMIT                                   _HRESULT_TYPEDEF_(0x800d0003)
#define NS_W_FILE_BANDWIDTH_LIMIT                                     _HRESULT_TYPEDEF_(0x800d0004)

/* Error events */
#define NS_E_NOCONNECTION                                             _HRESULT_TYPEDEF_(0xc00d0005)
#define NS_E_CANNOTCONNECT                                            _HRESULT_TYPEDEF_(0xc00d0006)
#define NS_E_CANNOTDESTROYTITLE                                       _HRESULT_TYPEDEF_(0xc00d0007)
#define NS_E_CANNOTRENAMETITLE                                        _HRESULT_TYPEDEF_(0xc00d0008)
#define NS_E_CANNOTOFFLINEDISK                                        _HRESULT_TYPEDEF_(0xc00d0009)
#define NS_E_CANNOTONLINEDISK                                         _HRESULT_TYPEDEF_(0xc00d000a)
#define NS_E_NOREGISTEREDWALKER                                       _HRESULT_TYPEDEF_(0xc00d000b)
#define NS_E_NOFUNNEL                                                 _HRESULT_TYPEDEF_(0xc00d000c)
#define NS_E_NO_LOCALPLAY                                             _HRESULT_TYPEDEF_(0xc00d000d)
#define NS_E_NETWORK_BUSY                                             _HRESULT_TYPEDEF_(0xc00d000e)
#define NS_E_TOO_MANY_SESS                                            _HRESULT_TYPEDEF_(0xc00d000f)
#define NS_E_ALREADY_CONNECTED                                        _HRESULT_TYPEDEF_(0xc00d0010)
#define NS_E_INVALID_INDEX                                            _HRESULT_TYPEDEF_(0xc00d0011)
#define NS_E_PROTOCOL_MISMATCH                                        _HRESULT_TYPEDEF_(0xc00d0012)
#define NS_E_TIMEOUT                                                  _HRESULT_TYPEDEF_(0xc00d0013)
#define NS_E_NET_WRITE                                                _HRESULT_TYPEDEF_(0xc00d0014)
#define NS_E_NET_READ                                                 _HRESULT_TYPEDEF_(0xc00d0015)
#define NS_E_DISK_WRITE                                               _HRESULT_TYPEDEF_(0xc00d0016)
#define NS_E_DISK_READ                                                _HRESULT_TYPEDEF_(0xc00d0017)
#define NS_E_FILE_WRITE                                               _HRESULT_TYPEDEF_(0xc00d0018)
#define NS_E_FILE_READ                                                _HRESULT_TYPEDEF_(0xc00d0019)
#define NS_E_FILE_NOT_FOUND                                           _HRESULT_TYPEDEF_(0xc00d001a)
#define NS_E_FILE_EXISTS                                              _HRESULT_TYPEDEF_(0xc00d001b)
#define NS_E_INVALID_NAME                                             _HRESULT_TYPEDEF_(0xc00d001c)
#define NS_E_FILE_OPEN_FAILED                                         _HRESULT_TYPEDEF_(0xc00d001d)
#define NS_E_FILE_ALLOCATION_FAILED                                   _HRESULT_TYPEDEF_(0xc00d001e)
#define NS_E_FILE_INIT_FAILED                                         _HRESULT_TYPEDEF_(0xc00d001f)
#define NS_E_FILE_PLAY_FAILED                                         _HRESULT_TYPEDEF_(0xc00d0020)
#define NS_E_SET_DISK_UID_FAILED                                      _HRESULT_TYPEDEF_(0xc00d0021)
#define NS_E_INDUCED                                                  _HRESULT_TYPEDEF_(0xc00d0022)
#define NS_E_CCLINK_DOWN                                              _HRESULT_TYPEDEF_(0xc00d0023)
#define NS_E_INTERNAL                                                 _HRESULT_TYPEDEF_(0xc00d0024)
#define NS_E_BUSY                                                     _HRESULT_TYPEDEF_(0xc00d0025)
#define NS_E_UNRECOGNIZED_STREAM_TYPE                                 _HRESULT_TYPEDEF_(0xc00d0026)
#define NS_E_NETWORK_SERVICE_FAILURE                                  _HRESULT_TYPEDEF_(0xc00d0027)
#define NS_E_NETWORK_RESOURCE_FAILURE                                 _HRESULT_TYPEDEF_(0xc00d0028)
#define NS_E_CONNECTION_FAILURE                                       _HRESULT_TYPEDEF_(0xc00d0029)
#define NS_E_SHUTDOWN                                                 _HRESULT_TYPEDEF_(0xc00d002a)
#define NS_E_INVALID_REQUEST                                          _HRESULT_TYPEDEF_(0xc00d002b)
#define NS_E_INSUFFICIENT_BANDWIDTH                                   _HRESULT_TYPEDEF_(0xc00d002c)
#define NS_E_NOT_REBUILDING                                           _HRESULT_TYPEDEF_(0xc00d002d)
#define NS_E_LATE_OPERATION                                           _HRESULT_TYPEDEF_(0xc00d002e)
#define NS_E_INVALID_DATA                                             _HRESULT_TYPEDEF_(0xc00d002f)
#define NS_E_FILE_BANDWIDTH_LIMIT                                     _HRESULT_TYPEDEF_(0xc00d0030)
#define NS_E_OPEN_FILE_LIMIT                                          _HRESULT_TYPEDEF_(0xc00d0031)
#define NS_E_BAD_CONTROL_DATA                                         _HRESULT_TYPEDEF_(0xc00d0032)
#define NS_E_NO_STREAM                                                _HRESULT_TYPEDEF_(0xc00d0033)
#define NS_E_STREAM_END                                               _HRESULT_TYPEDEF_(0xc00d0034)
#define NS_E_SERVER_NOT_FOUND                                         _HRESULT_TYPEDEF_(0xc00d0035)
#define NS_E_DUPLICATE_NAME                                           _HRESULT_TYPEDEF_(0xc00d0036)
#define NS_E_DUPLICATE_ADDRESS                                        _HRESULT_TYPEDEF_(0xc00d0037)
#define NS_E_BAD_MULTICAST_ADDRESS                                    _HRESULT_TYPEDEF_(0xc00d0038)
#define NS_E_BAD_ADAPTER_ADDRESS                                      _HRESULT_TYPEDEF_(0xc00d0039)
#define NS_E_BAD_DELIVERY_MODE                                        _HRESULT_TYPEDEF_(0xc00d003a)
#define NS_E_INVALID_CHANNEL                                          _HRESULT_TYPEDEF_(0xc00d003b)
#define NS_E_INVALID_STREAM                                           _HRESULT_TYPEDEF_(0xc00d003c)
#define NS_E_INVALID_ARCHIVE                                          _HRESULT_TYPEDEF_(0xc00d003d)
#define NS_E_NOTITLES                                                 _HRESULT_TYPEDEF_(0xc00d003e)
#define NS_E_INVALID_CLIENT                                           _HRESULT_TYPEDEF_(0xc00d003f)
#define NS_E_INVALID_BLACKHOLE_ADDRESS                                _HRESULT_TYPEDEF_(0xc00d0040)
#define NS_E_INCOMPATIBLE_FORMAT                                      _HRESULT_TYPEDEF_(0xc00d0041)
#define NS_E_INVALID_KEY                                              _HRESULT_TYPEDEF_(0xc00d0042)
#define NS_E_INVALID_PORT                                             _HRESULT_TYPEDEF_(0xc00d0043)
#define NS_E_INVALID_TTL                                              _HRESULT_TYPEDEF_(0xc00d0044)
#define NS_E_STRIDE_REFUSED                                           _HRESULT_TYPEDEF_(0xc00d0045)
#define NS_E_MMSAUTOSERVER_CANTFINDWALKER                             _HRESULT_TYPEDEF_(0xc00d0046)
#define NS_E_MAX_BITRATE                                              _HRESULT_TYPEDEF_(0xc00d0047)
#define NS_E_LOGFILEPERIOD                                            _HRESULT_TYPEDEF_(0xc00d0048)
#define NS_E_MAX_CLIENTS                                              _HRESULT_TYPEDEF_(0xc00d0049)
#define NS_E_LOG_FILE_SIZE                                            _HRESULT_TYPEDEF_(0xc00d004a)
#define NS_E_MAX_FILERATE                                             _HRESULT_TYPEDEF_(0xc00d004b)
#define NS_E_WALKER_UNKNOWN                                           _HRESULT_TYPEDEF_(0xc00d004c)
#define NS_E_WALKER_SERVER                                            _HRESULT_TYPEDEF_(0xc00d004d)
#define NS_E_WALKER_USAGE                                             _HRESULT_TYPEDEF_(0xc00d004e)

/* Monitor events */
#define NS_I_TIGER_START                                              _HRESULT_TYPEDEF_(0x400d004f)
#define NS_E_TIGER_FAIL                                               _HRESULT_TYPEDEF_(0xc00d0050)
#define NS_I_CUB_START                                                _HRESULT_TYPEDEF_(0x400d0051)
#define NS_I_CUB_RUNNING                                              _HRESULT_TYPEDEF_(0x400d0052)
#define NS_E_CUB_FAIL                                                 _HRESULT_TYPEDEF_(0xc00d0053)
#define NS_I_DISK_START                                               _HRESULT_TYPEDEF_(0x400d0054)
#define NS_E_DISK_FAIL                                                _HRESULT_TYPEDEF_(0xc00d0055)
#define NS_I_DISK_REBUILD_STARTED                                     _HRESULT_TYPEDEF_(0x400d0056)
#define NS_I_DISK_REBUILD_FINISHED                                    _HRESULT_TYPEDEF_(0x400d0057)
#define NS_I_DISK_REBUILD_ABORTED                                     _HRESULT_TYPEDEF_(0x400d0058)
#define NS_I_LIMIT_FUNNELS                                            _HRESULT_TYPEDEF_(0x400d0059)
#define NS_I_START_DISK                                               _HRESULT_TYPEDEF_(0x400d005a)
#define NS_I_STOP_DISK                                                _HRESULT_TYPEDEF_(0x400d005b)
#define NS_I_STOP_CUB                                                 _HRESULT_TYPEDEF_(0x400d005c)
#define NS_I_KILL_USERSESSION                                         _HRESULT_TYPEDEF_(0x400d005d)
#define NS_I_KILL_CONNECTION                                          _HRESULT_TYPEDEF_(0x400d005e)
#define NS_I_REBUILD_DISK                                             _HRESULT_TYPEDEF_(0x400d005f)
#define NS_W_UNKNOWN_EVENT                                            _HRESULT_TYPEDEF_(0x800d0060)
#define NS_E_MAX_FUNNELS_ALERT                                        _HRESULT_TYPEDEF_(0xc00d0060)
#define NS_E_ALLOCATE_FILE_FAIL                                       _HRESULT_TYPEDEF_(0xc00d0061)
#define NS_E_PAGING_ERROR                                             _HRESULT_TYPEDEF_(0xc00d0062)
#define NS_E_BAD_BLOCK0_VERSION                                       _HRESULT_TYPEDEF_(0xc00d0063)
#define NS_E_BAD_DISK_UID                                             _HRESULT_TYPEDEF_(0xc00d0064)
#define NS_E_BAD_FSMAJOR_VERSION                                      _HRESULT_TYPEDEF_(0xc00d0065)
#define NS_E_BAD_STAMPNUMBER                                          _HRESULT_TYPEDEF_(0xc00d0066)
#define NS_E_PARTIALLY_REBUILT_DISK                                   _HRESULT_TYPEDEF_(0xc00d0067)
#define NS_E_ENACTPLAN_GIVEUP                                         _HRESULT_TYPEDEF_(0xc00d0068)
#define MCMADM_I_NO_EVENTS                                            _HRESULT_TYPEDEF_(0x400d0069)
#define MCMADM_E_REGKEY_NOT_FOUND                                     _HRESULT_TYPEDEF_(0xc00d006a)
#define NS_E_NO_FORMATS                                               _HRESULT_TYPEDEF_(0xc00d006b)
#define NS_E_NO_REFERENCES                                            _HRESULT_TYPEDEF_(0xc00d006c)
#define NS_E_WAVE_OPEN                                                _HRESULT_TYPEDEF_(0xc00d006d)
#define NS_I_LOGGING_FAILED                                           _HRESULT_TYPEDEF_(0x400d006e)
#define NS_E_CANNOTCONNECTEVENTS                                      _HRESULT_TYPEDEF_(0xc00d006f)
#define NS_I_LIMIT_BANDWIDTH                                          _HRESULT_TYPEDEF_(0x400d0070)
#define NS_E_NO_DEVICE                                                _HRESULT_TYPEDEF_(0xc00d0071)
#define NS_E_NO_SPECIFIED_DEVICE                                      _HRESULT_TYPEDEF_(0xc00d0072)
#define NS_E_NOTHING_TO_DO                                            _HRESULT_TYPEDEF_(0xc00d07f1)
#define NS_E_NO_MULTICAST                                             _HRESULT_TYPEDEF_(0xc00d07f2)

/* Error events */
#define NS_E_MONITOR_GIVEUP                                           _HRESULT_TYPEDEF_(0xc00d00c8)
#define NS_E_REMIRRORED_DISK                                          _HRESULT_TYPEDEF_(0xc00d00c9)
#define NS_E_INSUFFICIENT_DATA                                        _HRESULT_TYPEDEF_(0xc00d00ca)
#define NS_E_ASSERT                                                   _HRESULT_TYPEDEF_(0xc00d00cb)
#define NS_E_BAD_ADAPTER_NAME                                         _HRESULT_TYPEDEF_(0xc00d00cc)
#define NS_E_NOT_LICENSED                                             _HRESULT_TYPEDEF_(0xc00d00cd)
#define NS_E_NO_SERVER_CONTACT                                        _HRESULT_TYPEDEF_(0xc00d00ce)
#define NS_E_TOO_MANY_TITLES                                          _HRESULT_TYPEDEF_(0xc00d00cf)
#define NS_E_TITLE_SIZE_EXCEEDED                                      _HRESULT_TYPEDEF_(0xc00d00d0)
#define NS_E_UDP_DISABLED                                             _HRESULT_TYPEDEF_(0xc00d00d1)
#define NS_E_TCP_DISABLED                                             _HRESULT_TYPEDEF_(0xc00d00d2)
#define NS_E_HTTP_DISABLED                                            _HRESULT_TYPEDEF_(0xc00d00d3)
#define NS_E_LICENSE_EXPIRED                                          _HRESULT_TYPEDEF_(0xc00d00d4)
#define NS_E_TITLE_BITRATE                                            _HRESULT_TYPEDEF_(0xc00d00d5)
#define NS_E_EMPTY_PROGRAM_NAME                                       _HRESULT_TYPEDEF_(0xc00d00d6)
#define NS_E_MISSING_CHANNEL                                          _HRESULT_TYPEDEF_(0xc00d00d7)
#define NS_E_NO_CHANNELS                                              _HRESULT_TYPEDEF_(0xc00d00d8)
#define NS_E_INVALID_INDEX2                                           _HRESULT_TYPEDEF_(0xc00d00d9)

/* (More) error events */
#define NS_E_CUB_FAIL_LINK                                            _HRESULT_TYPEDEF_(0xc00d0190)
#define NS_I_CUB_UNFAIL_LINK                                          _HRESULT_TYPEDEF_(0x400d0191)
#define NS_E_BAD_CUB_UID                                              _HRESULT_TYPEDEF_(0xc00d0192)
#define NS_I_RESTRIPE_START                                           _HRESULT_TYPEDEF_(0x400d0193)
#define NS_I_RESTRIPE_DONE                                            _HRESULT_TYPEDEF_(0x400d0194)
#define NS_E_GLITCH_MODE                                              _HRESULT_TYPEDEF_(0xc00d0195)
#define NS_I_RESTRIPE_DISK_OUT                                        _HRESULT_TYPEDEF_(0x400d0196)
#define NS_I_RESTRIPE_CUB_OUT                                         _HRESULT_TYPEDEF_(0x400d0197)
#define NS_I_DISK_STOP                                                _HRESULT_TYPEDEF_(0x400d0198)
#define NS_I_CATATONIC_FAILURE                                        _HRESULT_TYPEDEF_(0x800d0199)
#define NS_I_CATATONIC_AUTO_UNFAIL                                    _HRESULT_TYPEDEF_(0x800d019a)
#define NS_E_NO_MEDIA_PROTOCOL                                        _HRESULT_TYPEDEF_(0xc00d019b)

/* WMSDK errors */
#define NS_E_INVALID_INPUT_FORMAT                                     _HRESULT_TYPEDEF_(0xc00d0bb8)
#define NS_E_MSAUDIO_NOT_INSTALLED                                    _HRESULT_TYPEDEF_(0xc00d0bb9)
#define NS_E_UNEXPECTED_MSAUDIO_ERROR                                 _HRESULT_TYPEDEF_(0xc00d0bba)
#define NS_E_INVALID_OUTPUT_FORMAT                                    _HRESULT_TYPEDEF_(0xc00d0bbb)
#define NS_E_NOT_CONFIGURED                                           _HRESULT_TYPEDEF_(0xc00d0bbc)
#define NS_E_PROTECTED_CONTENT                                        _HRESULT_TYPEDEF_(0xc00d0bbd)
#define NS_E_LICENSE_REQUIRED                                         _HRESULT_TYPEDEF_(0xc00d0bbe)
#define NS_E_TAMPERED_CONTENT                                         _HRESULT_TYPEDEF_(0xc00d0bbf)
#define NS_E_LICENSE_OUTOFDATE                                        _HRESULT_TYPEDEF_(0xc00d0bc0)
#define NS_E_LICENSE_INCORRECT_RIGHTS                                 _HRESULT_TYPEDEF_(0xc00d0bc1)
#define NS_E_AUDIO_CODEC_NOT_INSTALLED                                _HRESULT_TYPEDEF_(0xc00d0bc2)
#define NS_E_AUDIO_CODEC_ERROR                                        _HRESULT_TYPEDEF_(0xc00d0bc3)
#define NS_E_VIDEO_CODEC_NOT_INSTALLED                                _HRESULT_TYPEDEF_(0xc00d0bc4)
#define NS_E_VIDEO_CODEC_ERROR                                        _HRESULT_TYPEDEF_(0xc00d0bc5)
#define NS_E_INVALIDPROFILE                                           _HRESULT_TYPEDEF_(0xc00d0bc6)
#define NS_E_INCOMPATIBLE_VERSION                                     _HRESULT_TYPEDEF_(0xc00d0bc7)
#define NS_S_REBUFFERING                                              _HRESULT_TYPEDEF_(0x000d0bc8)
#define NS_S_DEGRADING_QUALITY                                        _HRESULT_TYPEDEF_(0x000d0bc9)
#define NS_E_OFFLINE_MODE                                             _HRESULT_TYPEDEF_(0xc00d0bca)
#define NS_E_NOT_CONNECTED                                            _HRESULT_TYPEDEF_(0xc00d0bcb)
#define NS_E_TOO_MUCH_DATA                                            _HRESULT_TYPEDEF_(0xc00d0bcc)
#define NS_E_UNSUPPORTED_PROPERTY                                     _HRESULT_TYPEDEF_(0xc00d0bcd)
#define NS_E_8BIT_WAVE_UNSUPPORTED                                    _HRESULT_TYPEDEF_(0xc00d0bce)
#define NS_E_NO_MORE_SAMPLES                                          _HRESULT_TYPEDEF_(0xc00d0bcf)
#define NS_E_INVALID_SAMPLING_RATE                                    _HRESULT_TYPEDEF_(0xc00d0bd0)
#define NS_E_MAX_PACKET_SIZE_TOO_SMALL                                _HRESULT_TYPEDEF_(0xc00d0bd1)
#define NS_E_LATE_PACKET                                              _HRESULT_TYPEDEF_(0xc00d0bd2)
#define NS_E_DUPLICATE_PACKET                                         _HRESULT_TYPEDEF_(0xc00d0bd3)
#define NS_E_SDK_BUFFERTOOSMALL                                       _HRESULT_TYPEDEF_(0xc00d0bd4)
#define NS_E_INVALID_NUM_PASSES                                       _HRESULT_TYPEDEF_(0xc00d0bd5)
#define NS_E_ATTRIBUTE_READ_ONLY                                      _HRESULT_TYPEDEF_(0xc00d0bd6)
#define NS_E_ATTRIBUTE_NOT_ALLOWED                                    _HRESULT_TYPEDEF_(0xc00d0bd7)
#define NS_E_INVALID_EDL                                              _HRESULT_TYPEDEF_(0xc00d0bd8)
#define NS_E_DATA_UNIT_EXTENSION_TOO_LARGE                            _HRESULT_TYPEDEF_(0xc00d0bd9)
#define NS_E_CODEC_DMO_ERROR                                          _HRESULT_TYPEDEF_(0xc00d0bda)
#define NS_S_TRANSCRYPTOR_EOF                                         _HRESULT_TYPEDEF_(0x000d0bdb)
#define NS_E_FEATURE_DISABLED_BY_GROUP_POLICY                         _HRESULT_TYPEDEF_(0xc00d0bdc)
#define NS_E_FEATURE_DISABLED_IN_SKU                                  _HRESULT_TYPEDEF_(0xc00d0bdd)

/* WMP errors */
#define NS_E_NO_CD                                                    _HRESULT_TYPEDEF_(0xc00d0fa0)
#define NS_E_CANT_READ_DIGITAL                                        _HRESULT_TYPEDEF_(0xc00d0fa1)
#define NS_E_DEVICE_DISCONNECTED                                      _HRESULT_TYPEDEF_(0xc00d0fa2)
#define NS_E_DEVICE_NOT_SUPPORT_FORMAT                                _HRESULT_TYPEDEF_(0xc00d0fa3)
#define NS_E_SLOW_READ_DIGITAL                                        _HRESULT_TYPEDEF_(0xc00d0fa4)
#define NS_E_MIXER_INVALID_LINE                                       _HRESULT_TYPEDEF_(0xc00d0fa5)
#define NS_E_MIXER_INVALID_CONTROL                                    _HRESULT_TYPEDEF_(0xc00d0fa6)
#define NS_E_MIXER_INVALID_VALUE                                      _HRESULT_TYPEDEF_(0xc00d0fa7)
#define NS_E_MIXER_UNKNOWN_MMRESULT                                   _HRESULT_TYPEDEF_(0xc00d0fa8)
#define NS_E_USER_STOP                                                _HRESULT_TYPEDEF_(0xc00d0fa9)
#define NS_E_MP3_FORMAT_NOT_FOUND                                     _HRESULT_TYPEDEF_(0xc00d0faa)
#define NS_E_CD_READ_ERROR_NO_CORRECTION                              _HRESULT_TYPEDEF_(0xc00d0fab)
#define NS_E_CD_READ_ERROR                                            _HRESULT_TYPEDEF_(0xc00d0fac)
#define NS_E_CD_SLOW_COPY                                             _HRESULT_TYPEDEF_(0xc00d0fad)
#define NS_E_CD_COPYTO_CD                                             _HRESULT_TYPEDEF_(0xc00d0fae)
#define NS_E_MIXER_NODRIVER                                           _HRESULT_TYPEDEF_(0xc00d0faf)
#define NS_E_REDBOOK_ENABLED_WHILE_COPYING                            _HRESULT_TYPEDEF_(0xc00d0fb0)
#define NS_E_CD_REFRESH                                               _HRESULT_TYPEDEF_(0xc00d0fb1)
#define NS_E_CD_DRIVER_PROBLEM                                        _HRESULT_TYPEDEF_(0xc00d0fb2)
#define NS_E_WONT_DO_DIGITAL                                          _HRESULT_TYPEDEF_(0xc00d0fb3)
#define NS_E_WMPXML_NOERROR                                           _HRESULT_TYPEDEF_(0xc00d0fb4)
#define NS_E_WMPXML_ENDOFDATA                                         _HRESULT_TYPEDEF_(0xc00d0fb5)
#define NS_E_WMPXML_PARSEERROR                                        _HRESULT_TYPEDEF_(0xc00d0fb6)
#define NS_E_WMPXML_ATTRIBUTENOTFOUND                                 _HRESULT_TYPEDEF_(0xc00d0fb7)
#define NS_E_WMPXML_PINOTFOUND                                        _HRESULT_TYPEDEF_(0xc00d0fb8)
#define NS_E_WMPXML_EMPTYDOC                                          _HRESULT_TYPEDEF_(0xc00d0fb9)
#define NS_E_WMP_PATH_ALREADY_IN_LIBRARY                              _HRESULT_TYPEDEF_(0xc00d0fba)
#define NS_E_WMP_FILESCANALREADYSTARTED                               _HRESULT_TYPEDEF_(0xc00d0fbe)
#define NS_E_WMP_HME_INVALIDOBJECTID                                  _HRESULT_TYPEDEF_(0xc00d0fbf)
#define NS_E_WMP_MF_CODE_EXPIRED                                      _HRESULT_TYPEDEF_(0xc00d0fc0)
#define NS_E_WMP_HME_NOTSEARCHABLEFORITEMS                            _HRESULT_TYPEDEF_(0xc00d0fc1)
#define NS_E_WMP_HME_STALEREQUEST                                     _HRESULT_TYPEDEF_(0xc00d0fc2)
#define NS_E_WMP_ADDTOLIBRARY_FAILED                                  _HRESULT_TYPEDEF_(0xc00d0fc7)
#define NS_E_WMP_WINDOWSAPIFAILURE                                    _HRESULT_TYPEDEF_(0xc00d0fc8)
#define NS_E_WMP_RECORDING_NOT_ALLOWED                                _HRESULT_TYPEDEF_(0xc00d0fc9)
#define NS_E_DEVICE_NOT_READY                                         _HRESULT_TYPEDEF_(0xc00d0fca)
#define NS_E_DAMAGED_FILE                                             _HRESULT_TYPEDEF_(0xc00d0fcb)
#define NS_E_MPDB_GENERIC                                             _HRESULT_TYPEDEF_(0xc00d0fcc)
#define NS_E_FILE_FAILED_CHECKS                                       _HRESULT_TYPEDEF_(0xc00d0fcd)
#define NS_E_MEDIA_LIBRARY_FAILED                                     _HRESULT_TYPEDEF_(0xc00d0fce)
#define NS_E_SHARING_VIOLATION                                        _HRESULT_TYPEDEF_(0xc00d0fcf)
#define NS_E_NO_ERROR_STRING_FOUND                                    _HRESULT_TYPEDEF_(0xc00d0fd0)
#define NS_E_WMPOCX_NO_REMOTE_CORE                                    _HRESULT_TYPEDEF_(0xc00d0fd1)
#define NS_E_WMPOCX_NO_ACTIVE_CORE                                    _HRESULT_TYPEDEF_(0xc00d0fd2)
#define NS_E_WMPOCX_NOT_RUNNING_REMOTELY                              _HRESULT_TYPEDEF_(0xc00d0fd3)
#define NS_E_WMPOCX_NO_REMOTE_WINDOW                                  _HRESULT_TYPEDEF_(0xc00d0fd4)
#define NS_E_WMPOCX_ERRORMANAGERNOTAVAILABLE                          _HRESULT_TYPEDEF_(0xc00d0fd5)
#define NS_E_PLUGIN_NOTSHUTDOWN                                       _HRESULT_TYPEDEF_(0xc00d0fd6)
#define NS_E_WMP_CANNOT_FIND_FOLDER                                   _HRESULT_TYPEDEF_(0xc00d0fd7)
#define NS_E_WMP_STREAMING_RECORDING_NOT_ALLOWED                      _HRESULT_TYPEDEF_(0xc00d0fd8)
#define NS_E_WMP_PLUGINDLL_NOTFOUND                                   _HRESULT_TYPEDEF_(0xc00d0fd9)
#define NS_E_NEED_TO_ASK_USER                                         _HRESULT_TYPEDEF_(0xc00d0fda)
#define NS_E_WMPOCX_PLAYER_NOT_DOCKED                                 _HRESULT_TYPEDEF_(0xc00d0fdb)
#define NS_E_WMP_EXTERNAL_NOTREADY                                    _HRESULT_TYPEDEF_(0xc00d0fdc)
#define NS_E_WMP_MLS_STALE_DATA                                       _HRESULT_TYPEDEF_(0xc00d0fdd)
#define NS_E_WMP_UI_SUBCONTROLSNOTSUPPORTED                           _HRESULT_TYPEDEF_(0xc00d0fde)
#define NS_E_WMP_UI_VERSIONMISMATCH                                   _HRESULT_TYPEDEF_(0xc00d0fdf)
#define NS_E_WMP_UI_NOTATHEMEFILE                                     _HRESULT_TYPEDEF_(0xc00d0fe0)
#define NS_E_WMP_UI_SUBELEMENTNOTFOUND                                _HRESULT_TYPEDEF_(0xc00d0fe1)
#define NS_E_WMP_UI_VERSIONPARSE                                      _HRESULT_TYPEDEF_(0xc00d0fe2)
#define NS_E_WMP_UI_VIEWIDNOTFOUND                                    _HRESULT_TYPEDEF_(0xc00d0fe3)
#define NS_E_WMP_UI_PASSTHROUGH                                       _HRESULT_TYPEDEF_(0xc00d0fe4)
#define NS_E_WMP_UI_OBJECTNOTFOUND                                    _HRESULT_TYPEDEF_(0xc00d0fe5)
#define NS_E_WMP_UI_SECONDHANDLER                                     _HRESULT_TYPEDEF_(0xc00d0fe6)
#define NS_E_WMP_UI_NOSKININZIP                                       _HRESULT_TYPEDEF_(0xc00d0fe7)
#define NS_S_WMP_UI_VERSIONMISMATCH                                   _HRESULT_TYPEDEF_(0x000d0fe8)
#define NS_S_WMP_EXCEPTION                                            _HRESULT_TYPEDEF_(0x000d0fe9)
#define NS_E_WMP_URLDOWNLOADFAILED                                    _HRESULT_TYPEDEF_(0xc00d0fea)
#define NS_E_WMPOCX_UNABLE_TO_LOAD_SKIN                               _HRESULT_TYPEDEF_(0xc00d0feb)
#define NS_E_WMP_INVALID_SKIN                                         _HRESULT_TYPEDEF_(0xc00d0fec)
#define NS_E_WMP_SENDMAILFAILED                                       _HRESULT_TYPEDEF_(0xc00d0fed)
#define NS_E_WMP_LOCKEDINSKINMODE                                     _HRESULT_TYPEDEF_(0xc00d0fee)
#define NS_E_WMP_FAILED_TO_SAVE_FILE                                  _HRESULT_TYPEDEF_(0xc00d0fef)
#define NS_E_WMP_SAVEAS_READONLY                                      _HRESULT_TYPEDEF_(0xc00d0ff0)
#define NS_E_WMP_FAILED_TO_SAVE_PLAYLIST                              _HRESULT_TYPEDEF_(0xc00d0ff1)
#define NS_E_WMP_FAILED_TO_OPEN_WMD                                   _HRESULT_TYPEDEF_(0xc00d0ff2)
#define NS_E_WMP_CANT_PLAY_PROTECTED                                  _HRESULT_TYPEDEF_(0xc00d0ff3)
#define NS_E_SHARING_STATE_OUT_OF_SYNC                                _HRESULT_TYPEDEF_(0xc00d0ff4)
#define NS_E_WMPOCX_REMOTE_PLAYER_ALREADY_RUNNING                     _HRESULT_TYPEDEF_(0xc00d0ffa)
#define NS_E_WMP_RBC_JPGMAPPINGIMAGE                                  _HRESULT_TYPEDEF_(0xc00d1004)
#define NS_E_WMP_JPGTRANSPARENCY                                      _HRESULT_TYPEDEF_(0xc00d1005)
#define NS_E_WMP_INVALID_MAX_VAL                                      _HRESULT_TYPEDEF_(0xc00d1009)
#define NS_E_WMP_INVALID_MIN_VAL                                      _HRESULT_TYPEDEF_(0xc00d100a)
#define NS_E_WMP_CS_JPGPOSITIONIMAGE                                  _HRESULT_TYPEDEF_(0xc00d100e)
#define NS_E_WMP_CS_NOTEVENLYDIVISIBLE                                _HRESULT_TYPEDEF_(0xc00d100f)
#define NS_E_WMPZIP_NOTAZIPFILE                                       _HRESULT_TYPEDEF_(0xc00d1018)
#define NS_E_WMPZIP_CORRUPT                                           _HRESULT_TYPEDEF_(0xc00d1019)
#define NS_E_WMPZIP_FILENOTFOUND                                      _HRESULT_TYPEDEF_(0xc00d101a)
#define NS_E_WMP_IMAGE_FILETYPE_UNSUPPORTED                           _HRESULT_TYPEDEF_(0xc00d1022)
#define NS_E_WMP_IMAGE_INVALID_FORMAT                                 _HRESULT_TYPEDEF_(0xc00d1023)
#define NS_E_WMP_GIF_UNEXPECTED_ENDOFFILE                             _HRESULT_TYPEDEF_(0xc00d1024)
#define NS_E_WMP_GIF_INVALID_FORMAT                                   _HRESULT_TYPEDEF_(0xc00d1025)
#define NS_E_WMP_GIF_BAD_VERSION_NUMBER                               _HRESULT_TYPEDEF_(0xc00d1026)
#define NS_E_WMP_GIF_NO_IMAGE_IN_FILE                                 _HRESULT_TYPEDEF_(0xc00d1027)
#define NS_E_WMP_PNG_INVALIDFORMAT                                    _HRESULT_TYPEDEF_(0xc00d1028)
#define NS_E_WMP_PNG_UNSUPPORTED_BITDEPTH                             _HRESULT_TYPEDEF_(0xc00d1029)
#define NS_E_WMP_PNG_UNSUPPORTED_COMPRESSION                          _HRESULT_TYPEDEF_(0xc00d102a)
#define NS_E_WMP_PNG_UNSUPPORTED_FILTER                               _HRESULT_TYPEDEF_(0xc00d102b)
#define NS_E_WMP_PNG_UNSUPPORTED_INTERLACE                            _HRESULT_TYPEDEF_(0xc00d102c)
#define NS_E_WMP_PNG_UNSUPPORTED_BAD_CRC                              _HRESULT_TYPEDEF_(0xc00d102d)
#define NS_E_WMP_BMP_INVALID_BITMASK                                  _HRESULT_TYPEDEF_(0xc00d102e)
#define NS_E_WMP_BMP_TOPDOWN_DIB_UNSUPPORTED                          _HRESULT_TYPEDEF_(0xc00d102f)
#define NS_E_WMP_BMP_BITMAP_NOT_CREATED                               _HRESULT_TYPEDEF_(0xc00d1030)
#define NS_E_WMP_BMP_COMPRESSION_UNSUPPORTED                          _HRESULT_TYPEDEF_(0xc00d1031)
#define NS_E_WMP_BMP_INVALID_FORMAT                                   _HRESULT_TYPEDEF_(0xc00d1032)
#define NS_E_WMP_JPG_JERR_ARITHCODING_NOTIMPL                         _HRESULT_TYPEDEF_(0xc00d1033)
#define NS_E_WMP_JPG_INVALID_FORMAT                                   _HRESULT_TYPEDEF_(0xc00d1034)
#define NS_E_WMP_JPG_BAD_DCTSIZE                                      _HRESULT_TYPEDEF_(0xc00d1035)
#define NS_E_WMP_JPG_BAD_VERSION_NUMBER                               _HRESULT_TYPEDEF_(0xc00d1036)
#define NS_E_WMP_JPG_BAD_PRECISION                                    _HRESULT_TYPEDEF_(0xc00d1037)
#define NS_E_WMP_JPG_CCIR601_NOTIMPL                                  _HRESULT_TYPEDEF_(0xc00d1038)
#define NS_E_WMP_JPG_NO_IMAGE_IN_FILE                                 _HRESULT_TYPEDEF_(0xc00d1039)
#define NS_E_WMP_JPG_READ_ERROR                                       _HRESULT_TYPEDEF_(0xc00d103a)
#define NS_E_WMP_JPG_FRACT_SAMPLE_NOTIMPL                             _HRESULT_TYPEDEF_(0xc00d103b)
#define NS_E_WMP_JPG_IMAGE_TOO_BIG                                    _HRESULT_TYPEDEF_(0xc00d103c)
#define NS_E_WMP_JPG_UNEXPECTED_ENDOFFILE                             _HRESULT_TYPEDEF_(0xc00d103d)
#define NS_E_WMP_JPG_SOF_UNSUPPORTED                                  _HRESULT_TYPEDEF_(0xc00d103e)
#define NS_E_WMP_JPG_UNKNOWN_MARKER                                   _HRESULT_TYPEDEF_(0xc00d103f)
#define NS_S_WMP_LOADED_GIF_IMAGE                                     _HRESULT_TYPEDEF_(0x000d1040)
#define NS_S_WMP_LOADED_PNG_IMAGE                                     _HRESULT_TYPEDEF_(0x000d1041)
#define NS_S_WMP_LOADED_BMP_IMAGE                                     _HRESULT_TYPEDEF_(0x000d1042)
#define NS_S_WMP_LOADED_JPG_IMAGE                                     _HRESULT_TYPEDEF_(0x000d1043)
#define NS_E_WMP_FAILED_TO_OPEN_IMAGE                                 _HRESULT_TYPEDEF_(0xc00d1044)
#define NS_E_WMP_DAI_SONGTOOSHORT                                     _HRESULT_TYPEDEF_(0xc00d1049)
#define NS_E_WMG_RATEUNAVAILABLE                                      _HRESULT_TYPEDEF_(0xc00d104a)
#define NS_E_WMG_PLUGINUNAVAILABLE                                    _HRESULT_TYPEDEF_(0xc00d104b)
#define NS_E_WMG_CANNOTQUEUE                                          _HRESULT_TYPEDEF_(0xc00d104c)
#define NS_E_WMG_PREROLLLICENSEACQUISITIONNOTALLOWED                  _HRESULT_TYPEDEF_(0xc00d104d)
#define NS_E_WMG_UNEXPECTEDPREROLLSTATUS                              _HRESULT_TYPEDEF_(0xc00d104e)
#define NS_S_WMG_FORCE_DROP_FRAME                                     _HRESULT_TYPEDEF_(0x000d104f)
#define NS_E_WMG_INVALID_COPP_CERTIFICATE                             _HRESULT_TYPEDEF_(0xc00d1051)
#define NS_E_WMG_COPP_SECURITY_INVALID                                _HRESULT_TYPEDEF_(0xc00d1052)
#define NS_E_WMG_COPP_UNSUPPORTED                                     _HRESULT_TYPEDEF_(0xc00d1053)
#define NS_E_WMG_INVALIDSTATE                                         _HRESULT_TYPEDEF_(0xc00d1054)
#define NS_E_WMG_SINKALREADYEXISTS                                    _HRESULT_TYPEDEF_(0xc00d1055)
#define NS_E_WMG_NOSDKINTERFACE                                       _HRESULT_TYPEDEF_(0xc00d1056)
#define NS_E_WMG_NOTALLOUTPUTSRENDERED                                _HRESULT_TYPEDEF_(0xc00d1057)
#define NS_E_WMG_FILETRANSFERNOTALLOWED                               _HRESULT_TYPEDEF_(0xc00d1058)
#define NS_E_WMR_UNSUPPORTEDSTREAM                                    _HRESULT_TYPEDEF_(0xc00d1059)
#define NS_E_WMR_PINNOTFOUND                                          _HRESULT_TYPEDEF_(0xc00d105a)
#define NS_E_WMR_WAITINGONFORMATSWITCH                                _HRESULT_TYPEDEF_(0xc00d105b)
#define NS_E_WMR_NOSOURCEFILTER                                       _HRESULT_TYPEDEF_(0xc00d105c)
#define NS_E_WMR_PINTYPENOMATCH                                       _HRESULT_TYPEDEF_(0xc00d105d)
#define NS_E_WMR_NOCALLBACKAVAILABLE                                  _HRESULT_TYPEDEF_(0xc00d105e)
#define NS_S_WMR_ALREADYRENDERED                                      _HRESULT_TYPEDEF_(0x000d105f)
#define NS_S_WMR_PINTYPEPARTIALMATCH                                  _HRESULT_TYPEDEF_(0x000d1060)
#define NS_S_WMR_PINTYPEFULLMATCH                                     _HRESULT_TYPEDEF_(0x000d1061)
#define NS_E_WMR_SAMPLEPROPERTYNOTSET                                 _HRESULT_TYPEDEF_(0xc00d1062)
#define NS_E_WMR_CANNOT_RENDER_BINARY_STREAM                          _HRESULT_TYPEDEF_(0xc00d1063)
#define NS_E_WMG_LICENSE_TAMPERED                                     _HRESULT_TYPEDEF_(0xc00d1064)
#define NS_E_WMR_WILLNOT_RENDER_BINARY_STREAM                         _HRESULT_TYPEDEF_(0xc00d1065)
#define NS_S_WMG_ADVISE_DROP_FRAME                                    _HRESULT_TYPEDEF_(0x000d1066)
#define NS_S_WMG_ADVISE_DROP_TO_KEYFRAME                              _HRESULT_TYPEDEF_(0x000d1067)
#define NS_E_WMX_UNRECOGNIZED_PLAYLIST_FORMAT                         _HRESULT_TYPEDEF_(0xc00d1068)
#define NS_E_ASX_INVALIDFORMAT                                        _HRESULT_TYPEDEF_(0xc00d1069)
#define NS_E_ASX_INVALIDVERSION                                       _HRESULT_TYPEDEF_(0xc00d106a)
#define NS_E_ASX_INVALID_REPEAT_BLOCK                                 _HRESULT_TYPEDEF_(0xc00d106b)
#define NS_E_ASX_NOTHING_TO_WRITE                                     _HRESULT_TYPEDEF_(0xc00d106c)
#define NS_E_URLLIST_INVALIDFORMAT                                    _HRESULT_TYPEDEF_(0xc00d106d)
#define NS_E_WMX_ATTRIBUTE_DOES_NOT_EXIST                             _HRESULT_TYPEDEF_(0xc00d106e)
#define NS_E_WMX_ATTRIBUTE_ALREADY_EXISTS                             _HRESULT_TYPEDEF_(0xc00d106f)
#define NS_E_WMX_ATTRIBUTE_UNRETRIEVABLE                              _HRESULT_TYPEDEF_(0xc00d1070)
#define NS_E_WMX_ITEM_DOES_NOT_EXIST                                  _HRESULT_TYPEDEF_(0xc00d1071)
#define NS_E_WMX_ITEM_TYPE_ILLEGAL                                    _HRESULT_TYPEDEF_(0xc00d1072)
#define NS_E_WMX_ITEM_UNSETTABLE                                      _HRESULT_TYPEDEF_(0xc00d1073)
#define NS_E_WMX_PLAYLIST_EMPTY                                       _HRESULT_TYPEDEF_(0xc00d1074)
#define NS_E_MLS_SMARTPLAYLIST_FILTER_NOT_REGISTERED                  _HRESULT_TYPEDEF_(0xc00d1075)
#define NS_E_WMX_INVALID_FORMAT_OVER_NESTING                          _HRESULT_TYPEDEF_(0xc00d1076)
#define NS_E_WMPCORE_NOSOURCEURLSTRING                                _HRESULT_TYPEDEF_(0xc00d107c)
#define NS_E_WMPCORE_COCREATEFAILEDFORGITOBJECT                       _HRESULT_TYPEDEF_(0xc00d107d)
#define NS_E_WMPCORE_FAILEDTOGETMARSHALLEDEVENTHANDLERINTERFACE       _HRESULT_TYPEDEF_(0xc00d107e)
#define NS_E_WMPCORE_BUFFERTOOSMALL                                   _HRESULT_TYPEDEF_(0xc00d107f)
#define NS_E_WMPCORE_UNAVAILABLE                                      _HRESULT_TYPEDEF_(0xc00d1080)
#define NS_E_WMPCORE_INVALIDPLAYLISTMODE                              _HRESULT_TYPEDEF_(0xc00d1081)
#define NS_E_WMPCORE_ITEMNOTINPLAYLIST                                _HRESULT_TYPEDEF_(0xc00d1086)
#define NS_E_WMPCORE_PLAYLISTEMPTY                                    _HRESULT_TYPEDEF_(0xc00d1087)
#define NS_E_WMPCORE_NOBROWSER                                        _HRESULT_TYPEDEF_(0xc00d1088)
#define NS_E_WMPCORE_UNRECOGNIZED_MEDIA_URL                           _HRESULT_TYPEDEF_(0xc00d1089)
#define NS_E_WMPCORE_GRAPH_NOT_IN_LIST                                _HRESULT_TYPEDEF_(0xc00d108a)
#define NS_E_WMPCORE_PLAYLIST_EMPTY_OR_SINGLE_MEDIA                   _HRESULT_TYPEDEF_(0xc00d108b)
#define NS_E_WMPCORE_ERRORSINKNOTREGISTERED                           _HRESULT_TYPEDEF_(0xc00d108c)
#define NS_E_WMPCORE_ERRORMANAGERNOTAVAILABLE                         _HRESULT_TYPEDEF_(0xc00d108d)
#define NS_E_WMPCORE_WEBHELPFAILED                                    _HRESULT_TYPEDEF_(0xc00d108e)
#define NS_E_WMPCORE_MEDIA_ERROR_RESUME_FAILED                        _HRESULT_TYPEDEF_(0xc00d108f)
#define NS_E_WMPCORE_NO_REF_IN_ENTRY                                  _HRESULT_TYPEDEF_(0xc00d1090)
#define NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_NAME_EMPTY                    _HRESULT_TYPEDEF_(0xc00d1091)
#define NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_NAME_ILLEGAL                  _HRESULT_TYPEDEF_(0xc00d1092)
#define NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_VALUE_EMPTY                   _HRESULT_TYPEDEF_(0xc00d1093)
#define NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_VALUE_ILLEGAL                 _HRESULT_TYPEDEF_(0xc00d1094)
#define NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_NAME_EMPTY               _HRESULT_TYPEDEF_(0xc00d1095)
#define NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_NAME_ILLEGAL             _HRESULT_TYPEDEF_(0xc00d1096)
#define NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_VALUE_EMPTY              _HRESULT_TYPEDEF_(0xc00d1097)
#define NS_E_WMPCORE_LIST_ENTRY_NO_REF                                _HRESULT_TYPEDEF_(0xc00d1098)
#define NS_E_WMPCORE_MISNAMED_FILE                                    _HRESULT_TYPEDEF_(0xc00d1099)
#define NS_E_WMPCORE_CODEC_NOT_TRUSTED                                _HRESULT_TYPEDEF_(0xc00d109a)
#define NS_E_WMPCORE_CODEC_NOT_FOUND                                  _HRESULT_TYPEDEF_(0xc00d109b)
#define NS_E_WMPCORE_CODEC_DOWNLOAD_NOT_ALLOWED                       _HRESULT_TYPEDEF_(0xc00d109c)
#define NS_E_WMPCORE_ERROR_DOWNLOADING_PLAYLIST                       _HRESULT_TYPEDEF_(0xc00d109d)
#define NS_E_WMPCORE_FAILED_TO_BUILD_PLAYLIST                         _HRESULT_TYPEDEF_(0xc00d109e)
#define NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_NONE                     _HRESULT_TYPEDEF_(0xc00d109f)
#define NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_EXHAUSTED                _HRESULT_TYPEDEF_(0xc00d10a0)
#define NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_NAME_NOT_FOUND           _HRESULT_TYPEDEF_(0xc00d10a1)
#define NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_MORPH_FAILED             _HRESULT_TYPEDEF_(0xc00d10a2)
#define NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_INIT_FAILED              _HRESULT_TYPEDEF_(0xc00d10a3)
#define NS_E_WMPCORE_MEDIA_ALTERNATE_REF_EMPTY                        _HRESULT_TYPEDEF_(0xc00d10a4)
#define NS_E_WMPCORE_PLAYLIST_NO_EVENT_NAME                           _HRESULT_TYPEDEF_(0xc00d10a5)
#define NS_E_WMPCORE_PLAYLIST_EVENT_ATTRIBUTE_ABSENT                  _HRESULT_TYPEDEF_(0xc00d10a6)
#define NS_E_WMPCORE_PLAYLIST_EVENT_EMPTY                             _HRESULT_TYPEDEF_(0xc00d10a7)
#define NS_E_WMPCORE_PLAYLIST_STACK_EMPTY                             _HRESULT_TYPEDEF_(0xc00d10a8)
#define NS_E_WMPCORE_CURRENT_MEDIA_NOT_ACTIVE                         _HRESULT_TYPEDEF_(0xc00d10a9)
#define NS_E_WMPCORE_USER_CANCEL                                      _HRESULT_TYPEDEF_(0xc00d10ab)
#define NS_E_WMPCORE_PLAYLIST_REPEAT_EMPTY                            _HRESULT_TYPEDEF_(0xc00d10ac)
#define NS_E_WMPCORE_PLAYLIST_REPEAT_START_MEDIA_NONE                 _HRESULT_TYPEDEF_(0xc00d10ad)
#define NS_E_WMPCORE_PLAYLIST_REPEAT_END_MEDIA_NONE                   _HRESULT_TYPEDEF_(0xc00d10ae)
#define NS_E_WMPCORE_INVALID_PLAYLIST_URL                             _HRESULT_TYPEDEF_(0xc00d10af)
#define NS_E_WMPCORE_MISMATCHED_RUNTIME                               _HRESULT_TYPEDEF_(0xc00d10b0)
#define NS_E_WMPCORE_PLAYLIST_IMPORT_FAILED_NO_ITEMS                  _HRESULT_TYPEDEF_(0xc00d10b1)
#define NS_E_WMPCORE_VIDEO_TRANSFORM_FILTER_INSERTION                 _HRESULT_TYPEDEF_(0xc00d10b2)
#define NS_E_WMPCORE_MEDIA_UNAVAILABLE                                _HRESULT_TYPEDEF_(0xc00d10b3)
#define NS_E_WMPCORE_WMX_ENTRYREF_NO_REF                              _HRESULT_TYPEDEF_(0xc00d10b4)
#define NS_E_WMPCORE_NO_PLAYABLE_MEDIA_IN_PLAYLIST                    _HRESULT_TYPEDEF_(0xc00d10b5)
#define NS_E_WMPCORE_PLAYLIST_EMPTY_NESTED_PLAYLIST_SKIPPED_ITEMS     _HRESULT_TYPEDEF_(0xc00d10b6)
#define NS_E_WMPCORE_BUSY                                             _HRESULT_TYPEDEF_(0xc00d10b7)
#define NS_E_WMPCORE_MEDIA_CHILD_PLAYLIST_UNAVAILABLE                 _HRESULT_TYPEDEF_(0xc00d10b8)
#define NS_E_WMPCORE_MEDIA_NO_CHILD_PLAYLIST                          _HRESULT_TYPEDEF_(0xc00d10b9)
#define NS_E_WMPCORE_FILE_NOT_FOUND                                   _HRESULT_TYPEDEF_(0xc00d10ba)
#define NS_E_WMPCORE_TEMP_FILE_NOT_FOUND                              _HRESULT_TYPEDEF_(0xc00d10bb)
#define NS_E_WMDM_REVOKED                                             _HRESULT_TYPEDEF_(0xc00d10bc)
#define NS_E_DDRAW_GENERIC                                            _HRESULT_TYPEDEF_(0xc00d10bd)
#define NS_E_DISPLAY_MODE_CHANGE_FAILED                               _HRESULT_TYPEDEF_(0xc00d10be)
#define NS_E_PLAYLIST_CONTAINS_ERRORS                                 _HRESULT_TYPEDEF_(0xc00d10bf)
#define NS_E_CHANGING_PROXY_NAME                                      _HRESULT_TYPEDEF_(0xc00d10c0)
#define NS_E_CHANGING_PROXY_PORT                                      _HRESULT_TYPEDEF_(0xc00d10c1)
#define NS_E_CHANGING_PROXY_EXCEPTIONLIST                             _HRESULT_TYPEDEF_(0xc00d10c2)
#define NS_E_CHANGING_PROXYBYPASS                                     _HRESULT_TYPEDEF_(0xc00d10c3)
#define NS_E_CHANGING_PROXY_PROTOCOL_NOT_FOUND                        _HRESULT_TYPEDEF_(0xc00d10c4)
#define NS_E_GRAPH_NOAUDIOLANGUAGE                                    _HRESULT_TYPEDEF_(0xc00d10c5)
#define NS_E_GRAPH_NOAUDIOLANGUAGESELECTED                            _HRESULT_TYPEDEF_(0xc00d10c6)
#define NS_E_CORECD_NOTAMEDIACD                                       _HRESULT_TYPEDEF_(0xc00d10c7)
#define NS_E_WMPCORE_MEDIA_URL_TOO_LONG                               _HRESULT_TYPEDEF_(0xc00d10c8)
#define NS_E_WMPFLASH_CANT_FIND_COM_SERVER                            _HRESULT_TYPEDEF_(0xc00d10c9)
#define NS_E_WMPFLASH_INCOMPATIBLEVERSION                             _HRESULT_TYPEDEF_(0xc00d10ca)
#define NS_E_WMPOCXGRAPH_IE_DISALLOWS_ACTIVEX_CONTROLS                _HRESULT_TYPEDEF_(0xc00d10cb)
#define NS_E_NEED_CORE_REFERENCE                                      _HRESULT_TYPEDEF_(0xc00d10cc)
#define NS_E_MEDIACD_READ_ERROR                                       _HRESULT_TYPEDEF_(0xc00d10cd)
#define NS_E_IE_DISALLOWS_ACTIVEX_CONTROLS                            _HRESULT_TYPEDEF_(0xc00d10ce)
#define NS_E_FLASH_PLAYBACK_NOT_ALLOWED                               _HRESULT_TYPEDEF_(0xc00d10cf)
#define NS_E_UNABLE_TO_CREATE_RIP_LOCATION                            _HRESULT_TYPEDEF_(0xc00d10d0)
#define NS_E_WMPCORE_SOME_CODECS_MISSING                              _HRESULT_TYPEDEF_(0xc00d10d1)
#define NS_E_WMP_RIP_FAILED                                           _HRESULT_TYPEDEF_(0xc00d10d2)
#define NS_E_WMP_FAILED_TO_RIP_TRACK                                  _HRESULT_TYPEDEF_(0xc00d10d3)
#define NS_E_WMP_ERASE_FAILED                                         _HRESULT_TYPEDEF_(0xc00d10d4)
#define NS_E_WMP_FORMAT_FAILED                                        _HRESULT_TYPEDEF_(0xc00d10d5)
#define NS_E_WMP_CANNOT_BURN_NON_LOCAL_FILE                           _HRESULT_TYPEDEF_(0xc00d10d6)
#define NS_E_WMP_FILE_TYPE_CANNOT_BURN_TO_AUDIO_CD                    _HRESULT_TYPEDEF_(0xc00d10d7)
#define NS_E_WMP_FILE_DOES_NOT_FIT_ON_CD                              _HRESULT_TYPEDEF_(0xc00d10d8)
#define NS_E_WMP_FILE_NO_DURATION                                     _HRESULT_TYPEDEF_(0xc00d10d9)
#define NS_E_PDA_FAILED_TO_BURN                                       _HRESULT_TYPEDEF_(0xc00d10da)
#define NS_S_NEED_TO_BUY_BURN_RIGHTS                                  _HRESULT_TYPEDEF_(0x000d10db)
#define NS_E_FAILED_DOWNLOAD_ABORT_BURN                               _HRESULT_TYPEDEF_(0xc00d10dc)
#define NS_E_WMPCORE_DEVICE_DRIVERS_MISSING                           _HRESULT_TYPEDEF_(0xc00d10dd)
#define NS_S_WMPCORE_PLAYLISTCLEARABORT                               _HRESULT_TYPEDEF_(0x000d10fe)
#define NS_S_WMPCORE_PLAYLISTREMOVEITEMABORT                          _HRESULT_TYPEDEF_(0x000d10ff)
#define NS_S_WMPCORE_PLAYLIST_CREATION_PENDING                        _HRESULT_TYPEDEF_(0x000d1102)
#define NS_S_WMPCORE_MEDIA_VALIDATION_PENDING                         _HRESULT_TYPEDEF_(0x000d1103)
#define NS_S_WMPCORE_PLAYLIST_REPEAT_SECONDARY_SEGMENTS_IGNORED       _HRESULT_TYPEDEF_(0x000d1104)
#define NS_S_WMPCORE_COMMAND_NOT_AVAILABLE                            _HRESULT_TYPEDEF_(0x000d1105)
#define NS_S_WMPCORE_PLAYLIST_NAME_AUTO_GENERATED                     _HRESULT_TYPEDEF_(0x000d1106)
#define NS_S_WMPCORE_PLAYLIST_IMPORT_MISSING_ITEMS                    _HRESULT_TYPEDEF_(0x000d1107)
#define NS_S_WMPCORE_PLAYLIST_COLLAPSED_TO_SINGLE_MEDIA               _HRESULT_TYPEDEF_(0x000d1108)
#define NS_S_WMPCORE_MEDIA_CHILD_PLAYLIST_OPEN_PENDING                _HRESULT_TYPEDEF_(0x000d1109)
#define NS_S_WMPCORE_MORE_NODES_AVAIABLE                              _HRESULT_TYPEDEF_(0x000d110a)
#define NS_E_WMPIM_USEROFFLINE                                        _HRESULT_TYPEDEF_(0xc00d1126)
#define NS_E_WMPIM_USERCANCELED                                       _HRESULT_TYPEDEF_(0xc00d1127)
#define NS_E_WMPIM_DIALUPFAILED                                       _HRESULT_TYPEDEF_(0xc00d1128)
#define NS_E_WINSOCK_ERROR_STRING                                     _HRESULT_TYPEDEF_(0xc00d1129)
#define NS_E_WMPBR_NOLISTENER                                         _HRESULT_TYPEDEF_(0xc00d1130)
#define NS_E_WMPBR_BACKUPCANCEL                                       _HRESULT_TYPEDEF_(0xc00d1131)
#define NS_E_WMPBR_RESTORECANCEL                                      _HRESULT_TYPEDEF_(0xc00d1132)
#define NS_E_WMPBR_ERRORWITHURL                                       _HRESULT_TYPEDEF_(0xc00d1133)
#define NS_E_WMPBR_NAMECOLLISION                                      _HRESULT_TYPEDEF_(0xc00d1134)
#define NS_S_WMPBR_SUCCESS                                            _HRESULT_TYPEDEF_(0x000d1135)
#define NS_S_WMPBR_PARTIALSUCCESS                                     _HRESULT_TYPEDEF_(0x000d1136)
#define NS_E_WMPBR_DRIVE_INVALID                                      _HRESULT_TYPEDEF_(0xc00d1137)
#define NS_E_WMPBR_BACKUPRESTOREFAILED                                _HRESULT_TYPEDEF_(0xc00d1138)
#define NS_S_WMPEFFECT_TRANSPARENT                                    _HRESULT_TYPEDEF_(0x000d1144)
#define NS_S_WMPEFFECT_OPAQUE                                         _HRESULT_TYPEDEF_(0x000d1145)
#define NS_S_OPERATION_PENDING                                        _HRESULT_TYPEDEF_(0x000d114e)
#define NS_E_WMP_CONVERT_FILE_FAILED                                  _HRESULT_TYPEDEF_(0xc00d1158)
#define NS_E_WMP_CONVERT_NO_RIGHTS_ERRORURL                           _HRESULT_TYPEDEF_(0xc00d1159)
#define NS_E_WMP_CONVERT_NO_RIGHTS_NOERRORURL                         _HRESULT_TYPEDEF_(0xc00d115a)
#define NS_E_WMP_CONVERT_FILE_CORRUPT                                 _HRESULT_TYPEDEF_(0xc00d115b)
#define NS_E_WMP_CONVERT_PLUGIN_UNAVAILABLE_ERRORURL                  _HRESULT_TYPEDEF_(0xc00d115c)
#define NS_E_WMP_CONVERT_PLUGIN_UNAVAILABLE_NOERRORURL                _HRESULT_TYPEDEF_(0xc00d115d)
#define NS_E_WMP_CONVERT_PLUGIN_UNKNOWN_FILE_OWNER                    _HRESULT_TYPEDEF_(0xc00d115e)
#define NS_E_DVD_DISC_COPY_PROTECT_OUTPUT_NS                          _HRESULT_TYPEDEF_(0xc00d1160)
#define NS_E_DVD_DISC_COPY_PROTECT_OUTPUT_FAILED                      _HRESULT_TYPEDEF_(0xc00d1161)
#define NS_E_DVD_NO_SUBPICTURE_STREAM                                 _HRESULT_TYPEDEF_(0xc00d1162)
#define NS_E_DVD_COPY_PROTECT                                         _HRESULT_TYPEDEF_(0xc00d1163)
#define NS_E_DVD_AUTHORING_PROBLEM                                    _HRESULT_TYPEDEF_(0xc00d1164)
#define NS_E_DVD_INVALID_DISC_REGION                                  _HRESULT_TYPEDEF_(0xc00d1165)
#define NS_E_DVD_COMPATIBLE_VIDEO_CARD                                _HRESULT_TYPEDEF_(0xc00d1166)
#define NS_E_DVD_MACROVISION                                          _HRESULT_TYPEDEF_(0xc00d1167)
#define NS_E_DVD_SYSTEM_DECODER_REGION                                _HRESULT_TYPEDEF_(0xc00d1168)
#define NS_E_DVD_DISC_DECODER_REGION                                  _HRESULT_TYPEDEF_(0xc00d1169)
#define NS_E_DVD_NO_VIDEO_STREAM                                      _HRESULT_TYPEDEF_(0xc00d116a)
#define NS_E_DVD_NO_AUDIO_STREAM                                      _HRESULT_TYPEDEF_(0xc00d116b)
#define NS_E_DVD_GRAPH_BUILDING                                       _HRESULT_TYPEDEF_(0xc00d116c)
#define NS_E_DVD_NO_DECODER                                           _HRESULT_TYPEDEF_(0xc00d116d)
#define NS_E_DVD_PARENTAL                                             _HRESULT_TYPEDEF_(0xc00d116e)
#define NS_E_DVD_CANNOT_JUMP                                          _HRESULT_TYPEDEF_(0xc00d116f)
#define NS_E_DVD_DEVICE_CONTENTION                                    _HRESULT_TYPEDEF_(0xc00d1170)
#define NS_E_DVD_NO_VIDEO_MEMORY                                      _HRESULT_TYPEDEF_(0xc00d1171)
#define NS_E_DVD_CANNOT_COPY_PROTECTED                                _HRESULT_TYPEDEF_(0xc00d1172)
#define NS_E_DVD_REQUIRED_PROPERTY_NOT_SET                            _HRESULT_TYPEDEF_(0xc00d1173)
#define NS_E_DVD_INVALID_TITLE_CHAPTER                                _HRESULT_TYPEDEF_(0xc00d1174)
#define NS_E_NO_CD_BURNER                                             _HRESULT_TYPEDEF_(0xc00d1176)
#define NS_E_DEVICE_IS_NOT_READY                                      _HRESULT_TYPEDEF_(0xc00d1177)
#define NS_E_PDA_UNSUPPORTED_FORMAT                                   _HRESULT_TYPEDEF_(0xc00d1178)
#define NS_E_NO_PDA                                                   _HRESULT_TYPEDEF_(0xc00d1179)
#define NS_E_PDA_UNSPECIFIED_ERROR                                    _HRESULT_TYPEDEF_(0xc00d117a)
#define NS_E_MEMSTORAGE_BAD_DATA                                      _HRESULT_TYPEDEF_(0xc00d117b)
#define NS_E_PDA_FAIL_SELECT_DEVICE                                   _HRESULT_TYPEDEF_(0xc00d117c)
#define NS_E_PDA_FAIL_READ_WAVE_FILE                                  _HRESULT_TYPEDEF_(0xc00d117d)
#define NS_E_IMAPI_LOSSOFSTREAMING                                    _HRESULT_TYPEDEF_(0xc00d117e)
#define NS_E_PDA_DEVICE_FULL                                          _HRESULT_TYPEDEF_(0xc00d117f)
#define NS_E_FAIL_LAUNCH_ROXIO_PLUGIN                                 _HRESULT_TYPEDEF_(0xc00d1180)
#define NS_E_PDA_DEVICE_FULL_IN_SESSION                               _HRESULT_TYPEDEF_(0xc00d1181)
#define NS_E_IMAPI_MEDIUM_INVALIDTYPE                                 _HRESULT_TYPEDEF_(0xc00d1182)
#define NS_E_PDA_MANUALDEVICE                                         _HRESULT_TYPEDEF_(0xc00d1183)
#define NS_E_PDA_PARTNERSHIPNOTEXIST                                  _HRESULT_TYPEDEF_(0xc00d1184)
#define NS_E_PDA_CANNOT_CREATE_ADDITIONAL_SYNC_RELATIONSHIP           _HRESULT_TYPEDEF_(0xc00d1185)
#define NS_E_PDA_NO_TRANSCODE_OF_DRM                                  _HRESULT_TYPEDEF_(0xc00d1186)
#define NS_E_PDA_TRANSCODECACHEFULL                                   _HRESULT_TYPEDEF_(0xc00d1187)
#define NS_E_PDA_TOO_MANY_FILE_COLLISIONS                             _HRESULT_TYPEDEF_(0xc00d1188)
#define NS_E_PDA_CANNOT_TRANSCODE                                     _HRESULT_TYPEDEF_(0xc00d1189)
#define NS_E_PDA_TOO_MANY_FILES_IN_DIRECTORY                          _HRESULT_TYPEDEF_(0xc00d118a)
#define NS_E_PROCESSINGSHOWSYNCWIZARD                                 _HRESULT_TYPEDEF_(0xc00d118b)
#define NS_E_PDA_TRANSCODE_NOT_PERMITTED                              _HRESULT_TYPEDEF_(0xc00d118c)
#define NS_E_PDA_INITIALIZINGDEVICES                                  _HRESULT_TYPEDEF_(0xc00d118d)
#define NS_E_PDA_OBSOLETE_SP                                          _HRESULT_TYPEDEF_(0xc00d118e)
#define NS_E_PDA_TITLE_COLLISION                                      _HRESULT_TYPEDEF_(0xc00d118f)
#define NS_E_PDA_DEVICESUPPORTDISABLED                                _HRESULT_TYPEDEF_(0xc00d1190)
#define NS_E_PDA_NO_LONGER_AVAILABLE                                  _HRESULT_TYPEDEF_(0xc00d1191)
#define NS_E_PDA_ENCODER_NOT_RESPONDING                               _HRESULT_TYPEDEF_(0xc00d1192)
#define NS_E_PDA_CANNOT_SYNC_FROM_LOCATION                            _HRESULT_TYPEDEF_(0xc00d1193)
#define NS_E_WMP_PROTOCOL_PROBLEM                                     _HRESULT_TYPEDEF_(0xc00d1194)
#define NS_E_WMP_NO_DISK_SPACE                                        _HRESULT_TYPEDEF_(0xc00d1195)
#define NS_E_WMP_LOGON_FAILURE                                        _HRESULT_TYPEDEF_(0xc00d1196)
#define NS_E_WMP_CANNOT_FIND_FILE                                     _HRESULT_TYPEDEF_(0xc00d1197)
#define NS_E_WMP_SERVER_INACCESSIBLE                                  _HRESULT_TYPEDEF_(0xc00d1198)
#define NS_E_WMP_UNSUPPORTED_FORMAT                                   _HRESULT_TYPEDEF_(0xc00d1199)
#define NS_E_WMP_DSHOW_UNSUPPORTED_FORMAT                             _HRESULT_TYPEDEF_(0xc00d119a)
#define NS_E_WMP_PLAYLIST_EXISTS                                      _HRESULT_TYPEDEF_(0xc00d119b)
#define NS_E_WMP_NONMEDIA_FILES                                       _HRESULT_TYPEDEF_(0xc00d119c)
#define NS_E_WMP_INVALID_ASX                                          _HRESULT_TYPEDEF_(0xc00d119d)
#define NS_E_WMP_ALREADY_IN_USE                                       _HRESULT_TYPEDEF_(0xc00d119e)
#define NS_E_WMP_IMAPI_FAILURE                                        _HRESULT_TYPEDEF_(0xc00d119f)
#define NS_E_WMP_WMDM_FAILURE                                         _HRESULT_TYPEDEF_(0xc00d11a0)
#define NS_E_WMP_CODEC_NEEDED_WITH_4CC                                _HRESULT_TYPEDEF_(0xc00d11a1)
#define NS_E_WMP_CODEC_NEEDED_WITH_FORMATTAG                          _HRESULT_TYPEDEF_(0xc00d11a2)
#define NS_E_WMP_MSSAP_NOT_AVAILABLE                                  _HRESULT_TYPEDEF_(0xc00d11a3)
#define NS_E_WMP_WMDM_INTERFACEDEAD                                   _HRESULT_TYPEDEF_(0xc00d11a4)
#define NS_E_WMP_WMDM_NOTCERTIFIED                                    _HRESULT_TYPEDEF_(0xc00d11a5)
#define NS_E_WMP_WMDM_LICENSE_NOTEXIST                                _HRESULT_TYPEDEF_(0xc00d11a6)
#define NS_E_WMP_WMDM_LICENSE_EXPIRED                                 _HRESULT_TYPEDEF_(0xc00d11a7)
#define NS_E_WMP_WMDM_BUSY                                            _HRESULT_TYPEDEF_(0xc00d11a8)
#define NS_E_WMP_WMDM_NORIGHTS                                        _HRESULT_TYPEDEF_(0xc00d11a9)
#define NS_E_WMP_WMDM_INCORRECT_RIGHTS                                _HRESULT_TYPEDEF_(0xc00d11aa)
#define NS_E_WMP_IMAPI_GENERIC                                        _HRESULT_TYPEDEF_(0xc00d11ab)
#define NS_E_WMP_IMAPI_DEVICE_NOTPRESENT                              _HRESULT_TYPEDEF_(0xc00d11ad)
#define NS_E_WMP_IMAPI_DEVICE_BUSY                                    _HRESULT_TYPEDEF_(0xc00d11ae)
#define NS_E_WMP_IMAPI_LOSS_OF_STREAMING                              _HRESULT_TYPEDEF_(0xc00d11af)
#define NS_E_WMP_SERVER_UNAVAILABLE                                   _HRESULT_TYPEDEF_(0xc00d11b0)
#define NS_E_WMP_FILE_OPEN_FAILED                                     _HRESULT_TYPEDEF_(0xc00d11b1)
#define NS_E_WMP_VERIFY_ONLINE                                        _HRESULT_TYPEDEF_(0xc00d11b2)
#define NS_E_WMP_SERVER_NOT_RESPONDING                                _HRESULT_TYPEDEF_(0xc00d11b3)
#define NS_E_WMP_DRM_CORRUPT_BACKUP                                   _HRESULT_TYPEDEF_(0xc00d11b4)
#define NS_E_WMP_DRM_LICENSE_SERVER_UNAVAILABLE                       _HRESULT_TYPEDEF_(0xc00d11b5)
#define NS_E_WMP_NETWORK_FIREWALL                                     _HRESULT_TYPEDEF_(0xc00d11b6)
#define NS_E_WMP_NO_REMOVABLE_MEDIA                                   _HRESULT_TYPEDEF_(0xc00d11b7)
#define NS_E_WMP_PROXY_CONNECT_TIMEOUT                                _HRESULT_TYPEDEF_(0xc00d11b8)
#define NS_E_WMP_NEED_UPGRADE                                         _HRESULT_TYPEDEF_(0xc00d11b9)
#define NS_E_WMP_AUDIO_HW_PROBLEM                                     _HRESULT_TYPEDEF_(0xc00d11ba)
#define NS_E_WMP_INVALID_PROTOCOL                                     _HRESULT_TYPEDEF_(0xc00d11bb)
#define NS_E_WMP_INVALID_LIBRARY_ADD                                  _HRESULT_TYPEDEF_(0xc00d11bc)
#define NS_E_WMP_MMS_NOT_SUPPORTED                                    _HRESULT_TYPEDEF_(0xc00d11bd)
#define NS_E_WMP_NO_PROTOCOLS_SELECTED                                _HRESULT_TYPEDEF_(0xc00d11be)
#define NS_E_WMP_GOFULLSCREEN_FAILED                                  _HRESULT_TYPEDEF_(0xc00d11bf)
#define NS_E_WMP_NETWORK_ERROR                                        _HRESULT_TYPEDEF_(0xc00d11c0)
#define NS_E_WMP_CONNECT_TIMEOUT                                      _HRESULT_TYPEDEF_(0xc00d11c1)
#define NS_E_WMP_MULTICAST_DISABLED                                   _HRESULT_TYPEDEF_(0xc00d11c2)
#define NS_E_WMP_SERVER_DNS_TIMEOUT                                   _HRESULT_TYPEDEF_(0xc00d11c3)
#define NS_E_WMP_PROXY_NOT_FOUND                                      _HRESULT_TYPEDEF_(0xc00d11c4)
#define NS_E_WMP_TAMPERED_CONTENT                                     _HRESULT_TYPEDEF_(0xc00d11c5)
#define NS_E_WMP_OUTOFMEMORY                                          _HRESULT_TYPEDEF_(0xc00d11c6)
#define NS_E_WMP_AUDIO_CODEC_NOT_INSTALLED                            _HRESULT_TYPEDEF_(0xc00d11c7)
#define NS_E_WMP_VIDEO_CODEC_NOT_INSTALLED                            _HRESULT_TYPEDEF_(0xc00d11c8)
#define NS_E_WMP_IMAPI_DEVICE_INVALIDTYPE                             _HRESULT_TYPEDEF_(0xc00d11c9)
#define NS_E_WMP_DRM_DRIVER_AUTH_FAILURE                              _HRESULT_TYPEDEF_(0xc00d11ca)
#define NS_E_WMP_NETWORK_RESOURCE_FAILURE                             _HRESULT_TYPEDEF_(0xc00d11cb)
#define NS_E_WMP_UPGRADE_APPLICATION                                  _HRESULT_TYPEDEF_(0xc00d11cc)
#define NS_E_WMP_UNKNOWN_ERROR                                        _HRESULT_TYPEDEF_(0xc00d11cd)
#define NS_E_WMP_INVALID_KEY                                          _HRESULT_TYPEDEF_(0xc00d11ce)
#define NS_E_WMP_CD_ANOTHER_USER                                      _HRESULT_TYPEDEF_(0xc00d11cf)
#define NS_E_WMP_DRM_NEEDS_AUTHORIZATION                              _HRESULT_TYPEDEF_(0xc00d11d0)
#define NS_E_WMP_BAD_DRIVER                                           _HRESULT_TYPEDEF_(0xc00d11d1)
#define NS_E_WMP_ACCESS_DENIED                                        _HRESULT_TYPEDEF_(0xc00d11d2)
#define NS_E_WMP_LICENSE_RESTRICTS                                    _HRESULT_TYPEDEF_(0xc00d11d3)
#define NS_E_WMP_INVALID_REQUEST                                      _HRESULT_TYPEDEF_(0xc00d11d4)
#define NS_E_WMP_CD_STASH_NO_SPACE                                    _HRESULT_TYPEDEF_(0xc00d11d5)
#define NS_E_WMP_DRM_NEW_HARDWARE                                     _HRESULT_TYPEDEF_(0xc00d11d6)
#define NS_E_WMP_DRM_INVALID_SIG                                      _HRESULT_TYPEDEF_(0xc00d11d7)
#define NS_E_WMP_DRM_CANNOT_RESTORE                                   _HRESULT_TYPEDEF_(0xc00d11d8)
#define NS_E_WMP_BURN_DISC_OVERFLOW                                   _HRESULT_TYPEDEF_(0xc00d11d9)
#define NS_E_WMP_DRM_GENERIC_LICENSE_FAILURE                          _HRESULT_TYPEDEF_(0xc00d11da)
#define NS_E_WMP_DRM_NO_SECURE_CLOCK                                  _HRESULT_TYPEDEF_(0xc00d11db)
#define NS_E_WMP_DRM_NO_RIGHTS                                        _HRESULT_TYPEDEF_(0xc00d11dc)
#define NS_E_WMP_DRM_INDIV_FAILED                                     _HRESULT_TYPEDEF_(0xc00d11dd)
#define NS_E_WMP_SERVER_NONEWCONNECTIONS                              _HRESULT_TYPEDEF_(0xc00d11de)
#define NS_E_WMP_MULTIPLE_ERROR_IN_PLAYLIST                           _HRESULT_TYPEDEF_(0xc00d11df)
#define NS_E_WMP_IMAPI2_ERASE_FAIL                                    _HRESULT_TYPEDEF_(0xc00d11e0)
#define NS_E_WMP_IMAPI2_ERASE_DEVICE_BUSY                             _HRESULT_TYPEDEF_(0xc00d11e1)
#define NS_E_WMP_DRM_COMPONENT_FAILURE                                _HRESULT_TYPEDEF_(0xc00d11e2)
#define NS_E_WMP_DRM_NO_DEVICE_CERT                                   _HRESULT_TYPEDEF_(0xc00d11e3)
#define NS_E_WMP_SERVER_SECURITY_ERROR                                _HRESULT_TYPEDEF_(0xc00d11e4)
#define NS_E_WMP_AUDIO_DEVICE_LOST                                    _HRESULT_TYPEDEF_(0xc00d11e5)
#define NS_E_WMP_IMAPI_MEDIA_INCOMPATIBLE                             _HRESULT_TYPEDEF_(0xc00d11e6)
#define NS_E_SYNCWIZ_DEVICE_FULL                                      _HRESULT_TYPEDEF_(0xc00d11ee)
#define NS_E_SYNCWIZ_CANNOT_CHANGE_SETTINGS                           _HRESULT_TYPEDEF_(0xc00d11ef)
#define NS_E_TRANSCODE_DELETECACHEERROR                               _HRESULT_TYPEDEF_(0xc00d11f0)
#define NS_E_CD_NO_BUFFERS_READ                                       _HRESULT_TYPEDEF_(0xc00d11f8)
#define NS_E_CD_EMPTY_TRACK_QUEUE                                     _HRESULT_TYPEDEF_(0xc00d11f9)
#define NS_E_CD_NO_READER                                             _HRESULT_TYPEDEF_(0xc00d11fa)
#define NS_E_CD_ISRC_INVALID                                          _HRESULT_TYPEDEF_(0xc00d11fb)
#define NS_E_CD_MEDIA_CATALOG_NUMBER_INVALID                          _HRESULT_TYPEDEF_(0xc00d11fc)
#define NS_E_SLOW_READ_DIGITAL_WITH_ERRORCORRECTION                   _HRESULT_TYPEDEF_(0xc00d11fd)
#define NS_E_CD_SPEEDDETECT_NOT_ENOUGH_READS                          _HRESULT_TYPEDEF_(0xc00d11fe)
#define NS_E_CD_QUEUEING_DISABLED                                     _HRESULT_TYPEDEF_(0xc00d11ff)
#define NS_E_WMP_DRM_ACQUIRING_LICENSE                                _HRESULT_TYPEDEF_(0xc00d1202)
#define NS_E_WMP_DRM_LICENSE_EXPIRED                                  _HRESULT_TYPEDEF_(0xc00d1203)
#define NS_E_WMP_DRM_LICENSE_NOTACQUIRED                              _HRESULT_TYPEDEF_(0xc00d1204)
#define NS_E_WMP_DRM_LICENSE_NOTENABLED                               _HRESULT_TYPEDEF_(0xc00d1205)
#define NS_E_WMP_DRM_LICENSE_UNUSABLE                                 _HRESULT_TYPEDEF_(0xc00d1206)
#define NS_E_WMP_DRM_LICENSE_CONTENT_REVOKED                          _HRESULT_TYPEDEF_(0xc00d1207)
#define NS_E_WMP_DRM_LICENSE_NOSAP                                    _HRESULT_TYPEDEF_(0xc00d1208)
#define NS_E_WMP_DRM_UNABLE_TO_ACQUIRE_LICENSE                        _HRESULT_TYPEDEF_(0xc00d1209)
#define NS_E_WMP_LICENSE_REQUIRED                                     _HRESULT_TYPEDEF_(0xc00d120a)
#define NS_E_WMP_PROTECTED_CONTENT                                    _HRESULT_TYPEDEF_(0xc00d120b)
#define NS_E_WMP_POLICY_VALUE_NOT_CONFIGURED                          _HRESULT_TYPEDEF_(0xc00d122a)
#define NS_E_PDA_CANNOT_SYNC_FROM_INTERNET                            _HRESULT_TYPEDEF_(0xc00d1234)
#define NS_E_PDA_CANNOT_SYNC_INVALID_PLAYLIST                         _HRESULT_TYPEDEF_(0xc00d1235)
#define NS_E_PDA_FAILED_TO_SYNCHRONIZE_FILE                           _HRESULT_TYPEDEF_(0xc00d1236)
#define NS_E_PDA_SYNC_FAILED                                          _HRESULT_TYPEDEF_(0xc00d1237)
#define NS_E_PDA_DELETE_FAILED                                        _HRESULT_TYPEDEF_(0xc00d1238)
#define NS_E_PDA_FAILED_TO_RETRIEVE_FILE                              _HRESULT_TYPEDEF_(0xc00d1239)
#define NS_E_PDA_DEVICE_NOT_RESPONDING                                _HRESULT_TYPEDEF_(0xc00d123a)
#define NS_E_PDA_FAILED_TO_TRANSCODE_PHOTO                            _HRESULT_TYPEDEF_(0xc00d123b)
#define NS_E_PDA_FAILED_TO_ENCRYPT_TRANSCODED_FILE                    _HRESULT_TYPEDEF_(0xc00d123c)
#define NS_E_PDA_CANNOT_TRANSCODE_TO_AUDIO                            _HRESULT_TYPEDEF_(0xc00d123d)
#define NS_E_PDA_CANNOT_TRANSCODE_TO_VIDEO                            _HRESULT_TYPEDEF_(0xc00d123e)
#define NS_E_PDA_CANNOT_TRANSCODE_TO_IMAGE                            _HRESULT_TYPEDEF_(0xc00d123f)
#define NS_E_PDA_RETRIEVED_FILE_FILENAME_TOO_LONG                     _HRESULT_TYPEDEF_(0xc00d1240)
#define NS_E_PDA_CEWMDM_DRM_ERROR                                     _HRESULT_TYPEDEF_(0xc00d1241)
#define NS_E_INCOMPLETE_PLAYLIST                                      _HRESULT_TYPEDEF_(0xc00d1242)
#define NS_E_PDA_SYNC_RUNNING                                         _HRESULT_TYPEDEF_(0xc00d1243)
#define NS_E_PDA_SYNC_LOGIN_ERROR                                     _HRESULT_TYPEDEF_(0xc00d1244)
#define NS_E_PDA_TRANSCODE_CODEC_NOT_FOUND                            _HRESULT_TYPEDEF_(0xc00d1245)
#define NS_E_CANNOT_SYNC_DRM_TO_NON_JANUS_DEVICE                      _HRESULT_TYPEDEF_(0xc00d1246)
#define NS_E_CANNOT_SYNC_PREVIOUS_SYNC_RUNNING                        _HRESULT_TYPEDEF_(0xc00d1247)
#define NS_E_WMP_HWND_NOTFOUND                                        _HRESULT_TYPEDEF_(0xc00d125c)
#define NS_E_BKGDOWNLOAD_WRONG_NO_FILES                               _HRESULT_TYPEDEF_(0xc00d125d)
#define NS_E_BKGDOWNLOAD_COMPLETECANCELLEDJOB                         _HRESULT_TYPEDEF_(0xc00d125e)
#define NS_E_BKGDOWNLOAD_CANCELCOMPLETEDJOB                           _HRESULT_TYPEDEF_(0xc00d125f)
#define NS_E_BKGDOWNLOAD_NOJOBPOINTER                                 _HRESULT_TYPEDEF_(0xc00d1260)
#define NS_E_BKGDOWNLOAD_INVALIDJOBSIGNATURE                          _HRESULT_TYPEDEF_(0xc00d1261)
#define NS_E_BKGDOWNLOAD_FAILED_TO_CREATE_TEMPFILE                    _HRESULT_TYPEDEF_(0xc00d1262)
#define NS_E_BKGDOWNLOAD_PLUGIN_FAILEDINITIALIZE                      _HRESULT_TYPEDEF_(0xc00d1263)
#define NS_E_BKGDOWNLOAD_PLUGIN_FAILEDTOMOVEFILE                      _HRESULT_TYPEDEF_(0xc00d1264)
#define NS_E_BKGDOWNLOAD_CALLFUNCFAILED                               _HRESULT_TYPEDEF_(0xc00d1265)
#define NS_E_BKGDOWNLOAD_CALLFUNCTIMEOUT                              _HRESULT_TYPEDEF_(0xc00d1266)
#define NS_E_BKGDOWNLOAD_CALLFUNCENDED                                _HRESULT_TYPEDEF_(0xc00d1267)
#define NS_E_BKGDOWNLOAD_WMDUNPACKFAILED                              _HRESULT_TYPEDEF_(0xc00d1268)
#define NS_E_BKGDOWNLOAD_FAILEDINITIALIZE                             _HRESULT_TYPEDEF_(0xc00d1269)
#define NS_E_INTERFACE_NOT_REGISTERED_IN_GIT                          _HRESULT_TYPEDEF_(0xc00d126a)
#define NS_E_BKGDOWNLOAD_INVALID_FILE_NAME                            _HRESULT_TYPEDEF_(0xc00d126b)
#define NS_E_IMAGE_DOWNLOAD_FAILED                                    _HRESULT_TYPEDEF_(0xc00d128e)
#define NS_E_WMP_UDRM_NOUSERLIST                                      _HRESULT_TYPEDEF_(0xc00d12c0)
#define NS_E_WMP_DRM_NOT_ACQUIRING                                    _HRESULT_TYPEDEF_(0xc00d12c1)
#define NS_E_WMP_BSTR_TOO_LONG                                        _HRESULT_TYPEDEF_(0xc00d12f2)
#define NS_E_WMP_AUTOPLAY_INVALID_STATE                               _HRESULT_TYPEDEF_(0xc00d12fc)
#define NS_E_WMP_COMPONENT_REVOKED                                    _HRESULT_TYPEDEF_(0xc00d1306)
#define NS_E_CURL_NOTSAFE                                             _HRESULT_TYPEDEF_(0xc00d1324)
#define NS_E_CURL_INVALIDCHAR                                         _HRESULT_TYPEDEF_(0xc00d1325)
#define NS_E_CURL_INVALIDHOSTNAME                                     _HRESULT_TYPEDEF_(0xc00d1326)
#define NS_E_CURL_INVALIDPATH                                         _HRESULT_TYPEDEF_(0xc00d1327)
#define NS_E_CURL_INVALIDSCHEME                                       _HRESULT_TYPEDEF_(0xc00d1328)
#define NS_E_CURL_INVALIDURL                                          _HRESULT_TYPEDEF_(0xc00d1329)
#define NS_E_CURL_CANTWALK                                            _HRESULT_TYPEDEF_(0xc00d132b)
#define NS_E_CURL_INVALIDPORT                                         _HRESULT_TYPEDEF_(0xc00d132c)
#define NS_E_CURLHELPER_NOTADIRECTORY                                 _HRESULT_TYPEDEF_(0xc00d132d)
#define NS_E_CURLHELPER_NOTAFILE                                      _HRESULT_TYPEDEF_(0xc00d132e)
#define NS_E_CURL_CANTDECODE                                          _HRESULT_TYPEDEF_(0xc00d132f)
#define NS_E_CURLHELPER_NOTRELATIVE                                   _HRESULT_TYPEDEF_(0xc00d1330)
#define NS_E_CURL_INVALIDBUFFERSIZE                                   _HRESULT_TYPEDEF_(0xc00d1331)
#define NS_E_SUBSCRIPTIONSERVICE_PLAYBACK_DISALLOWED                  _HRESULT_TYPEDEF_(0xc00d1356)
#define NS_E_CANNOT_BUY_OR_DOWNLOAD_FROM_MULTIPLE_SERVICES            _HRESULT_TYPEDEF_(0xc00d1357)
#define NS_E_CANNOT_BUY_OR_DOWNLOAD_CONTENT                           _HRESULT_TYPEDEF_(0xc00d1358)
#define NS_S_TRACK_BUY_REQUIRES_ALBUM_PURCHASE                        _HRESULT_TYPEDEF_(0x000d1359)
#define NS_E_NOT_CONTENT_PARTNER_TRACK                                _HRESULT_TYPEDEF_(0xc00d135a)
#define NS_E_TRACK_DOWNLOAD_REQUIRES_ALBUM_PURCHASE                   _HRESULT_TYPEDEF_(0xc00d135b)
#define NS_E_TRACK_DOWNLOAD_REQUIRES_PURCHASE                         _HRESULT_TYPEDEF_(0xc00d135c)
#define NS_E_TRACK_PURCHASE_MAXIMUM_EXCEEDED                          _HRESULT_TYPEDEF_(0xc00d135d)
#define NS_S_NAVIGATION_COMPLETE_WITH_ERRORS                          _HRESULT_TYPEDEF_(0x000d135e)
#define NS_E_SUBSCRIPTIONSERVICE_LOGIN_FAILED                         _HRESULT_TYPEDEF_(0xc00d135f)
#define NS_E_SUBSCRIPTIONSERVICE_DOWNLOAD_TIMEOUT                     _HRESULT_TYPEDEF_(0xc00d1360)
#define NS_S_TRACK_ALREADY_DOWNLOADED                                 _HRESULT_TYPEDEF_(0x000d1361)
#define NS_E_CONTENT_PARTNER_STILL_INITIALIZING                       _HRESULT_TYPEDEF_(0xc00d1362)
#define NS_E_OPEN_CONTAINING_FOLDER_FAILED                            _HRESULT_TYPEDEF_(0xc00d1363)
#define NS_E_ADVANCEDEDIT_TOO_MANY_PICTURES                           _HRESULT_TYPEDEF_(0xc00d136a)

/* Windows Media Server errors */
#define NS_E_REDIRECT                                                 _HRESULT_TYPEDEF_(0xc00d1388)
#define NS_E_STALE_PRESENTATION                                       _HRESULT_TYPEDEF_(0xc00d1389)
#define NS_E_NAMESPACE_WRONG_PERSIST                                  _HRESULT_TYPEDEF_(0xc00d138a)
#define NS_E_NAMESPACE_WRONG_TYPE                                     _HRESULT_TYPEDEF_(0xc00d138b)
#define NS_E_NAMESPACE_NODE_CONFLICT                                  _HRESULT_TYPEDEF_(0xc00d138c)
#define NS_E_NAMESPACE_NODE_NOT_FOUND                                 _HRESULT_TYPEDEF_(0xc00d138d)
#define NS_E_NAMESPACE_BUFFER_TOO_SMALL                               _HRESULT_TYPEDEF_(0xc00d138e)
#define NS_E_NAMESPACE_TOO_MANY_CALLBACKS                             _HRESULT_TYPEDEF_(0xc00d138f)
#define NS_E_NAMESPACE_DUPLICATE_CALLBACK                             _HRESULT_TYPEDEF_(0xc00d1390)
#define NS_E_NAMESPACE_CALLBACK_NOT_FOUND                             _HRESULT_TYPEDEF_(0xc00d1391)
#define NS_E_NAMESPACE_NAME_TOO_LONG                                  _HRESULT_TYPEDEF_(0xc00d1392)
#define NS_E_NAMESPACE_DUPLICATE_NAME                                 _HRESULT_TYPEDEF_(0xc00d1393)
#define NS_E_NAMESPACE_EMPTY_NAME                                     _HRESULT_TYPEDEF_(0xc00d1394)
#define NS_E_NAMESPACE_INDEX_TOO_LARGE                                _HRESULT_TYPEDEF_(0xc00d1395)
#define NS_E_NAMESPACE_BAD_NAME                                       _HRESULT_TYPEDEF_(0xc00d1396)
#define NS_E_NAMESPACE_WRONG_SECURITY                                 _HRESULT_TYPEDEF_(0xc00d1397)
#define NS_E_CACHE_ARCHIVE_CONFLICT                                   _HRESULT_TYPEDEF_(0xc00d13ec)
#define NS_E_CACHE_ORIGIN_SERVER_NOT_FOUND                            _HRESULT_TYPEDEF_(0xc00d13ed)
#define NS_E_CACHE_ORIGIN_SERVER_TIMEOUT                              _HRESULT_TYPEDEF_(0xc00d13ee)
#define NS_E_CACHE_NOT_BROADCAST                                      _HRESULT_TYPEDEF_(0xc00d13ef)
#define NS_E_CACHE_CANNOT_BE_CACHED                                   _HRESULT_TYPEDEF_(0xc00d13f0)
#define NS_E_CACHE_NOT_MODIFIED                                       _HRESULT_TYPEDEF_(0xc00d13f1)
#define NS_E_CANNOT_REMOVE_PUBLISHING_POINT                           _HRESULT_TYPEDEF_(0xc00d1450)
#define NS_E_CANNOT_REMOVE_PLUGIN                                     _HRESULT_TYPEDEF_(0xc00d1451)
#define NS_E_WRONG_PUBLISHING_POINT_TYPE                              _HRESULT_TYPEDEF_(0xc00d1452)
#define NS_E_UNSUPPORTED_LOAD_TYPE                                    _HRESULT_TYPEDEF_(0xc00d1453)
#define NS_E_INVALID_PLUGIN_LOAD_TYPE_CONFIGURATION                   _HRESULT_TYPEDEF_(0xc00d1454)
#define NS_E_INVALID_PUBLISHING_POINT_NAME                            _HRESULT_TYPEDEF_(0xc00d1455)
#define NS_E_TOO_MANY_MULTICAST_SINKS                                 _HRESULT_TYPEDEF_(0xc00d1456)
#define NS_E_PUBLISHING_POINT_INVALID_REQUEST_WHILE_STARTED           _HRESULT_TYPEDEF_(0xc00d1457)
#define NS_E_MULTICAST_PLUGIN_NOT_ENABLED                             _HRESULT_TYPEDEF_(0xc00d1458)
#define NS_E_INVALID_OPERATING_SYSTEM_VERSION                         _HRESULT_TYPEDEF_(0xc00d1459)
#define NS_E_PUBLISHING_POINT_REMOVED                                 _HRESULT_TYPEDEF_(0xc00d145a)
#define NS_E_INVALID_PUSH_PUBLISHING_POINT_START_REQUEST              _HRESULT_TYPEDEF_(0xc00d145b)
#define NS_E_UNSUPPORTED_LANGUAGE                                     _HRESULT_TYPEDEF_(0xc00d145c)
#define NS_E_WRONG_OS_VERSION                                         _HRESULT_TYPEDEF_(0xc00d145d)
#define NS_E_PUBLISHING_POINT_STOPPED                                 _HRESULT_TYPEDEF_(0xc00d145e)
#define NS_E_PLAYLIST_ENTRY_ALREADY_PLAYING                           _HRESULT_TYPEDEF_(0xc00d14b4)
#define NS_E_EMPTY_PLAYLIST                                           _HRESULT_TYPEDEF_(0xc00d14b5)
#define NS_E_PLAYLIST_PARSE_FAILURE                                   _HRESULT_TYPEDEF_(0xc00d14b6)
#define NS_E_PLAYLIST_UNSUPPORTED_ENTRY                               _HRESULT_TYPEDEF_(0xc00d14b7)
#define NS_E_PLAYLIST_ENTRY_NOT_IN_PLAYLIST                           _HRESULT_TYPEDEF_(0xc00d14b8)
#define NS_E_PLAYLIST_ENTRY_SEEK                                      _HRESULT_TYPEDEF_(0xc00d14b9)
#define NS_E_PLAYLIST_RECURSIVE_PLAYLISTS                             _HRESULT_TYPEDEF_(0xc00d14ba)
#define NS_E_PLAYLIST_TOO_MANY_NESTED_PLAYLISTS                       _HRESULT_TYPEDEF_(0xc00d14bb)
#define NS_E_PLAYLIST_SHUTDOWN                                        _HRESULT_TYPEDEF_(0xc00d14bc)
#define NS_E_PLAYLIST_END_RECEDING                                    _HRESULT_TYPEDEF_(0xc00d14bd)
#define NS_I_PLAYLIST_CHANGE_RECEDING                                 _HRESULT_TYPEDEF_(0x400d14be)
#define NS_E_DATAPATH_NO_SINK                                         _HRESULT_TYPEDEF_(0xc00d1518)
#define NS_S_PUBLISHING_POINT_STARTED_WITH_FAILED_SINKS               _HRESULT_TYPEDEF_(0x000d1519)
#define NS_E_INVALID_PUSH_TEMPLATE                                    _HRESULT_TYPEDEF_(0xc00d151a)
#define NS_E_INVALID_PUSH_PUBLISHING_POINT                            _HRESULT_TYPEDEF_(0xc00d151b)
#define NS_E_CRITICAL_ERROR                                           _HRESULT_TYPEDEF_(0xc00d151c)
#define NS_E_NO_NEW_CONNECTIONS                                       _HRESULT_TYPEDEF_(0xc00d151d)
#define NS_E_WSX_INVALID_VERSION                                      _HRESULT_TYPEDEF_(0xc00d151e)
#define NS_E_HEADER_MISMATCH                                          _HRESULT_TYPEDEF_(0xc00d151f)
#define NS_E_PUSH_DUPLICATE_PUBLISHING_POINT_NAME                     _HRESULT_TYPEDEF_(0xc00d1520)
#define NS_E_NO_SCRIPT_ENGINE                                         _HRESULT_TYPEDEF_(0xc00d157c)
#define NS_E_PLUGIN_ERROR_REPORTED                                    _HRESULT_TYPEDEF_(0xc00d157d)
#define NS_E_SOURCE_PLUGIN_NOT_FOUND                                  _HRESULT_TYPEDEF_(0xc00d157e)
#define NS_E_PLAYLIST_PLUGIN_NOT_FOUND                                _HRESULT_TYPEDEF_(0xc00d157f)
#define NS_E_DATA_SOURCE_ENUMERATION_NOT_SUPPORTED                    _HRESULT_TYPEDEF_(0xc00d1580)
#define NS_E_MEDIA_PARSER_INVALID_FORMAT                              _HRESULT_TYPEDEF_(0xc00d1581)
#define NS_E_SCRIPT_DEBUGGER_NOT_INSTALLED                            _HRESULT_TYPEDEF_(0xc00d1582)
#define NS_E_FEATURE_REQUIRES_ENTERPRISE_SERVER                       _HRESULT_TYPEDEF_(0xc00d1583)
#define NS_E_WIZARD_RUNNING                                           _HRESULT_TYPEDEF_(0xc00d1584)
#define NS_E_INVALID_LOG_URL                                          _HRESULT_TYPEDEF_(0xc00d1585)
#define NS_E_INVALID_MTU_RANGE                                        _HRESULT_TYPEDEF_(0xc00d1586)
#define NS_E_INVALID_PLAY_STATISTICS                                  _HRESULT_TYPEDEF_(0xc00d1587)
#define NS_E_LOG_NEED_TO_BE_SKIPPED                                   _HRESULT_TYPEDEF_(0xc00d1588)
#define NS_E_HTTP_TEXT_DATACONTAINER_SIZE_LIMIT_EXCEEDED              _HRESULT_TYPEDEF_(0xc00d1589)
#define NS_E_PORT_IN_USE                                              _HRESULT_TYPEDEF_(0xc00d158a)
#define NS_E_PORT_IN_USE_HTTP                                         _HRESULT_TYPEDEF_(0xc00d158b)
#define NS_E_HTTP_TEXT_DATACONTAINER_INVALID_SERVER_RESPONSE          _HRESULT_TYPEDEF_(0xc00d158c)
#define NS_E_ARCHIVE_REACH_QUOTA                                      _HRESULT_TYPEDEF_(0xc00d158d)
#define NS_E_ARCHIVE_ABORT_DUE_TO_BCAST                               _HRESULT_TYPEDEF_(0xc00d158e)
#define NS_E_ARCHIVE_GAP_DETECTED                                     _HRESULT_TYPEDEF_(0xc00d158f)
#define NS_E_AUTHORIZATION_FILE_NOT_FOUND                             _HRESULT_TYPEDEF_(0xc00d1590)

/* Windows Media Tools errors */
#define NS_E_BAD_MARKIN                                               _HRESULT_TYPEDEF_(0xc00d1b58)
#define NS_E_BAD_MARKOUT                                              _HRESULT_TYPEDEF_(0xc00d1b59)
#define NS_E_NOMATCHING_MEDIASOURCE                                   _HRESULT_TYPEDEF_(0xc00d1b5a)
#define NS_E_UNSUPPORTED_SOURCETYPE                                   _HRESULT_TYPEDEF_(0xc00d1b5b)
#define NS_E_TOO_MANY_AUDIO                                           _HRESULT_TYPEDEF_(0xc00d1b5c)
#define NS_E_TOO_MANY_VIDEO                                           _HRESULT_TYPEDEF_(0xc00d1b5d)
#define NS_E_NOMATCHING_ELEMENT                                       _HRESULT_TYPEDEF_(0xc00d1b5e)
#define NS_E_MISMATCHED_MEDIACONTENT                                  _HRESULT_TYPEDEF_(0xc00d1b5f)
#define NS_E_CANNOT_DELETE_ACTIVE_SOURCEGROUP                         _HRESULT_TYPEDEF_(0xc00d1b60)
#define NS_E_AUDIODEVICE_BUSY                                         _HRESULT_TYPEDEF_(0xc00d1b61)
#define NS_E_AUDIODEVICE_UNEXPECTED                                   _HRESULT_TYPEDEF_(0xc00d1b62)
#define NS_E_AUDIODEVICE_BADFORMAT                                    _HRESULT_TYPEDEF_(0xc00d1b63)
#define NS_E_VIDEODEVICE_BUSY                                         _HRESULT_TYPEDEF_(0xc00d1b64)
#define NS_E_VIDEODEVICE_UNEXPECTED                                   _HRESULT_TYPEDEF_(0xc00d1b65)
#define NS_E_INVALIDCALL_WHILE_ENCODER_RUNNING                        _HRESULT_TYPEDEF_(0xc00d1b66)
#define NS_E_NO_PROFILE_IN_SOURCEGROUP                                _HRESULT_TYPEDEF_(0xc00d1b67)
#define NS_E_VIDEODRIVER_UNSTABLE                                     _HRESULT_TYPEDEF_(0xc00d1b68)
#define NS_E_VIDCAPSTARTFAILED                                        _HRESULT_TYPEDEF_(0xc00d1b69)
#define NS_E_VIDSOURCECOMPRESSION                                     _HRESULT_TYPEDEF_(0xc00d1b6a)
#define NS_E_VIDSOURCESIZE                                            _HRESULT_TYPEDEF_(0xc00d1b6b)
#define NS_E_ICMQUERYFORMAT                                           _HRESULT_TYPEDEF_(0xc00d1b6c)
#define NS_E_VIDCAPCREATEWINDOW                                       _HRESULT_TYPEDEF_(0xc00d1b6d)
#define NS_E_VIDCAPDRVINUSE                                           _HRESULT_TYPEDEF_(0xc00d1b6e)
#define NS_E_NO_MEDIAFORMAT_IN_SOURCE                                 _HRESULT_TYPEDEF_(0xc00d1b6f)
#define NS_E_NO_VALID_OUTPUT_STREAM                                   _HRESULT_TYPEDEF_(0xc00d1b70)
#define NS_E_NO_VALID_SOURCE_PLUGIN                                   _HRESULT_TYPEDEF_(0xc00d1b71)
#define NS_E_NO_ACTIVE_SOURCEGROUP                                    _HRESULT_TYPEDEF_(0xc00d1b72)
#define NS_E_NO_SCRIPT_STREAM                                         _HRESULT_TYPEDEF_(0xc00d1b73)
#define NS_E_INVALIDCALL_WHILE_ARCHIVAL_RUNNING                       _HRESULT_TYPEDEF_(0xc00d1b74)
#define NS_E_INVALIDPACKETSIZE                                        _HRESULT_TYPEDEF_(0xc00d1b75)
#define NS_E_PLUGIN_CLSID_INVALID                                     _HRESULT_TYPEDEF_(0xc00d1b76)
#define NS_E_UNSUPPORTED_ARCHIVETYPE                                  _HRESULT_TYPEDEF_(0xc00d1b77)
#define NS_E_UNSUPPORTED_ARCHIVEOPERATION                             _HRESULT_TYPEDEF_(0xc00d1b78)
#define NS_E_ARCHIVE_FILENAME_NOTSET                                  _HRESULT_TYPEDEF_(0xc00d1b79)
#define NS_E_SOURCEGROUP_NOTPREPARED                                  _HRESULT_TYPEDEF_(0xc00d1b7a)
#define NS_E_PROFILE_MISMATCH                                         _HRESULT_TYPEDEF_(0xc00d1b7b)
#define NS_E_INCORRECTCLIPSETTINGS                                    _HRESULT_TYPEDEF_(0xc00d1b7c)
#define NS_E_NOSTATSAVAILABLE                                         _HRESULT_TYPEDEF_(0xc00d1b7d)
#define NS_E_NOTARCHIVING                                             _HRESULT_TYPEDEF_(0xc00d1b7e)
#define NS_E_INVALIDCALL_WHILE_ENCODER_STOPPED                        _HRESULT_TYPEDEF_(0xc00d1b7f)
#define NS_E_NOSOURCEGROUPS                                           _HRESULT_TYPEDEF_(0xc00d1b80)
#define NS_E_INVALIDINPUTFPS                                          _HRESULT_TYPEDEF_(0xc00d1b81)
#define NS_E_NO_DATAVIEW_SUPPORT                                      _HRESULT_TYPEDEF_(0xc00d1b82)
#define NS_E_CODEC_UNAVAILABLE                                        _HRESULT_TYPEDEF_(0xc00d1b83)
#define NS_E_ARCHIVE_SAME_AS_INPUT                                    _HRESULT_TYPEDEF_(0xc00d1b84)
#define NS_E_SOURCE_NOTSPECIFIED                                      _HRESULT_TYPEDEF_(0xc00d1b85)
#define NS_E_NO_REALTIME_TIMECOMPRESSION                              _HRESULT_TYPEDEF_(0xc00d1b86)
#define NS_E_UNSUPPORTED_ENCODER_DEVICE                               _HRESULT_TYPEDEF_(0xc00d1b87)
#define NS_E_UNEXPECTED_DISPLAY_SETTINGS                              _HRESULT_TYPEDEF_(0xc00d1b88)
#define NS_E_NO_AUDIODATA                                             _HRESULT_TYPEDEF_(0xc00d1b89)
#define NS_E_INPUTSOURCE_PROBLEM                                      _HRESULT_TYPEDEF_(0xc00d1b8a)
#define NS_E_WME_VERSION_MISMATCH                                     _HRESULT_TYPEDEF_(0xc00d1b8b)
#define NS_E_NO_REALTIME_PREPROCESS                                   _HRESULT_TYPEDEF_(0xc00d1b8c)
#define NS_E_NO_REPEAT_PREPROCESS                                     _HRESULT_TYPEDEF_(0xc00d1b8d)
#define NS_E_CANNOT_PAUSE_LIVEBROADCAST                               _HRESULT_TYPEDEF_(0xc00d1b8e)
#define NS_E_DRM_PROFILE_NOT_SET                                      _HRESULT_TYPEDEF_(0xc00d1b8f)
#define NS_E_DUPLICATE_DRMPROFILE                                     _HRESULT_TYPEDEF_(0xc00d1b90)
#define NS_E_INVALID_DEVICE                                           _HRESULT_TYPEDEF_(0xc00d1b91)
#define NS_E_SPEECHEDL_ON_NON_MIXEDMODE                               _HRESULT_TYPEDEF_(0xc00d1b92)
#define NS_E_DRM_PASSWORD_TOO_LONG                                    _HRESULT_TYPEDEF_(0xc00d1b93)
#define NS_E_DEVCONTROL_FAILED_SEEK                                   _HRESULT_TYPEDEF_(0xc00d1b94)
#define NS_E_INTERLACE_REQUIRE_SAMESIZE                               _HRESULT_TYPEDEF_(0xc00d1b95)
#define NS_E_TOO_MANY_DEVICECONTROL                                   _HRESULT_TYPEDEF_(0xc00d1b96)
#define NS_E_NO_MULTIPASS_FOR_LIVEDEVICE                              _HRESULT_TYPEDEF_(0xc00d1b97)
#define NS_E_MISSING_AUDIENCE                                         _HRESULT_TYPEDEF_(0xc00d1b98)
#define NS_E_AUDIENCE_CONTENTTYPE_MISMATCH                            _HRESULT_TYPEDEF_(0xc00d1b99)
#define NS_E_MISSING_SOURCE_INDEX                                     _HRESULT_TYPEDEF_(0xc00d1b9a)
#define NS_E_NUM_LANGUAGE_MISMATCH                                    _HRESULT_TYPEDEF_(0xc00d1b9b)
#define NS_E_LANGUAGE_MISMATCH                                        _HRESULT_TYPEDEF_(0xc00d1b9c)
#define NS_E_VBRMODE_MISMATCH                                         _HRESULT_TYPEDEF_(0xc00d1b9d)
#define NS_E_INVALID_INPUT_AUDIENCE_INDEX                             _HRESULT_TYPEDEF_(0xc00d1b9e)
#define NS_E_INVALID_INPUT_LANGUAGE                                   _HRESULT_TYPEDEF_(0xc00d1b9f)
#define NS_E_INVALID_INPUT_STREAM                                     _HRESULT_TYPEDEF_(0xc00d1ba0)
#define NS_E_EXPECT_MONO_WAV_INPUT                                    _HRESULT_TYPEDEF_(0xc00d1ba1)
#define NS_E_INPUT_WAVFORMAT_MISMATCH                                 _HRESULT_TYPEDEF_(0xc00d1ba2)
#define NS_E_RECORDQ_DISK_FULL                                        _HRESULT_TYPEDEF_(0xc00d1ba3)
#define NS_E_NO_PAL_INVERSE_TELECINE                                  _HRESULT_TYPEDEF_(0xc00d1ba4)
#define NS_E_ACTIVE_SG_DEVICE_DISCONNECTED                            _HRESULT_TYPEDEF_(0xc00d1ba5)
#define NS_E_ACTIVE_SG_DEVICE_CONTROL_DISCONNECTED                    _HRESULT_TYPEDEF_(0xc00d1ba6)
#define NS_E_NO_FRAMES_SUBMITTED_TO_ANALYZER                          _HRESULT_TYPEDEF_(0xc00d1ba7)
#define NS_E_INPUT_DOESNOT_SUPPORT_SMPTE                              _HRESULT_TYPEDEF_(0xc00d1ba8)
#define NS_E_NO_SMPTE_WITH_MULTIPLE_SOURCEGROUPS                      _HRESULT_TYPEDEF_(0xc00d1ba9)
#define NS_E_BAD_CONTENTEDL                                           _HRESULT_TYPEDEF_(0xc00d1baa)
#define NS_E_INTERLACEMODE_MISMATCH                                   _HRESULT_TYPEDEF_(0xc00d1bab)
#define NS_E_NONSQUAREPIXELMODE_MISMATCH                              _HRESULT_TYPEDEF_(0xc00d1bac)
#define NS_E_SMPTEMODE_MISMATCH                                       _HRESULT_TYPEDEF_(0xc00d1bad)
#define NS_E_END_OF_TAPE                                              _HRESULT_TYPEDEF_(0xc00d1bae)
#define NS_E_NO_MEDIA_IN_AUDIENCE                                     _HRESULT_TYPEDEF_(0xc00d1baf)
#define NS_E_NO_AUDIENCES                                             _HRESULT_TYPEDEF_(0xc00d1bb0)
#define NS_E_NO_AUDIO_COMPAT                                          _HRESULT_TYPEDEF_(0xc00d1bb1)
#define NS_E_INVALID_VBR_COMPAT                                       _HRESULT_TYPEDEF_(0xc00d1bb2)
#define NS_E_NO_PROFILE_NAME                                          _HRESULT_TYPEDEF_(0xc00d1bb3)
#define NS_E_INVALID_VBR_WITH_UNCOMP                                  _HRESULT_TYPEDEF_(0xc00d1bb4)
#define NS_E_MULTIPLE_VBR_AUDIENCES                                   _HRESULT_TYPEDEF_(0xc00d1bb5)
#define NS_E_UNCOMP_COMP_COMBINATION                                  _HRESULT_TYPEDEF_(0xc00d1bb6)
#define NS_E_MULTIPLE_AUDIO_CODECS                                    _HRESULT_TYPEDEF_(0xc00d1bb7)
#define NS_E_MULTIPLE_AUDIO_FORMATS                                   _HRESULT_TYPEDEF_(0xc00d1bb8)
#define NS_E_AUDIO_BITRATE_STEPDOWN                                   _HRESULT_TYPEDEF_(0xc00d1bb9)
#define NS_E_INVALID_AUDIO_PEAKRATE                                   _HRESULT_TYPEDEF_(0xc00d1bba)
#define NS_E_INVALID_AUDIO_PEAKRATE_2                                 _HRESULT_TYPEDEF_(0xc00d1bbb)
#define NS_E_INVALID_AUDIO_BUFFERMAX                                  _HRESULT_TYPEDEF_(0xc00d1bbc)
#define NS_E_MULTIPLE_VIDEO_CODECS                                    _HRESULT_TYPEDEF_(0xc00d1bbd)
#define NS_E_MULTIPLE_VIDEO_SIZES                                     _HRESULT_TYPEDEF_(0xc00d1bbe)
#define NS_E_INVALID_VIDEO_BITRATE                                    _HRESULT_TYPEDEF_(0xc00d1bbf)
#define NS_E_VIDEO_BITRATE_STEPDOWN                                   _HRESULT_TYPEDEF_(0xc00d1bc0)
#define NS_E_INVALID_VIDEO_PEAKRATE                                   _HRESULT_TYPEDEF_(0xc00d1bc1)
#define NS_E_INVALID_VIDEO_PEAKRATE_2                                 _HRESULT_TYPEDEF_(0xc00d1bc2)
#define NS_E_INVALID_VIDEO_WIDTH                                      _HRESULT_TYPEDEF_(0xc00d1bc3)
#define NS_E_INVALID_VIDEO_HEIGHT                                     _HRESULT_TYPEDEF_(0xc00d1bc4)
#define NS_E_INVALID_VIDEO_FPS                                        _HRESULT_TYPEDEF_(0xc00d1bc5)
#define NS_E_INVALID_VIDEO_KEYFRAME                                   _HRESULT_TYPEDEF_(0xc00d1bc6)
#define NS_E_INVALID_VIDEO_IQUALITY                                   _HRESULT_TYPEDEF_(0xc00d1bc7)
#define NS_E_INVALID_VIDEO_CQUALITY                                   _HRESULT_TYPEDEF_(0xc00d1bc8)
#define NS_E_INVALID_VIDEO_BUFFER                                     _HRESULT_TYPEDEF_(0xc00d1bc9)
#define NS_E_INVALID_VIDEO_BUFFERMAX                                  _HRESULT_TYPEDEF_(0xc00d1bca)
#define NS_E_INVALID_VIDEO_BUFFERMAX_2                                _HRESULT_TYPEDEF_(0xc00d1bcb)
#define NS_E_INVALID_VIDEO_WIDTH_ALIGN                                _HRESULT_TYPEDEF_(0xc00d1bcc)
#define NS_E_INVALID_VIDEO_HEIGHT_ALIGN                               _HRESULT_TYPEDEF_(0xc00d1bcd)
#define NS_E_MULTIPLE_SCRIPT_BITRATES                                 _HRESULT_TYPEDEF_(0xc00d1bce)
#define NS_E_INVALID_SCRIPT_BITRATE                                   _HRESULT_TYPEDEF_(0xc00d1bcf)
#define NS_E_MULTIPLE_FILE_BITRATES                                   _HRESULT_TYPEDEF_(0xc00d1bd0)
#define NS_E_INVALID_FILE_BITRATE                                     _HRESULT_TYPEDEF_(0xc00d1bd1)
#define NS_E_SAME_AS_INPUT_COMBINATION                                _HRESULT_TYPEDEF_(0xc00d1bd2)
#define NS_E_SOURCE_CANNOT_LOOP                                       _HRESULT_TYPEDEF_(0xc00d1bd3)
#define NS_E_INVALID_FOLDDOWN_COEFFICIENTS                            _HRESULT_TYPEDEF_(0xc00d1bd4)
#define NS_E_DRMPROFILE_NOTFOUND                                      _HRESULT_TYPEDEF_(0xc00d1bd5)
#define NS_E_INVALID_TIMECODE                                         _HRESULT_TYPEDEF_(0xc00d1bd6)
#define NS_E_NO_AUDIO_TIMECOMPRESSION                                 _HRESULT_TYPEDEF_(0xc00d1bd7)
#define NS_E_NO_TWOPASS_TIMECOMPRESSION                               _HRESULT_TYPEDEF_(0xc00d1bd8)
#define NS_E_TIMECODE_REQUIRES_VIDEOSTREAM                            _HRESULT_TYPEDEF_(0xc00d1bd9)
#define NS_E_NO_MBR_WITH_TIMECODE                                     _HRESULT_TYPEDEF_(0xc00d1bda)
#define NS_E_INVALID_INTERLACEMODE                                    _HRESULT_TYPEDEF_(0xc00d1bdb)
#define NS_E_INVALID_INTERLACE_COMPAT                                 _HRESULT_TYPEDEF_(0xc00d1bdc)
#define NS_E_INVALID_NONSQUAREPIXEL_COMPAT                            _HRESULT_TYPEDEF_(0xc00d1bdd)
#define NS_E_INVALID_SOURCE_WITH_DEVICE_CONTROL                       _HRESULT_TYPEDEF_(0xc00d1bde)
#define NS_E_CANNOT_GENERATE_BROADCAST_INFO_FOR_QUALITYVBR            _HRESULT_TYPEDEF_(0xc00d1bdf)
#define NS_E_EXCEED_MAX_DRM_PROFILE_LIMIT                             _HRESULT_TYPEDEF_(0xc00d1be0)
#define NS_E_DEVICECONTROL_UNSTABLE                                   _HRESULT_TYPEDEF_(0xc00d1be1)
#define NS_E_INVALID_PIXEL_ASPECT_RATIO                               _HRESULT_TYPEDEF_(0xc00d1be2)
#define NS_E_AUDIENCE__LANGUAGE_CONTENTTYPE_MISMATCH                  _HRESULT_TYPEDEF_(0xc00d1be3)
#define NS_E_INVALID_PROFILE_CONTENTTYPE                              _HRESULT_TYPEDEF_(0xc00d1be4)
#define NS_E_TRANSFORM_PLUGIN_NOT_FOUND                               _HRESULT_TYPEDEF_(0xc00d1be5)
#define NS_E_TRANSFORM_PLUGIN_INVALID                                 _HRESULT_TYPEDEF_(0xc00d1be6)
#define NS_E_EDL_REQUIRED_FOR_DEVICE_MULTIPASS                        _HRESULT_TYPEDEF_(0xc00d1be7)
#define NS_E_INVALID_VIDEO_WIDTH_FOR_INTERLACED_ENCODING              _HRESULT_TYPEDEF_(0xc00d1be8)
#define NS_E_MARKIN_UNSUPPORTED                                       _HRESULT_TYPEDEF_(0xc00d1be9)

/* DRM errors */
#define NS_E_DRM_INVALID_APPLICATION                                  _HRESULT_TYPEDEF_(0xc00d2711)
#define NS_E_DRM_LICENSE_STORE_ERROR                                  _HRESULT_TYPEDEF_(0xc00d2712)
#define NS_E_DRM_SECURE_STORE_ERROR                                   _HRESULT_TYPEDEF_(0xc00d2713)
#define NS_E_DRM_LICENSE_STORE_SAVE_ERROR                             _HRESULT_TYPEDEF_(0xc00d2714)
#define NS_E_DRM_SECURE_STORE_UNLOCK_ERROR                            _HRESULT_TYPEDEF_(0xc00d2715)
#define NS_E_DRM_INVALID_CONTENT                                      _HRESULT_TYPEDEF_(0xc00d2716)
#define NS_E_DRM_UNABLE_TO_OPEN_LICENSE                               _HRESULT_TYPEDEF_(0xc00d2717)
#define NS_E_DRM_INVALID_LICENSE                                      _HRESULT_TYPEDEF_(0xc00d2718)
#define NS_E_DRM_INVALID_MACHINE                                      _HRESULT_TYPEDEF_(0xc00d2719)
#define NS_E_DRM_ENUM_LICENSE_FAILED                                  _HRESULT_TYPEDEF_(0xc00d271b)
#define NS_E_DRM_INVALID_LICENSE_REQUEST                              _HRESULT_TYPEDEF_(0xc00d271c)
#define NS_E_DRM_UNABLE_TO_INITIALIZE                                 _HRESULT_TYPEDEF_(0xc00d271d)
#define NS_E_DRM_UNABLE_TO_ACQUIRE_LICENSE                            _HRESULT_TYPEDEF_(0xc00d271e)
#define NS_E_DRM_INVALID_LICENSE_ACQUIRED                             _HRESULT_TYPEDEF_(0xc00d271f)
#define NS_E_DRM_NO_RIGHTS                                            _HRESULT_TYPEDEF_(0xc00d2720)
#define NS_E_DRM_KEY_ERROR                                            _HRESULT_TYPEDEF_(0xc00d2721)
#define NS_E_DRM_ENCRYPT_ERROR                                        _HRESULT_TYPEDEF_(0xc00d2722)
#define NS_E_DRM_DECRYPT_ERROR                                        _HRESULT_TYPEDEF_(0xc00d2723)
#define NS_E_DRM_LICENSE_INVALID_XML                                  _HRESULT_TYPEDEF_(0xc00d2725)
#define NS_S_DRM_LICENSE_ACQUIRED                                     _HRESULT_TYPEDEF_(0x000d2726)
#define NS_S_DRM_INDIVIDUALIZED                                       _HRESULT_TYPEDEF_(0x000d2727)
#define NS_E_DRM_NEEDS_INDIVIDUALIZATION                              _HRESULT_TYPEDEF_(0xc00d2728)
#define NS_E_DRM_ALREADY_INDIVIDUALIZED                               _HRESULT_TYPEDEF_(0xc00d2729)
#define NS_E_DRM_ACTION_NOT_QUERIED                                   _HRESULT_TYPEDEF_(0xc00d272a)
#define NS_E_DRM_ACQUIRING_LICENSE                                    _HRESULT_TYPEDEF_(0xc00d272b)
#define NS_E_DRM_INDIVIDUALIZING                                      _HRESULT_TYPEDEF_(0xc00d272c)
#define NS_E_BACKUP_RESTORE_FAILURE                                   _HRESULT_TYPEDEF_(0xc00d272d)
#define NS_E_BACKUP_RESTORE_BAD_REQUEST_ID                            _HRESULT_TYPEDEF_(0xc00d272e)
#define NS_E_DRM_PARAMETERS_MISMATCHED                                _HRESULT_TYPEDEF_(0xc00d272f)
#define NS_E_DRM_UNABLE_TO_CREATE_LICENSE_OBJECT                      _HRESULT_TYPEDEF_(0xc00d2730)
#define NS_E_DRM_UNABLE_TO_CREATE_INDI_OBJECT                         _HRESULT_TYPEDEF_(0xc00d2731)
#define NS_E_DRM_UNABLE_TO_CREATE_ENCRYPT_OBJECT                      _HRESULT_TYPEDEF_(0xc00d2732)
#define NS_E_DRM_UNABLE_TO_CREATE_DECRYPT_OBJECT                      _HRESULT_TYPEDEF_(0xc00d2733)
#define NS_E_DRM_UNABLE_TO_CREATE_PROPERTIES_OBJECT                   _HRESULT_TYPEDEF_(0xc00d2734)
#define NS_E_DRM_UNABLE_TO_CREATE_BACKUP_OBJECT                       _HRESULT_TYPEDEF_(0xc00d2735)
#define NS_E_DRM_INDIVIDUALIZE_ERROR                                  _HRESULT_TYPEDEF_(0xc00d2736)
#define NS_E_DRM_LICENSE_OPEN_ERROR                                   _HRESULT_TYPEDEF_(0xc00d2737)
#define NS_E_DRM_LICENSE_CLOSE_ERROR                                  _HRESULT_TYPEDEF_(0xc00d2738)
#define NS_E_DRM_GET_LICENSE_ERROR                                    _HRESULT_TYPEDEF_(0xc00d2739)
#define NS_E_DRM_QUERY_ERROR                                          _HRESULT_TYPEDEF_(0xc00d273a)
#define NS_E_DRM_REPORT_ERROR                                         _HRESULT_TYPEDEF_(0xc00d273b)
#define NS_E_DRM_GET_LICENSESTRING_ERROR                              _HRESULT_TYPEDEF_(0xc00d273c)
#define NS_E_DRM_GET_CONTENTSTRING_ERROR                              _HRESULT_TYPEDEF_(0xc00d273d)
#define NS_E_DRM_MONITOR_ERROR                                        _HRESULT_TYPEDEF_(0xc00d273e)
#define NS_E_DRM_UNABLE_TO_SET_PARAMETER                              _HRESULT_TYPEDEF_(0xc00d273f)
#define NS_E_DRM_INVALID_APPDATA                                      _HRESULT_TYPEDEF_(0xc00d2740)
#define NS_E_DRM_INVALID_APPDATA_VERSION                              _HRESULT_TYPEDEF_(0xc00d2741)
#define NS_E_DRM_BACKUP_EXISTS                                        _HRESULT_TYPEDEF_(0xc00d2742)
#define NS_E_DRM_BACKUP_CORRUPT                                       _HRESULT_TYPEDEF_(0xc00d2743)
#define NS_E_DRM_BACKUPRESTORE_BUSY                                   _HRESULT_TYPEDEF_(0xc00d2744)
#define NS_E_BACKUP_RESTORE_BAD_DATA                                  _HRESULT_TYPEDEF_(0xc00d2745)
#define NS_S_DRM_MONITOR_CANCELLED                                    _HRESULT_TYPEDEF_(0x000d2746)
#define NS_S_DRM_ACQUIRE_CANCELLED                                    _HRESULT_TYPEDEF_(0x000d2747)
#define NS_E_DRM_LICENSE_UNUSABLE                                     _HRESULT_TYPEDEF_(0xc00d2748)
#define NS_E_DRM_INVALID_PROPERTY                                     _HRESULT_TYPEDEF_(0xc00d2749)
#define NS_E_DRM_SECURE_STORE_NOT_FOUND                               _HRESULT_TYPEDEF_(0xc00d274a)
#define NS_E_DRM_CACHED_CONTENT_ERROR                                 _HRESULT_TYPEDEF_(0xc00d274b)
#define NS_E_DRM_INDIVIDUALIZATION_INCOMPLETE                         _HRESULT_TYPEDEF_(0xc00d274c)
#define NS_E_DRM_DRIVER_AUTH_FAILURE                                  _HRESULT_TYPEDEF_(0xc00d274d)
#define NS_E_DRM_NEED_UPGRADE_MSSAP                                   _HRESULT_TYPEDEF_(0xc00d274e)
#define NS_E_DRM_REOPEN_CONTENT                                       _HRESULT_TYPEDEF_(0xc00d274f)
#define NS_E_DRM_DRIVER_DIGIOUT_FAILURE                               _HRESULT_TYPEDEF_(0xc00d2750)
#define NS_E_DRM_INVALID_SECURESTORE_PASSWORD                         _HRESULT_TYPEDEF_(0xc00d2751)
#define NS_E_DRM_APPCERT_REVOKED                                      _HRESULT_TYPEDEF_(0xc00d2752)
#define NS_E_DRM_RESTORE_FRAUD                                        _HRESULT_TYPEDEF_(0xc00d2753)
#define NS_E_DRM_HARDWARE_INCONSISTENT                                _HRESULT_TYPEDEF_(0xc00d2754)
#define NS_E_DRM_SDMI_TRIGGER                                         _HRESULT_TYPEDEF_(0xc00d2755)
#define NS_E_DRM_SDMI_NOMORECOPIES                                    _HRESULT_TYPEDEF_(0xc00d2756)
#define NS_E_DRM_UNABLE_TO_CREATE_HEADER_OBJECT                       _HRESULT_TYPEDEF_(0xc00d2757)
#define NS_E_DRM_UNABLE_TO_CREATE_KEYS_OBJECT                         _HRESULT_TYPEDEF_(0xc00d2758)
#define NS_E_DRM_LICENSE_NOTACQUIRED                                  _HRESULT_TYPEDEF_(0xc00d2759)
#define NS_E_DRM_UNABLE_TO_CREATE_CODING_OBJECT                       _HRESULT_TYPEDEF_(0xc00d275a)
#define NS_E_DRM_UNABLE_TO_CREATE_STATE_DATA_OBJECT                   _HRESULT_TYPEDEF_(0xc00d275b)
#define NS_E_DRM_BUFFER_TOO_SMALL                                     _HRESULT_TYPEDEF_(0xc00d275c)
#define NS_E_DRM_UNSUPPORTED_PROPERTY                                 _HRESULT_TYPEDEF_(0xc00d275d)
#define NS_E_DRM_ERROR_BAD_NET_RESP                                   _HRESULT_TYPEDEF_(0xc00d275e)
#define NS_E_DRM_STORE_NOTALLSTORED                                   _HRESULT_TYPEDEF_(0xc00d275f)
#define NS_E_DRM_SECURITY_COMPONENT_SIGNATURE_INVALID                 _HRESULT_TYPEDEF_(0xc00d2760)
#define NS_E_DRM_INVALID_DATA                                         _HRESULT_TYPEDEF_(0xc00d2761)
#define NS_E_DRM_POLICY_DISABLE_ONLINE                                _HRESULT_TYPEDEF_(0xc00d2762)
#define NS_E_DRM_UNABLE_TO_CREATE_AUTHENTICATION_OBJECT               _HRESULT_TYPEDEF_(0xc00d2763)
#define NS_E_DRM_NOT_CONFIGURED                                       _HRESULT_TYPEDEF_(0xc00d2764)
#define NS_E_DRM_DEVICE_ACTIVATION_CANCELED                           _HRESULT_TYPEDEF_(0xc00d2765)
#define NS_E_BACKUP_RESTORE_TOO_MANY_RESETS                           _HRESULT_TYPEDEF_(0xc00d2766)
#define NS_E_DRM_DEBUGGING_NOT_ALLOWED                                _HRESULT_TYPEDEF_(0xc00d2767)
#define NS_E_DRM_OPERATION_CANCELED                                   _HRESULT_TYPEDEF_(0xc00d2768)
#define NS_E_DRM_RESTRICTIONS_NOT_RETRIEVED                           _HRESULT_TYPEDEF_(0xc00d2769)
#define NS_E_DRM_UNABLE_TO_CREATE_PLAYLIST_OBJECT                     _HRESULT_TYPEDEF_(0xc00d276a)
#define NS_E_DRM_UNABLE_TO_CREATE_PLAYLIST_BURN_OBJECT                _HRESULT_TYPEDEF_(0xc00d276b)
#define NS_E_DRM_UNABLE_TO_CREATE_DEVICE_REGISTRATION_OBJECT          _HRESULT_TYPEDEF_(0xc00d276c)
#define NS_E_DRM_UNABLE_TO_CREATE_METERING_OBJECT                     _HRESULT_TYPEDEF_(0xc00d276d)
#define NS_S_DRM_BURNABLE_TRACK                                       _HRESULT_TYPEDEF_(0x000d276e)
#define NS_S_DRM_BURNABLE_TRACK_WITH_PLAYLIST_RESTRICTION             _HRESULT_TYPEDEF_(0x000d276f)
#define NS_E_DRM_TRACK_EXCEEDED_PLAYLIST_RESTICTION                   _HRESULT_TYPEDEF_(0xc00d2770)
#define NS_E_DRM_TRACK_EXCEEDED_TRACKBURN_RESTRICTION                 _HRESULT_TYPEDEF_(0xc00d2771)
#define NS_E_DRM_UNABLE_TO_GET_DEVICE_CERT                            _HRESULT_TYPEDEF_(0xc00d2772)
#define NS_E_DRM_UNABLE_TO_GET_SECURE_CLOCK                           _HRESULT_TYPEDEF_(0xc00d2773)
#define NS_E_DRM_UNABLE_TO_SET_SECURE_CLOCK                           _HRESULT_TYPEDEF_(0xc00d2774)
#define NS_E_DRM_UNABLE_TO_GET_SECURE_CLOCK_FROM_SERVER               _HRESULT_TYPEDEF_(0xc00d2775)
#define NS_E_DRM_POLICY_METERING_DISABLED                             _HRESULT_TYPEDEF_(0xc00d2776)
#define NS_E_DRM_TRANSFER_CHAINED_LICENSES_UNSUPPORTED                _HRESULT_TYPEDEF_(0xc00d2777)
#define NS_E_DRM_SDK_VERSIONMISMATCH                                  _HRESULT_TYPEDEF_(0xc00d2778)
#define NS_E_DRM_LIC_NEEDS_DEVICE_CLOCK_SET                           _HRESULT_TYPEDEF_(0xc00d2779)
#define NS_E_LICENSE_HEADER_MISSING_URL                               _HRESULT_TYPEDEF_(0xc00d277a)
#define NS_E_DEVICE_NOT_WMDRM_DEVICE                                  _HRESULT_TYPEDEF_(0xc00d277b)
#define NS_E_DRM_INVALID_APPCERT                                      _HRESULT_TYPEDEF_(0xc00d277c)
#define NS_E_DRM_PROTOCOL_FORCEFUL_TERMINATION_ON_PETITION            _HRESULT_TYPEDEF_(0xc00d277d)
#define NS_E_DRM_PROTOCOL_FORCEFUL_TERMINATION_ON_CHALLENGE           _HRESULT_TYPEDEF_(0xc00d277e)
#define NS_E_DRM_CHECKPOINT_FAILED                                    _HRESULT_TYPEDEF_(0xc00d277f)
#define NS_E_DRM_BB_UNABLE_TO_INITIALIZE                              _HRESULT_TYPEDEF_(0xc00d2780)
#define NS_E_DRM_UNABLE_TO_LOAD_HARDWARE_ID                           _HRESULT_TYPEDEF_(0xc00d2781)
#define NS_E_DRM_UNABLE_TO_OPEN_DATA_STORE                            _HRESULT_TYPEDEF_(0xc00d2782)
#define NS_E_DRM_DATASTORE_CORRUPT                                    _HRESULT_TYPEDEF_(0xc00d2783)
#define NS_E_DRM_UNABLE_TO_CREATE_INMEMORYSTORE_OBJECT                _HRESULT_TYPEDEF_(0xc00d2784)
#define NS_E_DRM_STUBLIB_REQUIRED                                     _HRESULT_TYPEDEF_(0xc00d2785)
#define NS_E_DRM_UNABLE_TO_CREATE_CERTIFICATE_OBJECT                  _HRESULT_TYPEDEF_(0xc00d2786)
#define NS_E_DRM_MIGRATION_TARGET_NOT_ONLINE                          _HRESULT_TYPEDEF_(0xc00d2787)
#define NS_E_DRM_INVALID_MIGRATION_IMAGE                              _HRESULT_TYPEDEF_(0xc00d2788)
#define NS_E_DRM_MIGRATION_TARGET_STATES_CORRUPTED                    _HRESULT_TYPEDEF_(0xc00d2789)
#define NS_E_DRM_MIGRATION_IMPORTER_NOT_AVAILABLE                     _HRESULT_TYPEDEF_(0xc00d278a)
#define NS_DRM_E_MIGRATION_UPGRADE_WITH_DIFF_SID                      _HRESULT_TYPEDEF_(0xc00d278b)
#define NS_DRM_E_MIGRATION_SOURCE_MACHINE_IN_USE                      _HRESULT_TYPEDEF_(0xc00d278c)
#define NS_DRM_E_MIGRATION_TARGET_MACHINE_LESS_THAN_LH                _HRESULT_TYPEDEF_(0xc00d278d)
#define NS_DRM_E_MIGRATION_IMAGE_ALREADY_EXISTS                       _HRESULT_TYPEDEF_(0xc00d278e)
#define NS_E_DRM_HARDWAREID_MISMATCH                                  _HRESULT_TYPEDEF_(0xc00d278f)
#define NS_E_INVALID_DRMV2CLT_STUBLIB                                 _HRESULT_TYPEDEF_(0xc00d2790)
#define NS_E_DRM_MIGRATION_INVALID_LEGACYV2_DATA                      _HRESULT_TYPEDEF_(0xc00d2791)
#define NS_E_DRM_MIGRATION_LICENSE_ALREADY_EXISTS                     _HRESULT_TYPEDEF_(0xc00d2792)
#define NS_E_DRM_MIGRATION_INVALID_LEGACYV2_SST_PASSWORD              _HRESULT_TYPEDEF_(0xc00d2793)
#define NS_E_DRM_MIGRATION_NOT_SUPPORTED                              _HRESULT_TYPEDEF_(0xc00d2794)
#define NS_E_DRM_UNABLE_TO_CREATE_MIGRATION_IMPORTER_OBJECT           _HRESULT_TYPEDEF_(0xc00d2795)
#define NS_E_DRM_CHECKPOINT_MISMATCH                                  _HRESULT_TYPEDEF_(0xc00d2796)
#define NS_E_DRM_CHECKPOINT_CORRUPT                                   _HRESULT_TYPEDEF_(0xc00d2797)
#define NS_E_REG_FLUSH_FAILURE                                        _HRESULT_TYPEDEF_(0xc00d2798)
#define NS_E_HDS_KEY_MISMATCH                                         _HRESULT_TYPEDEF_(0xc00d2799)
#define NS_E_DRM_MIGRATION_OPERATION_CANCELLED                        _HRESULT_TYPEDEF_(0xc00d279a)
#define NS_E_DRM_MIGRATION_OBJECT_IN_USE                              _HRESULT_TYPEDEF_(0xc00d279b)
#define NS_E_DRM_MALFORMED_CONTENT_HEADER                             _HRESULT_TYPEDEF_(0xc00d279c)
#define NS_E_DRM_LICENSE_EXPIRED                                      _HRESULT_TYPEDEF_(0xc00d27d8)
#define NS_E_DRM_LICENSE_NOTENABLED                                   _HRESULT_TYPEDEF_(0xc00d27d9)
#define NS_E_DRM_LICENSE_APPSECLOW                                    _HRESULT_TYPEDEF_(0xc00d27da)
#define NS_E_DRM_STORE_NEEDINDI                                       _HRESULT_TYPEDEF_(0xc00d27db)
#define NS_E_DRM_STORE_NOTALLOWED                                     _HRESULT_TYPEDEF_(0xc00d27dc)
#define NS_E_DRM_LICENSE_APP_NOTALLOWED                               _HRESULT_TYPEDEF_(0xc00d27dd)
#define NS_S_DRM_NEEDS_INDIVIDUALIZATION                              _HRESULT_TYPEDEF_(0x000d27de)
#define NS_E_DRM_LICENSE_CERT_EXPIRED                                 _HRESULT_TYPEDEF_(0xc00d27df)
#define NS_E_DRM_LICENSE_SECLOW                                       _HRESULT_TYPEDEF_(0xc00d27e0)
#define NS_E_DRM_LICENSE_CONTENT_REVOKED                              _HRESULT_TYPEDEF_(0xc00d27e1)
#define NS_E_DRM_DEVICE_NOT_REGISTERED                                _HRESULT_TYPEDEF_(0xc00d27e2)
#define NS_E_DRM_LICENSE_NOSAP                                        _HRESULT_TYPEDEF_(0xc00d280a)
#define NS_E_DRM_LICENSE_NOSVP                                        _HRESULT_TYPEDEF_(0xc00d280b)
#define NS_E_DRM_LICENSE_NOWDM                                        _HRESULT_TYPEDEF_(0xc00d280c)
#define NS_E_DRM_LICENSE_NOTRUSTEDCODEC                               _HRESULT_TYPEDEF_(0xc00d280d)
#define NS_E_DRM_SOURCEID_NOT_SUPPORTED                               _HRESULT_TYPEDEF_(0xc00d280e)
#define NS_E_DRM_NEEDS_UPGRADE_TEMPFILE                               _HRESULT_TYPEDEF_(0xc00d283d)
#define NS_E_DRM_NEED_UPGRADE_PD                                      _HRESULT_TYPEDEF_(0xc00d283e)
#define NS_E_DRM_SIGNATURE_FAILURE                                    _HRESULT_TYPEDEF_(0xc00d283f)
#define NS_E_DRM_LICENSE_SERVER_INFO_MISSING                          _HRESULT_TYPEDEF_(0xc00d2840)
#define NS_E_DRM_BUSY                                                 _HRESULT_TYPEDEF_(0xc00d2841)
#define NS_E_DRM_PD_TOO_MANY_DEVICES                                  _HRESULT_TYPEDEF_(0xc00d2842)
#define NS_E_DRM_INDIV_FRAUD                                          _HRESULT_TYPEDEF_(0xc00d2843)
#define NS_E_DRM_INDIV_NO_CABS                                        _HRESULT_TYPEDEF_(0xc00d2844)
#define NS_E_DRM_INDIV_SERVICE_UNAVAILABLE                            _HRESULT_TYPEDEF_(0xc00d2845)
#define NS_E_DRM_RESTORE_SERVICE_UNAVAILABLE                          _HRESULT_TYPEDEF_(0xc00d2846)
#define NS_E_DRM_CLIENT_CODE_EXPIRED                                  _HRESULT_TYPEDEF_(0xc00d2847)
#define NS_E_DRM_NO_UPLINK_LICENSE                                    _HRESULT_TYPEDEF_(0xc00d2848)
#define NS_E_DRM_INVALID_KID                                          _HRESULT_TYPEDEF_(0xc00d2849)
#define NS_E_DRM_LICENSE_INITIALIZATION_ERROR                         _HRESULT_TYPEDEF_(0xc00d284a)
#define NS_E_DRM_CHAIN_TOO_LONG                                       _HRESULT_TYPEDEF_(0xc00d284c)
#define NS_E_DRM_UNSUPPORTED_ALGORITHM                                _HRESULT_TYPEDEF_(0xc00d284d)
#define NS_E_DRM_LICENSE_DELETION_ERROR                               _HRESULT_TYPEDEF_(0xc00d284e)
#define NS_E_DRM_INVALID_CERTIFICATE                                  _HRESULT_TYPEDEF_(0xc00d28a0)
#define NS_E_DRM_CERTIFICATE_REVOKED                                  _HRESULT_TYPEDEF_(0xc00d28a1)
#define NS_E_DRM_LICENSE_UNAVAILABLE                                  _HRESULT_TYPEDEF_(0xc00d28a2)
#define NS_E_DRM_DEVICE_LIMIT_REACHED                                 _HRESULT_TYPEDEF_(0xc00d28a3)
#define NS_E_DRM_UNABLE_TO_VERIFY_PROXIMITY                           _HRESULT_TYPEDEF_(0xc00d28a4)
#define NS_E_DRM_MUST_REGISTER                                        _HRESULT_TYPEDEF_(0xc00d28a5)
#define NS_E_DRM_MUST_APPROVE                                         _HRESULT_TYPEDEF_(0xc00d28a6)
#define NS_E_DRM_MUST_REVALIDATE                                      _HRESULT_TYPEDEF_(0xc00d28a7)
#define NS_E_DRM_INVALID_PROXIMITY_RESPONSE                           _HRESULT_TYPEDEF_(0xc00d28a8)
#define NS_E_DRM_INVALID_SESSION                                      _HRESULT_TYPEDEF_(0xc00d28a9)
#define NS_E_DRM_DEVICE_NOT_OPEN                                      _HRESULT_TYPEDEF_(0xc00d28aa)
#define NS_E_DRM_DEVICE_ALREADY_REGISTERED                            _HRESULT_TYPEDEF_(0xc00d28ab)
#define NS_E_DRM_UNSUPPORTED_PROTOCOL_VERSION                         _HRESULT_TYPEDEF_(0xc00d28ac)
#define NS_E_DRM_UNSUPPORTED_ACTION                                   _HRESULT_TYPEDEF_(0xc00d28ad)
#define NS_E_DRM_CERTIFICATE_SECURITY_LEVEL_INADEQUATE                _HRESULT_TYPEDEF_(0xc00d28ae)
#define NS_E_DRM_UNABLE_TO_OPEN_PORT                                  _HRESULT_TYPEDEF_(0xc00d28af)
#define NS_E_DRM_BAD_REQUEST                                          _HRESULT_TYPEDEF_(0xc00d28b0)
#define NS_E_DRM_INVALID_CRL                                          _HRESULT_TYPEDEF_(0xc00d28b1)
#define NS_E_DRM_ATTRIBUTE_TOO_LONG                                   _HRESULT_TYPEDEF_(0xc00d28b2)
#define NS_E_DRM_EXPIRED_LICENSEBLOB                                  _HRESULT_TYPEDEF_(0xc00d28b3)
#define NS_E_DRM_INVALID_LICENSEBLOB                                  _HRESULT_TYPEDEF_(0xc00d28b4)
#define NS_E_DRM_INCLUSION_LIST_REQUIRED                              _HRESULT_TYPEDEF_(0xc00d28b5)
#define NS_E_DRM_DRMV2CLT_REVOKED                                     _HRESULT_TYPEDEF_(0xc00d28b6)
#define NS_E_DRM_RIV_TOO_SMALL                                        _HRESULT_TYPEDEF_(0xc00d28b7)
#define NS_E_OUTPUT_PROTECTION_LEVEL_UNSUPPORTED                      _HRESULT_TYPEDEF_(0xc00d2904)
#define NS_E_COMPRESSED_DIGITAL_VIDEO_PROTECTION_LEVEL_UNSUPPORTED    _HRESULT_TYPEDEF_(0xc00d2905)
#define NS_E_UNCOMPRESSED_DIGITAL_VIDEO_PROTECTION_LEVEL_UNSUPPORTED  _HRESULT_TYPEDEF_(0xc00d2906)
#define NS_E_ANALOG_VIDEO_PROTECTION_LEVEL_UNSUPPORTED                _HRESULT_TYPEDEF_(0xc00d2907)
#define NS_E_COMPRESSED_DIGITAL_AUDIO_PROTECTION_LEVEL_UNSUPPORTED    _HRESULT_TYPEDEF_(0xc00d2908)
#define NS_E_UNCOMPRESSED_DIGITAL_AUDIO_PROTECTION_LEVEL_UNSUPPORTED  _HRESULT_TYPEDEF_(0xc00d2909)
#define NS_E_OUTPUT_PROTECTION_SCHEME_UNSUPPORTED                     _HRESULT_TYPEDEF_(0xc00d290a)

/* Setup errors */
#define NS_S_REBOOT_RECOMMENDED                                       _HRESULT_TYPEDEF_(0x000d2af8)
#define NS_S_REBOOT_REQUIRED                                          _HRESULT_TYPEDEF_(0x000d2af9)
#define NS_E_REBOOT_RECOMMENDED                                       _HRESULT_TYPEDEF_(0xc00d2afa)
#define NS_E_REBOOT_REQUIRED                                          _HRESULT_TYPEDEF_(0xc00d2afb)
#define NS_E_SETUP_INCOMPLETE                                         _HRESULT_TYPEDEF_(0xc00d2afc)
#define NS_E_SETUP_DRM_MIGRATION_FAILED                               _HRESULT_TYPEDEF_(0xc00d2afd)
#define NS_E_SETUP_IGNORABLE_FAILURE                                  _HRESULT_TYPEDEF_(0xc00d2afe)
#define NS_E_SETUP_DRM_MIGRATION_FAILED_AND_IGNORABLE_FAILURE         _HRESULT_TYPEDEF_(0xc00d2aff)
#define NS_E_SETUP_BLOCKED                                            _HRESULT_TYPEDEF_(0xc00d2b00)

/* Networking errors */
#define NS_E_UNKNOWN_PROTOCOL                                         _HRESULT_TYPEDEF_(0xc00d2ee0)
#define NS_E_REDIRECT_TO_PROXY                                        _HRESULT_TYPEDEF_(0xc00d2ee1)
#define NS_E_INTERNAL_SERVER_ERROR                                    _HRESULT_TYPEDEF_(0xc00d2ee2)
#define NS_E_BAD_REQUEST                                              _HRESULT_TYPEDEF_(0xc00d2ee3)
#define NS_E_ERROR_FROM_PROXY                                         _HRESULT_TYPEDEF_(0xc00d2ee4)
#define NS_E_PROXY_TIMEOUT                                            _HRESULT_TYPEDEF_(0xc00d2ee5)
#define NS_E_SERVER_UNAVAILABLE                                       _HRESULT_TYPEDEF_(0xc00d2ee6)
#define NS_E_REFUSED_BY_SERVER                                        _HRESULT_TYPEDEF_(0xc00d2ee7)
#define NS_E_INCOMPATIBLE_SERVER                                      _HRESULT_TYPEDEF_(0xc00d2ee8)
#define NS_E_MULTICAST_DISABLED                                       _HRESULT_TYPEDEF_(0xc00d2ee9)
#define NS_E_INVALID_REDIRECT                                         _HRESULT_TYPEDEF_(0xc00d2eea)
#define NS_E_ALL_PROTOCOLS_DISABLED                                   _HRESULT_TYPEDEF_(0xc00d2eeb)
#define NS_E_MSBD_NO_LONGER_SUPPORTED                                 _HRESULT_TYPEDEF_(0xc00d2eec)
#define NS_E_PROXY_NOT_FOUND                                          _HRESULT_TYPEDEF_(0xc00d2eed)
#define NS_E_CANNOT_CONNECT_TO_PROXY                                  _HRESULT_TYPEDEF_(0xc00d2eee)
#define NS_E_SERVER_DNS_TIMEOUT                                       _HRESULT_TYPEDEF_(0xc00d2eef)
#define NS_E_PROXY_DNS_TIMEOUT                                        _HRESULT_TYPEDEF_(0xc00d2ef0)
#define NS_E_CLOSED_ON_SUSPEND                                        _HRESULT_TYPEDEF_(0xc00d2ef1)
#define NS_E_CANNOT_READ_PLAYLIST_FROM_MEDIASERVER                    _HRESULT_TYPEDEF_(0xc00d2ef2)
#define NS_E_SESSION_NOT_FOUND                                        _HRESULT_TYPEDEF_(0xc00d2ef3)
#define NS_E_REQUIRE_STREAMING_CLIENT                                 _HRESULT_TYPEDEF_(0xc00d2ef4)
#define NS_E_PLAYLIST_ENTRY_HAS_CHANGED                               _HRESULT_TYPEDEF_(0xc00d2ef5)
#define NS_E_PROXY_ACCESSDENIED                                       _HRESULT_TYPEDEF_(0xc00d2ef6)
#define NS_E_PROXY_SOURCE_ACCESSDENIED                                _HRESULT_TYPEDEF_(0xc00d2ef7)
#define NS_E_NETWORK_SINK_WRITE                                       _HRESULT_TYPEDEF_(0xc00d2ef8)
#define NS_E_FIREWALL                                                 _HRESULT_TYPEDEF_(0xc00d2ef9)
#define NS_E_MMS_NOT_SUPPORTED                                        _HRESULT_TYPEDEF_(0xc00d2efa)
#define NS_E_SERVER_ACCESSDENIED                                      _HRESULT_TYPEDEF_(0xc00d2efb)
#define NS_E_RESOURCE_GONE                                            _HRESULT_TYPEDEF_(0xc00d2efc)
#define NS_E_NO_EXISTING_PACKETIZER                                   _HRESULT_TYPEDEF_(0xc00d2efd)
#define NS_E_BAD_SYNTAX_IN_SERVER_RESPONSE                            _HRESULT_TYPEDEF_(0xc00d2efe)
#define NS_I_RECONNECTED                                              _HRESULT_TYPEDEF_(0x400d2eff)
#define NS_E_RESET_SOCKET_CONNECTION                                  _HRESULT_TYPEDEF_(0xc00d2f00)
#define NS_I_NOLOG_STOP                                               _HRESULT_TYPEDEF_(0x400d2f01)
#define NS_E_TOO_MANY_HOPS                                            _HRESULT_TYPEDEF_(0xc00d2f02)
#define NS_I_EXISTING_PACKETIZER                                      _HRESULT_TYPEDEF_(0x400d2f03)
#define NS_I_MANUAL_PROXY                                             _HRESULT_TYPEDEF_(0x400d2f04)
#define NS_E_TOO_MUCH_DATA_FROM_SERVER                                _HRESULT_TYPEDEF_(0xc00d2f05)
#define NS_E_CONNECT_TIMEOUT                                          _HRESULT_TYPEDEF_(0xc00d2f06)
#define NS_E_PROXY_CONNECT_TIMEOUT                                    _HRESULT_TYPEDEF_(0xc00d2f07)
#define NS_E_SESSION_INVALID                                          _HRESULT_TYPEDEF_(0xc00d2f08)
#define NS_S_EOSRECEDING                                              _HRESULT_TYPEDEF_(0x000d2f09)
#define NS_E_PACKETSINK_UNKNOWN_FEC_STREAM                            _HRESULT_TYPEDEF_(0xc00d2f0a)
#define NS_E_PUSH_CANNOTCONNECT                                       _HRESULT_TYPEDEF_(0xc00d2f0b)
#define NS_E_INCOMPATIBLE_PUSH_SERVER                                 _HRESULT_TYPEDEF_(0xc00d2f0c)
#define NS_S_CHANGENOTICE                                             _HRESULT_TYPEDEF_(0x000d2f0d)

/* Client media service errors */
#define NS_E_END_OF_PLAYLIST                                          _HRESULT_TYPEDEF_(0xc00d32c8)
#define NS_E_USE_FILE_SOURCE                                          _HRESULT_TYPEDEF_(0xc00d32c9)
#define NS_E_PROPERTY_NOT_FOUND                                       _HRESULT_TYPEDEF_(0xc00d32ca)
#define NS_E_PROPERTY_READ_ONLY                                       _HRESULT_TYPEDEF_(0xc00d32cc)
#define NS_E_TABLE_KEY_NOT_FOUND                                      _HRESULT_TYPEDEF_(0xc00d32cd)
#define NS_E_INVALID_QUERY_OPERATOR                                   _HRESULT_TYPEDEF_(0xc00d32cf)
#define NS_E_INVALID_QUERY_PROPERTY                                   _HRESULT_TYPEDEF_(0xc00d32d0)
#define NS_E_PROPERTY_NOT_SUPPORTED                                   _HRESULT_TYPEDEF_(0xc00d32d2)
#define NS_E_SCHEMA_CLASSIFY_FAILURE                                  _HRESULT_TYPEDEF_(0xc00d32d4)
#define NS_E_METADATA_FORMAT_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0xc00d32d5)
#define NS_E_METADATA_NO_EDITING_CAPABILITY                           _HRESULT_TYPEDEF_(0xc00d32d6)
#define NS_E_METADATA_CANNOT_SET_LOCALE                               _HRESULT_TYPEDEF_(0xc00d32d7)
#define NS_E_METADATA_LANGUAGE_NOT_SUPORTED                           _HRESULT_TYPEDEF_(0xc00d32d8)
#define NS_E_METADATA_NO_RFC1766_NAME_FOR_LOCALE                      _HRESULT_TYPEDEF_(0xc00d32d9)
#define NS_E_METADATA_NOT_AVAILABLE                                   _HRESULT_TYPEDEF_(0xc00d32da)
#define NS_E_METADATA_CACHE_DATA_NOT_AVAILABLE                        _HRESULT_TYPEDEF_(0xc00d32db)
#define NS_E_METADATA_INVALID_DOCUMENT_TYPE                           _HRESULT_TYPEDEF_(0xc00d32dc)
#define NS_E_METADATA_IDENTIFIER_NOT_AVAILABLE                        _HRESULT_TYPEDEF_(0xc00d32dd)
#define NS_E_METADATA_CANNOT_RETRIEVE_FROM_OFFLINE_CACHE              _HRESULT_TYPEDEF_(0xc00d32de)

#endif /* _NSERROR_H */
