/* packet-netlink-nl80211.c
 * Dissector for nl80211 (over Netlink).
 *
 * Copyright (c) 2017, Peter Wu <peter@lekensteyn.nl>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#define NEW_PROTO_TREE_API

#include "config.h"

#include <epan/packet.h>
#include "packet-netlink.h"

void proto_register_netlink_nl80211(void);
void proto_reg_handoff_netlink_nl80211(void);

/* Extracted using tools/make-nl80211-fields.py */
/* Definitions from linux/nl80211.h {{{ */
enum ws_nl80211_commands {
    WS_NL80211_CMD_UNSPEC,
    WS_NL80211_CMD_GET_WIPHY,
    WS_NL80211_CMD_SET_WIPHY,
    WS_NL80211_CMD_NEW_WIPHY,
    WS_NL80211_CMD_DEL_WIPHY,
    WS_NL80211_CMD_GET_INTERFACE,
    WS_NL80211_CMD_SET_INTERFACE,
    WS_NL80211_CMD_NEW_INTERFACE,
    WS_NL80211_CMD_DEL_INTERFACE,
    WS_NL80211_CMD_GET_KEY,
    WS_NL80211_CMD_SET_KEY,
    WS_NL80211_CMD_NEW_KEY,
    WS_NL80211_CMD_DEL_KEY,
    WS_NL80211_CMD_GET_BEACON,
    WS_NL80211_CMD_SET_BEACON,
    WS_NL80211_CMD_START_AP,
    WS_NL80211_CMD_STOP_AP,
    WS_NL80211_CMD_GET_STATION,
    WS_NL80211_CMD_SET_STATION,
    WS_NL80211_CMD_NEW_STATION,
    WS_NL80211_CMD_DEL_STATION,
    WS_NL80211_CMD_GET_MPATH,
    WS_NL80211_CMD_SET_MPATH,
    WS_NL80211_CMD_NEW_MPATH,
    WS_NL80211_CMD_DEL_MPATH,
    WS_NL80211_CMD_SET_BSS,
    WS_NL80211_CMD_SET_REG,
    WS_NL80211_CMD_REQ_SET_REG,
    WS_NL80211_CMD_GET_MESH_CONFIG,
    WS_NL80211_CMD_SET_MESH_CONFIG,
    WS_NL80211_CMD_SET_MGMT_EXTRA_IE,
    WS_NL80211_CMD_GET_REG,
    WS_NL80211_CMD_GET_SCAN,
    WS_NL80211_CMD_TRIGGER_SCAN,
    WS_NL80211_CMD_NEW_SCAN_RESULTS,
    WS_NL80211_CMD_SCAN_ABORTED,
    WS_NL80211_CMD_REG_CHANGE,
    WS_NL80211_CMD_AUTHENTICATE,
    WS_NL80211_CMD_ASSOCIATE,
    WS_NL80211_CMD_DEAUTHENTICATE,
    WS_NL80211_CMD_DISASSOCIATE,
    WS_NL80211_CMD_MICHAEL_MIC_FAILURE,
    WS_NL80211_CMD_REG_BEACON_HINT,
    WS_NL80211_CMD_JOIN_IBSS,
    WS_NL80211_CMD_LEAVE_IBSS,
    WS_NL80211_CMD_TESTMODE,
    WS_NL80211_CMD_CONNECT,
    WS_NL80211_CMD_ROAM,
    WS_NL80211_CMD_DISCONNECT,
    WS_NL80211_CMD_SET_WIPHY_NETNS,
    WS_NL80211_CMD_GET_SURVEY,
    WS_NL80211_CMD_NEW_SURVEY_RESULTS,
    WS_NL80211_CMD_SET_PMKSA,
    WS_NL80211_CMD_DEL_PMKSA,
    WS_NL80211_CMD_FLUSH_PMKSA,
    WS_NL80211_CMD_REMAIN_ON_CHANNEL,
    WS_NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL,
    WS_NL80211_CMD_SET_TX_BITRATE_MASK,
    WS_NL80211_CMD_REGISTER_FRAME,
    WS_NL80211_CMD_FRAME,
    WS_NL80211_CMD_FRAME_TX_STATUS,
    WS_NL80211_CMD_SET_POWER_SAVE,
    WS_NL80211_CMD_GET_POWER_SAVE,
    WS_NL80211_CMD_SET_CQM,
    WS_NL80211_CMD_NOTIFY_CQM,
    WS_NL80211_CMD_SET_CHANNEL,
    WS_NL80211_CMD_SET_WDS_PEER,
    WS_NL80211_CMD_FRAME_WAIT_CANCEL,
    WS_NL80211_CMD_JOIN_MESH,
    WS_NL80211_CMD_LEAVE_MESH,
    WS_NL80211_CMD_UNPROT_DEAUTHENTICATE,
    WS_NL80211_CMD_UNPROT_DISASSOCIATE,
    WS_NL80211_CMD_NEW_PEER_CANDIDATE,
    WS_NL80211_CMD_GET_WOWLAN,
    WS_NL80211_CMD_SET_WOWLAN,
    WS_NL80211_CMD_START_SCHED_SCAN,
    WS_NL80211_CMD_STOP_SCHED_SCAN,
    WS_NL80211_CMD_SCHED_SCAN_RESULTS,
    WS_NL80211_CMD_SCHED_SCAN_STOPPED,
    WS_NL80211_CMD_SET_REKEY_OFFLOAD,
    WS_NL80211_CMD_PMKSA_CANDIDATE,
    WS_NL80211_CMD_TDLS_OPER,
    WS_NL80211_CMD_TDLS_MGMT,
    WS_NL80211_CMD_UNEXPECTED_FRAME,
    WS_NL80211_CMD_PROBE_CLIENT,
    WS_NL80211_CMD_REGISTER_BEACONS,
    WS_NL80211_CMD_UNEXPECTED_4ADDR_FRAME,
    WS_NL80211_CMD_SET_NOACK_MAP,
    WS_NL80211_CMD_CH_SWITCH_NOTIFY,
    WS_NL80211_CMD_START_P2P_DEVICE,
    WS_NL80211_CMD_STOP_P2P_DEVICE,
    WS_NL80211_CMD_CONN_FAILED,
    WS_NL80211_CMD_SET_MCAST_RATE,
    WS_NL80211_CMD_SET_MAC_ACL,
    WS_NL80211_CMD_RADAR_DETECT,
    WS_NL80211_CMD_GET_PROTOCOL_FEATURES,
    WS_NL80211_CMD_UPDATE_FT_IES,
    WS_NL80211_CMD_FT_EVENT,
    WS_NL80211_CMD_CRIT_PROTOCOL_START,
    WS_NL80211_CMD_CRIT_PROTOCOL_STOP,
    WS_NL80211_CMD_GET_COALESCE,
    WS_NL80211_CMD_SET_COALESCE,
    WS_NL80211_CMD_CHANNEL_SWITCH,
    WS_NL80211_CMD_VENDOR,
    WS_NL80211_CMD_SET_QOS_MAP,
    WS_NL80211_CMD_ADD_TX_TS,
    WS_NL80211_CMD_DEL_TX_TS,
    WS_NL80211_CMD_GET_MPP,
    WS_NL80211_CMD_JOIN_OCB,
    WS_NL80211_CMD_LEAVE_OCB,
    WS_NL80211_CMD_CH_SWITCH_STARTED_NOTIFY,
    WS_NL80211_CMD_TDLS_CHANNEL_SWITCH,
    WS_NL80211_CMD_TDLS_CANCEL_CHANNEL_SWITCH,
    WS_NL80211_CMD_WIPHY_REG_CHANGE,
    WS_NL80211_CMD_ABORT_SCAN,
    WS_NL80211_CMD_START_NAN,
    WS_NL80211_CMD_STOP_NAN,
    WS_NL80211_CMD_ADD_NAN_FUNCTION,
    WS_NL80211_CMD_DEL_NAN_FUNCTION,
    WS_NL80211_CMD_CHANGE_NAN_CONFIG,
    WS_NL80211_CMD_NAN_MATCH,
    WS_NL80211_CMD_SET_MULTICAST_TO_UNICAST,
    WS_NL80211_CMD_UPDATE_CONNECT_PARAMS,
};

enum ws_nl80211_attrs {
    WS_NL80211_ATTR_UNSPEC,
    WS_NL80211_ATTR_WIPHY,
    WS_NL80211_ATTR_WIPHY_NAME,
    WS_NL80211_ATTR_IFINDEX,
    WS_NL80211_ATTR_IFNAME,
    WS_NL80211_ATTR_IFTYPE,
    WS_NL80211_ATTR_MAC,
    WS_NL80211_ATTR_KEY_DATA,
    WS_NL80211_ATTR_KEY_IDX,
    WS_NL80211_ATTR_KEY_CIPHER,
    WS_NL80211_ATTR_KEY_SEQ,
    WS_NL80211_ATTR_KEY_DEFAULT,
    WS_NL80211_ATTR_BEACON_INTERVAL,
    WS_NL80211_ATTR_DTIM_PERIOD,
    WS_NL80211_ATTR_BEACON_HEAD,
    WS_NL80211_ATTR_BEACON_TAIL,
    WS_NL80211_ATTR_STA_AID,
    WS_NL80211_ATTR_STA_FLAGS,
    WS_NL80211_ATTR_STA_LISTEN_INTERVAL,
    WS_NL80211_ATTR_STA_SUPPORTED_RATES,
    WS_NL80211_ATTR_STA_VLAN,
    WS_NL80211_ATTR_STA_INFO,
    WS_NL80211_ATTR_WIPHY_BANDS,
    WS_NL80211_ATTR_MNTR_FLAGS,
    WS_NL80211_ATTR_MESH_ID,
    WS_NL80211_ATTR_STA_PLINK_ACTION,
    WS_NL80211_ATTR_MPATH_NEXT_HOP,
    WS_NL80211_ATTR_MPATH_INFO,
    WS_NL80211_ATTR_BSS_CTS_PROT,
    WS_NL80211_ATTR_BSS_SHORT_PREAMBLE,
    WS_NL80211_ATTR_BSS_SHORT_SLOT_TIME,
    WS_NL80211_ATTR_HT_CAPABILITY,
    WS_NL80211_ATTR_SUPPORTED_IFTYPES,
    WS_NL80211_ATTR_REG_ALPHA2,
    WS_NL80211_ATTR_REG_RULES,
    WS_NL80211_ATTR_MESH_CONFIG,
    WS_NL80211_ATTR_BSS_BASIC_RATES,
    WS_NL80211_ATTR_WIPHY_TXQ_PARAMS,
    WS_NL80211_ATTR_WIPHY_FREQ,
    WS_NL80211_ATTR_WIPHY_CHANNEL_TYPE,
    WS_NL80211_ATTR_KEY_DEFAULT_MGMT,
    WS_NL80211_ATTR_MGMT_SUBTYPE,
    WS_NL80211_ATTR_IE,
    WS_NL80211_ATTR_MAX_NUM_SCAN_SSIDS,
    WS_NL80211_ATTR_SCAN_FREQUENCIES,
    WS_NL80211_ATTR_SCAN_SSIDS,
    WS_NL80211_ATTR_GENERATION,
    WS_NL80211_ATTR_BSS,
    WS_NL80211_ATTR_REG_INITIATOR,
    WS_NL80211_ATTR_REG_TYPE,
    WS_NL80211_ATTR_SUPPORTED_COMMANDS,
    WS_NL80211_ATTR_FRAME,
    WS_NL80211_ATTR_SSID,
    WS_NL80211_ATTR_AUTH_TYPE,
    WS_NL80211_ATTR_REASON_CODE,
    WS_NL80211_ATTR_KEY_TYPE,
    WS_NL80211_ATTR_MAX_SCAN_IE_LEN,
    WS_NL80211_ATTR_CIPHER_SUITES,
    WS_NL80211_ATTR_FREQ_BEFORE,
    WS_NL80211_ATTR_FREQ_AFTER,
    WS_NL80211_ATTR_FREQ_FIXED,
    WS_NL80211_ATTR_WIPHY_RETRY_SHORT,
    WS_NL80211_ATTR_WIPHY_RETRY_LONG,
    WS_NL80211_ATTR_WIPHY_FRAG_THRESHOLD,
    WS_NL80211_ATTR_WIPHY_RTS_THRESHOLD,
    WS_NL80211_ATTR_TIMED_OUT,
    WS_NL80211_ATTR_USE_MFP,
    WS_NL80211_ATTR_STA_FLAGS2,
    WS_NL80211_ATTR_CONTROL_PORT,
    WS_NL80211_ATTR_TESTDATA,
    WS_NL80211_ATTR_PRIVACY,
    WS_NL80211_ATTR_DISCONNECTED_BY_AP,
    WS_NL80211_ATTR_STATUS_CODE,
    WS_NL80211_ATTR_CIPHER_SUITES_PAIRWISE,
    WS_NL80211_ATTR_CIPHER_SUITE_GROUP,
    WS_NL80211_ATTR_WPA_VERSIONS,
    WS_NL80211_ATTR_AKM_SUITES,
    WS_NL80211_ATTR_REQ_IE,
    WS_NL80211_ATTR_RESP_IE,
    WS_NL80211_ATTR_PREV_BSSID,
    WS_NL80211_ATTR_KEY,
    WS_NL80211_ATTR_KEYS,
    WS_NL80211_ATTR_PID,
    WS_NL80211_ATTR_4ADDR,
    WS_NL80211_ATTR_SURVEY_INFO,
    WS_NL80211_ATTR_PMKID,
    WS_NL80211_ATTR_MAX_NUM_PMKIDS,
    WS_NL80211_ATTR_DURATION,
    WS_NL80211_ATTR_COOKIE,
    WS_NL80211_ATTR_WIPHY_COVERAGE_CLASS,
    WS_NL80211_ATTR_TX_RATES,
    WS_NL80211_ATTR_FRAME_MATCH,
    WS_NL80211_ATTR_ACK,
    WS_NL80211_ATTR_PS_STATE,
    WS_NL80211_ATTR_CQM,
    WS_NL80211_ATTR_LOCAL_STATE_CHANGE,
    WS_NL80211_ATTR_AP_ISOLATE,
    WS_NL80211_ATTR_WIPHY_TX_POWER_SETTING,
    WS_NL80211_ATTR_WIPHY_TX_POWER_LEVEL,
    WS_NL80211_ATTR_TX_FRAME_TYPES,
    WS_NL80211_ATTR_RX_FRAME_TYPES,
    WS_NL80211_ATTR_FRAME_TYPE,
    WS_NL80211_ATTR_CONTROL_PORT_ETHERTYPE,
    WS_NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT,
    WS_NL80211_ATTR_SUPPORT_IBSS_RSN,
    WS_NL80211_ATTR_WIPHY_ANTENNA_TX,
    WS_NL80211_ATTR_WIPHY_ANTENNA_RX,
    WS_NL80211_ATTR_MCAST_RATE,
    WS_NL80211_ATTR_OFFCHANNEL_TX_OK,
    WS_NL80211_ATTR_BSS_HT_OPMODE,
    WS_NL80211_ATTR_KEY_DEFAULT_TYPES,
    WS_NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION,
    WS_NL80211_ATTR_MESH_SETUP,
    WS_NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX,
    WS_NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX,
    WS_NL80211_ATTR_SUPPORT_MESH_AUTH,
    WS_NL80211_ATTR_STA_PLINK_STATE,
    WS_NL80211_ATTR_WOWLAN_TRIGGERS,
    WS_NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED,
    WS_NL80211_ATTR_SCHED_SCAN_INTERVAL,
    WS_NL80211_ATTR_INTERFACE_COMBINATIONS,
    WS_NL80211_ATTR_SOFTWARE_IFTYPES,
    WS_NL80211_ATTR_REKEY_DATA,
    WS_NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS,
    WS_NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN,
    WS_NL80211_ATTR_SCAN_SUPP_RATES,
    WS_NL80211_ATTR_HIDDEN_SSID,
    WS_NL80211_ATTR_IE_PROBE_RESP,
    WS_NL80211_ATTR_IE_ASSOC_RESP,
    WS_NL80211_ATTR_STA_WME,
    WS_NL80211_ATTR_SUPPORT_AP_UAPSD,
    WS_NL80211_ATTR_ROAM_SUPPORT,
    WS_NL80211_ATTR_SCHED_SCAN_MATCH,
    WS_NL80211_ATTR_MAX_MATCH_SETS,
    WS_NL80211_ATTR_PMKSA_CANDIDATE,
    WS_NL80211_ATTR_TX_NO_CCK_RATE,
    WS_NL80211_ATTR_TDLS_ACTION,
    WS_NL80211_ATTR_TDLS_DIALOG_TOKEN,
    WS_NL80211_ATTR_TDLS_OPERATION,
    WS_NL80211_ATTR_TDLS_SUPPORT,
    WS_NL80211_ATTR_TDLS_EXTERNAL_SETUP,
    WS_NL80211_ATTR_DEVICE_AP_SME,
    WS_NL80211_ATTR_DONT_WAIT_FOR_ACK,
    WS_NL80211_ATTR_FEATURE_FLAGS,
    WS_NL80211_ATTR_PROBE_RESP_OFFLOAD,
    WS_NL80211_ATTR_PROBE_RESP,
    WS_NL80211_ATTR_DFS_REGION,
    WS_NL80211_ATTR_DISABLE_HT,
    WS_NL80211_ATTR_HT_CAPABILITY_MASK,
    WS_NL80211_ATTR_NOACK_MAP,
    WS_NL80211_ATTR_INACTIVITY_TIMEOUT,
    WS_NL80211_ATTR_RX_SIGNAL_DBM,
    WS_NL80211_ATTR_BG_SCAN_PERIOD,
    WS_NL80211_ATTR_WDEV,
    WS_NL80211_ATTR_USER_REG_HINT_TYPE,
    WS_NL80211_ATTR_CONN_FAILED_REASON,
    WS_NL80211_ATTR_AUTH_DATA,
    WS_NL80211_ATTR_VHT_CAPABILITY,
    WS_NL80211_ATTR_SCAN_FLAGS,
    WS_NL80211_ATTR_CHANNEL_WIDTH,
    WS_NL80211_ATTR_CENTER_FREQ1,
    WS_NL80211_ATTR_CENTER_FREQ2,
    WS_NL80211_ATTR_P2P_CTWINDOW,
    WS_NL80211_ATTR_P2P_OPPPS,
    WS_NL80211_ATTR_LOCAL_MESH_POWER_MODE,
    WS_NL80211_ATTR_ACL_POLICY,
    WS_NL80211_ATTR_MAC_ADDRS,
    WS_NL80211_ATTR_MAC_ACL_MAX,
    WS_NL80211_ATTR_RADAR_EVENT,
    WS_NL80211_ATTR_EXT_CAPA,
    WS_NL80211_ATTR_EXT_CAPA_MASK,
    WS_NL80211_ATTR_STA_CAPABILITY,
    WS_NL80211_ATTR_STA_EXT_CAPABILITY,
    WS_NL80211_ATTR_PROTOCOL_FEATURES,
    WS_NL80211_ATTR_SPLIT_WIPHY_DUMP,
    WS_NL80211_ATTR_DISABLE_VHT,
    WS_NL80211_ATTR_VHT_CAPABILITY_MASK,
    WS_NL80211_ATTR_MDID,
    WS_NL80211_ATTR_IE_RIC,
    WS_NL80211_ATTR_CRIT_PROT_ID,
    WS_NL80211_ATTR_MAX_CRIT_PROT_DURATION,
    WS_NL80211_ATTR_PEER_AID,
    WS_NL80211_ATTR_COALESCE_RULE,
    WS_NL80211_ATTR_CH_SWITCH_COUNT,
    WS_NL80211_ATTR_CH_SWITCH_BLOCK_TX,
    WS_NL80211_ATTR_CSA_IES,
    WS_NL80211_ATTR_CSA_C_OFF_BEACON,
    WS_NL80211_ATTR_CSA_C_OFF_PRESP,
    WS_NL80211_ATTR_RXMGMT_FLAGS,
    WS_NL80211_ATTR_STA_SUPPORTED_CHANNELS,
    WS_NL80211_ATTR_STA_SUPPORTED_OPER_CLASSES,
    WS_NL80211_ATTR_HANDLE_DFS,
    WS_NL80211_ATTR_SUPPORT_5_MHZ,
    WS_NL80211_ATTR_SUPPORT_10_MHZ,
    WS_NL80211_ATTR_OPMODE_NOTIF,
    WS_NL80211_ATTR_VENDOR_ID,
    WS_NL80211_ATTR_VENDOR_SUBCMD,
    WS_NL80211_ATTR_VENDOR_DATA,
    WS_NL80211_ATTR_VENDOR_EVENTS,
    WS_NL80211_ATTR_QOS_MAP,
    WS_NL80211_ATTR_MAC_HINT,
    WS_NL80211_ATTR_WIPHY_FREQ_HINT,
    WS_NL80211_ATTR_MAX_AP_ASSOC_STA,
    WS_NL80211_ATTR_TDLS_PEER_CAPABILITY,
    WS_NL80211_ATTR_SOCKET_OWNER,
    WS_NL80211_ATTR_CSA_C_OFFSETS_TX,
    WS_NL80211_ATTR_MAX_CSA_COUNTERS,
    WS_NL80211_ATTR_TDLS_INITIATOR,
    WS_NL80211_ATTR_USE_RRM,
    WS_NL80211_ATTR_WIPHY_DYN_ACK,
    WS_NL80211_ATTR_TSID,
    WS_NL80211_ATTR_USER_PRIO,
    WS_NL80211_ATTR_ADMITTED_TIME,
    WS_NL80211_ATTR_SMPS_MODE,
    WS_NL80211_ATTR_OPER_CLASS,
    WS_NL80211_ATTR_MAC_MASK,
    WS_NL80211_ATTR_WIPHY_SELF_MANAGED_REG,
    WS_NL80211_ATTR_EXT_FEATURES,
    WS_NL80211_ATTR_SURVEY_RADIO_STATS,
    WS_NL80211_ATTR_NETNS_FD,
    WS_NL80211_ATTR_SCHED_SCAN_DELAY,
    WS_NL80211_ATTR_REG_INDOOR,
    WS_NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS,
    WS_NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL,
    WS_NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS,
    WS_NL80211_ATTR_SCHED_SCAN_PLANS,
    WS_NL80211_ATTR_PBSS,
    WS_NL80211_ATTR_BSS_SELECT,
    WS_NL80211_ATTR_STA_SUPPORT_P2P_PS,
    WS_NL80211_ATTR_PAD,
    WS_NL80211_ATTR_IFTYPE_EXT_CAPA,
    WS_NL80211_ATTR_MU_MIMO_GROUP_DATA,
    WS_NL80211_ATTR_MU_MIMO_FOLLOW_MAC_ADDR,
    WS_NL80211_ATTR_SCAN_START_TIME_TSF,
    WS_NL80211_ATTR_SCAN_START_TIME_TSF_BSSID,
    WS_NL80211_ATTR_MEASUREMENT_DURATION,
    WS_NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY,
    WS_NL80211_ATTR_MESH_PEER_AID,
    WS_NL80211_ATTR_NAN_MASTER_PREF,
    WS_NL80211_ATTR_BANDS,
    WS_NL80211_ATTR_NAN_FUNC,
    WS_NL80211_ATTR_NAN_MATCH,
    WS_NL80211_ATTR_FILS_KEK,
    WS_NL80211_ATTR_FILS_NONCES,
    WS_NL80211_ATTR_MULTICAST_TO_UNICAST_ENABLED,
    WS_NL80211_ATTR_BSSID,
    WS_NL80211_ATTR_SCHED_SCAN_RELATIVE_RSSI,
    WS_NL80211_ATTR_SCHED_SCAN_RSSI_ADJUST,
    WS_NL80211_ATTR_TIMEOUT_REASON,
};

static const value_string ws_nl80211_commands_vals[] = {
    { WS_NL80211_CMD_UNSPEC,                "NL80211_CMD_UNSPEC" },
    { WS_NL80211_CMD_GET_WIPHY,             "NL80211_CMD_GET_WIPHY" },
    { WS_NL80211_CMD_SET_WIPHY,             "NL80211_CMD_SET_WIPHY" },
    { WS_NL80211_CMD_NEW_WIPHY,             "NL80211_CMD_NEW_WIPHY" },
    { WS_NL80211_CMD_DEL_WIPHY,             "NL80211_CMD_DEL_WIPHY" },
    { WS_NL80211_CMD_GET_INTERFACE,         "NL80211_CMD_GET_INTERFACE" },
    { WS_NL80211_CMD_SET_INTERFACE,         "NL80211_CMD_SET_INTERFACE" },
    { WS_NL80211_CMD_NEW_INTERFACE,         "NL80211_CMD_NEW_INTERFACE" },
    { WS_NL80211_CMD_DEL_INTERFACE,         "NL80211_CMD_DEL_INTERFACE" },
    { WS_NL80211_CMD_GET_KEY,               "NL80211_CMD_GET_KEY" },
    { WS_NL80211_CMD_SET_KEY,               "NL80211_CMD_SET_KEY" },
    { WS_NL80211_CMD_NEW_KEY,               "NL80211_CMD_NEW_KEY" },
    { WS_NL80211_CMD_DEL_KEY,               "NL80211_CMD_DEL_KEY" },
    { WS_NL80211_CMD_GET_BEACON,            "NL80211_CMD_GET_BEACON" },
    { WS_NL80211_CMD_SET_BEACON,            "NL80211_CMD_SET_BEACON" },
    { WS_NL80211_CMD_START_AP,              "NL80211_CMD_START_AP" },
    { WS_NL80211_CMD_STOP_AP,               "NL80211_CMD_STOP_AP" },
    { WS_NL80211_CMD_GET_STATION,           "NL80211_CMD_GET_STATION" },
    { WS_NL80211_CMD_SET_STATION,           "NL80211_CMD_SET_STATION" },
    { WS_NL80211_CMD_NEW_STATION,           "NL80211_CMD_NEW_STATION" },
    { WS_NL80211_CMD_DEL_STATION,           "NL80211_CMD_DEL_STATION" },
    { WS_NL80211_CMD_GET_MPATH,             "NL80211_CMD_GET_MPATH" },
    { WS_NL80211_CMD_SET_MPATH,             "NL80211_CMD_SET_MPATH" },
    { WS_NL80211_CMD_NEW_MPATH,             "NL80211_CMD_NEW_MPATH" },
    { WS_NL80211_CMD_DEL_MPATH,             "NL80211_CMD_DEL_MPATH" },
    { WS_NL80211_CMD_SET_BSS,               "NL80211_CMD_SET_BSS" },
    { WS_NL80211_CMD_SET_REG,               "NL80211_CMD_SET_REG" },
    { WS_NL80211_CMD_REQ_SET_REG,           "NL80211_CMD_REQ_SET_REG" },
    { WS_NL80211_CMD_GET_MESH_CONFIG,       "NL80211_CMD_GET_MESH_CONFIG" },
    { WS_NL80211_CMD_SET_MESH_CONFIG,       "NL80211_CMD_SET_MESH_CONFIG" },
    { WS_NL80211_CMD_SET_MGMT_EXTRA_IE,     "NL80211_CMD_SET_MGMT_EXTRA_IE" },
    { WS_NL80211_CMD_GET_REG,               "NL80211_CMD_GET_REG" },
    { WS_NL80211_CMD_GET_SCAN,              "NL80211_CMD_GET_SCAN" },
    { WS_NL80211_CMD_TRIGGER_SCAN,          "NL80211_CMD_TRIGGER_SCAN" },
    { WS_NL80211_CMD_NEW_SCAN_RESULTS,      "NL80211_CMD_NEW_SCAN_RESULTS" },
    { WS_NL80211_CMD_SCAN_ABORTED,          "NL80211_CMD_SCAN_ABORTED" },
    { WS_NL80211_CMD_REG_CHANGE,            "NL80211_CMD_REG_CHANGE" },
    { WS_NL80211_CMD_AUTHENTICATE,          "NL80211_CMD_AUTHENTICATE" },
    { WS_NL80211_CMD_ASSOCIATE,             "NL80211_CMD_ASSOCIATE" },
    { WS_NL80211_CMD_DEAUTHENTICATE,        "NL80211_CMD_DEAUTHENTICATE" },
    { WS_NL80211_CMD_DISASSOCIATE,          "NL80211_CMD_DISASSOCIATE" },
    { WS_NL80211_CMD_MICHAEL_MIC_FAILURE,   "NL80211_CMD_MICHAEL_MIC_FAILURE" },
    { WS_NL80211_CMD_REG_BEACON_HINT,       "NL80211_CMD_REG_BEACON_HINT" },
    { WS_NL80211_CMD_JOIN_IBSS,             "NL80211_CMD_JOIN_IBSS" },
    { WS_NL80211_CMD_LEAVE_IBSS,            "NL80211_CMD_LEAVE_IBSS" },
    { WS_NL80211_CMD_TESTMODE,              "NL80211_CMD_TESTMODE" },
    { WS_NL80211_CMD_CONNECT,               "NL80211_CMD_CONNECT" },
    { WS_NL80211_CMD_ROAM,                  "NL80211_CMD_ROAM" },
    { WS_NL80211_CMD_DISCONNECT,            "NL80211_CMD_DISCONNECT" },
    { WS_NL80211_CMD_SET_WIPHY_NETNS,       "NL80211_CMD_SET_WIPHY_NETNS" },
    { WS_NL80211_CMD_GET_SURVEY,            "NL80211_CMD_GET_SURVEY" },
    { WS_NL80211_CMD_NEW_SURVEY_RESULTS,    "NL80211_CMD_NEW_SURVEY_RESULTS" },
    { WS_NL80211_CMD_SET_PMKSA,             "NL80211_CMD_SET_PMKSA" },
    { WS_NL80211_CMD_DEL_PMKSA,             "NL80211_CMD_DEL_PMKSA" },
    { WS_NL80211_CMD_FLUSH_PMKSA,           "NL80211_CMD_FLUSH_PMKSA" },
    { WS_NL80211_CMD_REMAIN_ON_CHANNEL,     "NL80211_CMD_REMAIN_ON_CHANNEL" },
    { WS_NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL, "NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL" },
    { WS_NL80211_CMD_SET_TX_BITRATE_MASK,   "NL80211_CMD_SET_TX_BITRATE_MASK" },
    { WS_NL80211_CMD_REGISTER_FRAME,        "NL80211_CMD_REGISTER_FRAME" },
    { WS_NL80211_CMD_FRAME,                 "NL80211_CMD_FRAME" },
    { WS_NL80211_CMD_FRAME_TX_STATUS,       "NL80211_CMD_FRAME_TX_STATUS" },
    { WS_NL80211_CMD_SET_POWER_SAVE,        "NL80211_CMD_SET_POWER_SAVE" },
    { WS_NL80211_CMD_GET_POWER_SAVE,        "NL80211_CMD_GET_POWER_SAVE" },
    { WS_NL80211_CMD_SET_CQM,               "NL80211_CMD_SET_CQM" },
    { WS_NL80211_CMD_NOTIFY_CQM,            "NL80211_CMD_NOTIFY_CQM" },
    { WS_NL80211_CMD_SET_CHANNEL,           "NL80211_CMD_SET_CHANNEL" },
    { WS_NL80211_CMD_SET_WDS_PEER,          "NL80211_CMD_SET_WDS_PEER" },
    { WS_NL80211_CMD_FRAME_WAIT_CANCEL,     "NL80211_CMD_FRAME_WAIT_CANCEL" },
    { WS_NL80211_CMD_JOIN_MESH,             "NL80211_CMD_JOIN_MESH" },
    { WS_NL80211_CMD_LEAVE_MESH,            "NL80211_CMD_LEAVE_MESH" },
    { WS_NL80211_CMD_UNPROT_DEAUTHENTICATE, "NL80211_CMD_UNPROT_DEAUTHENTICATE" },
    { WS_NL80211_CMD_UNPROT_DISASSOCIATE,   "NL80211_CMD_UNPROT_DISASSOCIATE" },
    { WS_NL80211_CMD_NEW_PEER_CANDIDATE,    "NL80211_CMD_NEW_PEER_CANDIDATE" },
    { WS_NL80211_CMD_GET_WOWLAN,            "NL80211_CMD_GET_WOWLAN" },
    { WS_NL80211_CMD_SET_WOWLAN,            "NL80211_CMD_SET_WOWLAN" },
    { WS_NL80211_CMD_START_SCHED_SCAN,      "NL80211_CMD_START_SCHED_SCAN" },
    { WS_NL80211_CMD_STOP_SCHED_SCAN,       "NL80211_CMD_STOP_SCHED_SCAN" },
    { WS_NL80211_CMD_SCHED_SCAN_RESULTS,    "NL80211_CMD_SCHED_SCAN_RESULTS" },
    { WS_NL80211_CMD_SCHED_SCAN_STOPPED,    "NL80211_CMD_SCHED_SCAN_STOPPED" },
    { WS_NL80211_CMD_SET_REKEY_OFFLOAD,     "NL80211_CMD_SET_REKEY_OFFLOAD" },
    { WS_NL80211_CMD_PMKSA_CANDIDATE,       "NL80211_CMD_PMKSA_CANDIDATE" },
    { WS_NL80211_CMD_TDLS_OPER,             "NL80211_CMD_TDLS_OPER" },
    { WS_NL80211_CMD_TDLS_MGMT,             "NL80211_CMD_TDLS_MGMT" },
    { WS_NL80211_CMD_UNEXPECTED_FRAME,      "NL80211_CMD_UNEXPECTED_FRAME" },
    { WS_NL80211_CMD_PROBE_CLIENT,          "NL80211_CMD_PROBE_CLIENT" },
    { WS_NL80211_CMD_REGISTER_BEACONS,      "NL80211_CMD_REGISTER_BEACONS" },
    { WS_NL80211_CMD_UNEXPECTED_4ADDR_FRAME, "NL80211_CMD_UNEXPECTED_4ADDR_FRAME" },
    { WS_NL80211_CMD_SET_NOACK_MAP,         "NL80211_CMD_SET_NOACK_MAP" },
    { WS_NL80211_CMD_CH_SWITCH_NOTIFY,      "NL80211_CMD_CH_SWITCH_NOTIFY" },
    { WS_NL80211_CMD_START_P2P_DEVICE,      "NL80211_CMD_START_P2P_DEVICE" },
    { WS_NL80211_CMD_STOP_P2P_DEVICE,       "NL80211_CMD_STOP_P2P_DEVICE" },
    { WS_NL80211_CMD_CONN_FAILED,           "NL80211_CMD_CONN_FAILED" },
    { WS_NL80211_CMD_SET_MCAST_RATE,        "NL80211_CMD_SET_MCAST_RATE" },
    { WS_NL80211_CMD_SET_MAC_ACL,           "NL80211_CMD_SET_MAC_ACL" },
    { WS_NL80211_CMD_RADAR_DETECT,          "NL80211_CMD_RADAR_DETECT" },
    { WS_NL80211_CMD_GET_PROTOCOL_FEATURES, "NL80211_CMD_GET_PROTOCOL_FEATURES" },
    { WS_NL80211_CMD_UPDATE_FT_IES,         "NL80211_CMD_UPDATE_FT_IES" },
    { WS_NL80211_CMD_FT_EVENT,              "NL80211_CMD_FT_EVENT" },
    { WS_NL80211_CMD_CRIT_PROTOCOL_START,   "NL80211_CMD_CRIT_PROTOCOL_START" },
    { WS_NL80211_CMD_CRIT_PROTOCOL_STOP,    "NL80211_CMD_CRIT_PROTOCOL_STOP" },
    { WS_NL80211_CMD_GET_COALESCE,          "NL80211_CMD_GET_COALESCE" },
    { WS_NL80211_CMD_SET_COALESCE,          "NL80211_CMD_SET_COALESCE" },
    { WS_NL80211_CMD_CHANNEL_SWITCH,        "NL80211_CMD_CHANNEL_SWITCH" },
    { WS_NL80211_CMD_VENDOR,                "NL80211_CMD_VENDOR" },
    { WS_NL80211_CMD_SET_QOS_MAP,           "NL80211_CMD_SET_QOS_MAP" },
    { WS_NL80211_CMD_ADD_TX_TS,             "NL80211_CMD_ADD_TX_TS" },
    { WS_NL80211_CMD_DEL_TX_TS,             "NL80211_CMD_DEL_TX_TS" },
    { WS_NL80211_CMD_GET_MPP,               "NL80211_CMD_GET_MPP" },
    { WS_NL80211_CMD_JOIN_OCB,              "NL80211_CMD_JOIN_OCB" },
    { WS_NL80211_CMD_LEAVE_OCB,             "NL80211_CMD_LEAVE_OCB" },
    { WS_NL80211_CMD_CH_SWITCH_STARTED_NOTIFY, "NL80211_CMD_CH_SWITCH_STARTED_NOTIFY" },
    { WS_NL80211_CMD_TDLS_CHANNEL_SWITCH,   "NL80211_CMD_TDLS_CHANNEL_SWITCH" },
    { WS_NL80211_CMD_TDLS_CANCEL_CHANNEL_SWITCH, "NL80211_CMD_TDLS_CANCEL_CHANNEL_SWITCH" },
    { WS_NL80211_CMD_WIPHY_REG_CHANGE,      "NL80211_CMD_WIPHY_REG_CHANGE" },
    { WS_NL80211_CMD_ABORT_SCAN,            "NL80211_CMD_ABORT_SCAN" },
    { WS_NL80211_CMD_START_NAN,             "NL80211_CMD_START_NAN" },
    { WS_NL80211_CMD_STOP_NAN,              "NL80211_CMD_STOP_NAN" },
    { WS_NL80211_CMD_ADD_NAN_FUNCTION,      "NL80211_CMD_ADD_NAN_FUNCTION" },
    { WS_NL80211_CMD_DEL_NAN_FUNCTION,      "NL80211_CMD_DEL_NAN_FUNCTION" },
    { WS_NL80211_CMD_CHANGE_NAN_CONFIG,     "NL80211_CMD_CHANGE_NAN_CONFIG" },
    { WS_NL80211_CMD_NAN_MATCH,             "NL80211_CMD_NAN_MATCH" },
    { WS_NL80211_CMD_SET_MULTICAST_TO_UNICAST, "NL80211_CMD_SET_MULTICAST_TO_UNICAST" },
    { WS_NL80211_CMD_UPDATE_CONNECT_PARAMS, "NL80211_CMD_UPDATE_CONNECT_PARAMS" },
    { 0, NULL }
};
static value_string_ext ws_nl80211_commands_vals_ext = VALUE_STRING_EXT_INIT(ws_nl80211_commands_vals);

static const value_string ws_nl80211_attrs_vals[] = {
    { WS_NL80211_ATTR_UNSPEC,               "NL80211_ATTR_UNSPEC" },
    { WS_NL80211_ATTR_WIPHY,                "NL80211_ATTR_WIPHY" },
    { WS_NL80211_ATTR_WIPHY_NAME,           "NL80211_ATTR_WIPHY_NAME" },
    { WS_NL80211_ATTR_IFINDEX,              "NL80211_ATTR_IFINDEX" },
    { WS_NL80211_ATTR_IFNAME,               "NL80211_ATTR_IFNAME" },
    { WS_NL80211_ATTR_IFTYPE,               "NL80211_ATTR_IFTYPE" },
    { WS_NL80211_ATTR_MAC,                  "NL80211_ATTR_MAC" },
    { WS_NL80211_ATTR_KEY_DATA,             "NL80211_ATTR_KEY_DATA" },
    { WS_NL80211_ATTR_KEY_IDX,              "NL80211_ATTR_KEY_IDX" },
    { WS_NL80211_ATTR_KEY_CIPHER,           "NL80211_ATTR_KEY_CIPHER" },
    { WS_NL80211_ATTR_KEY_SEQ,              "NL80211_ATTR_KEY_SEQ" },
    { WS_NL80211_ATTR_KEY_DEFAULT,          "NL80211_ATTR_KEY_DEFAULT" },
    { WS_NL80211_ATTR_BEACON_INTERVAL,      "NL80211_ATTR_BEACON_INTERVAL" },
    { WS_NL80211_ATTR_DTIM_PERIOD,          "NL80211_ATTR_DTIM_PERIOD" },
    { WS_NL80211_ATTR_BEACON_HEAD,          "NL80211_ATTR_BEACON_HEAD" },
    { WS_NL80211_ATTR_BEACON_TAIL,          "NL80211_ATTR_BEACON_TAIL" },
    { WS_NL80211_ATTR_STA_AID,              "NL80211_ATTR_STA_AID" },
    { WS_NL80211_ATTR_STA_FLAGS,            "NL80211_ATTR_STA_FLAGS" },
    { WS_NL80211_ATTR_STA_LISTEN_INTERVAL,  "NL80211_ATTR_STA_LISTEN_INTERVAL" },
    { WS_NL80211_ATTR_STA_SUPPORTED_RATES,  "NL80211_ATTR_STA_SUPPORTED_RATES" },
    { WS_NL80211_ATTR_STA_VLAN,             "NL80211_ATTR_STA_VLAN" },
    { WS_NL80211_ATTR_STA_INFO,             "NL80211_ATTR_STA_INFO" },
    { WS_NL80211_ATTR_WIPHY_BANDS,          "NL80211_ATTR_WIPHY_BANDS" },
    { WS_NL80211_ATTR_MNTR_FLAGS,           "NL80211_ATTR_MNTR_FLAGS" },
    { WS_NL80211_ATTR_MESH_ID,              "NL80211_ATTR_MESH_ID" },
    { WS_NL80211_ATTR_STA_PLINK_ACTION,     "NL80211_ATTR_STA_PLINK_ACTION" },
    { WS_NL80211_ATTR_MPATH_NEXT_HOP,       "NL80211_ATTR_MPATH_NEXT_HOP" },
    { WS_NL80211_ATTR_MPATH_INFO,           "NL80211_ATTR_MPATH_INFO" },
    { WS_NL80211_ATTR_BSS_CTS_PROT,         "NL80211_ATTR_BSS_CTS_PROT" },
    { WS_NL80211_ATTR_BSS_SHORT_PREAMBLE,   "NL80211_ATTR_BSS_SHORT_PREAMBLE" },
    { WS_NL80211_ATTR_BSS_SHORT_SLOT_TIME,  "NL80211_ATTR_BSS_SHORT_SLOT_TIME" },
    { WS_NL80211_ATTR_HT_CAPABILITY,        "NL80211_ATTR_HT_CAPABILITY" },
    { WS_NL80211_ATTR_SUPPORTED_IFTYPES,    "NL80211_ATTR_SUPPORTED_IFTYPES" },
    { WS_NL80211_ATTR_REG_ALPHA2,           "NL80211_ATTR_REG_ALPHA2" },
    { WS_NL80211_ATTR_REG_RULES,            "NL80211_ATTR_REG_RULES" },
    { WS_NL80211_ATTR_MESH_CONFIG,          "NL80211_ATTR_MESH_CONFIG" },
    { WS_NL80211_ATTR_BSS_BASIC_RATES,      "NL80211_ATTR_BSS_BASIC_RATES" },
    { WS_NL80211_ATTR_WIPHY_TXQ_PARAMS,     "NL80211_ATTR_WIPHY_TXQ_PARAMS" },
    { WS_NL80211_ATTR_WIPHY_FREQ,           "NL80211_ATTR_WIPHY_FREQ" },
    { WS_NL80211_ATTR_WIPHY_CHANNEL_TYPE,   "NL80211_ATTR_WIPHY_CHANNEL_TYPE" },
    { WS_NL80211_ATTR_KEY_DEFAULT_MGMT,     "NL80211_ATTR_KEY_DEFAULT_MGMT" },
    { WS_NL80211_ATTR_MGMT_SUBTYPE,         "NL80211_ATTR_MGMT_SUBTYPE" },
    { WS_NL80211_ATTR_IE,                   "NL80211_ATTR_IE" },
    { WS_NL80211_ATTR_MAX_NUM_SCAN_SSIDS,   "NL80211_ATTR_MAX_NUM_SCAN_SSIDS" },
    { WS_NL80211_ATTR_SCAN_FREQUENCIES,     "NL80211_ATTR_SCAN_FREQUENCIES" },
    { WS_NL80211_ATTR_SCAN_SSIDS,           "NL80211_ATTR_SCAN_SSIDS" },
    { WS_NL80211_ATTR_GENERATION,           "NL80211_ATTR_GENERATION" },
    { WS_NL80211_ATTR_BSS,                  "NL80211_ATTR_BSS" },
    { WS_NL80211_ATTR_REG_INITIATOR,        "NL80211_ATTR_REG_INITIATOR" },
    { WS_NL80211_ATTR_REG_TYPE,             "NL80211_ATTR_REG_TYPE" },
    { WS_NL80211_ATTR_SUPPORTED_COMMANDS,   "NL80211_ATTR_SUPPORTED_COMMANDS" },
    { WS_NL80211_ATTR_FRAME,                "NL80211_ATTR_FRAME" },
    { WS_NL80211_ATTR_SSID,                 "NL80211_ATTR_SSID" },
    { WS_NL80211_ATTR_AUTH_TYPE,            "NL80211_ATTR_AUTH_TYPE" },
    { WS_NL80211_ATTR_REASON_CODE,          "NL80211_ATTR_REASON_CODE" },
    { WS_NL80211_ATTR_KEY_TYPE,             "NL80211_ATTR_KEY_TYPE" },
    { WS_NL80211_ATTR_MAX_SCAN_IE_LEN,      "NL80211_ATTR_MAX_SCAN_IE_LEN" },
    { WS_NL80211_ATTR_CIPHER_SUITES,        "NL80211_ATTR_CIPHER_SUITES" },
    { WS_NL80211_ATTR_FREQ_BEFORE,          "NL80211_ATTR_FREQ_BEFORE" },
    { WS_NL80211_ATTR_FREQ_AFTER,           "NL80211_ATTR_FREQ_AFTER" },
    { WS_NL80211_ATTR_FREQ_FIXED,           "NL80211_ATTR_FREQ_FIXED" },
    { WS_NL80211_ATTR_WIPHY_RETRY_SHORT,    "NL80211_ATTR_WIPHY_RETRY_SHORT" },
    { WS_NL80211_ATTR_WIPHY_RETRY_LONG,     "NL80211_ATTR_WIPHY_RETRY_LONG" },
    { WS_NL80211_ATTR_WIPHY_FRAG_THRESHOLD, "NL80211_ATTR_WIPHY_FRAG_THRESHOLD" },
    { WS_NL80211_ATTR_WIPHY_RTS_THRESHOLD,  "NL80211_ATTR_WIPHY_RTS_THRESHOLD" },
    { WS_NL80211_ATTR_TIMED_OUT,            "NL80211_ATTR_TIMED_OUT" },
    { WS_NL80211_ATTR_USE_MFP,              "NL80211_ATTR_USE_MFP" },
    { WS_NL80211_ATTR_STA_FLAGS2,           "NL80211_ATTR_STA_FLAGS2" },
    { WS_NL80211_ATTR_CONTROL_PORT,         "NL80211_ATTR_CONTROL_PORT" },
    { WS_NL80211_ATTR_TESTDATA,             "NL80211_ATTR_TESTDATA" },
    { WS_NL80211_ATTR_PRIVACY,              "NL80211_ATTR_PRIVACY" },
    { WS_NL80211_ATTR_DISCONNECTED_BY_AP,   "NL80211_ATTR_DISCONNECTED_BY_AP" },
    { WS_NL80211_ATTR_STATUS_CODE,          "NL80211_ATTR_STATUS_CODE" },
    { WS_NL80211_ATTR_CIPHER_SUITES_PAIRWISE, "NL80211_ATTR_CIPHER_SUITES_PAIRWISE" },
    { WS_NL80211_ATTR_CIPHER_SUITE_GROUP,   "NL80211_ATTR_CIPHER_SUITE_GROUP" },
    { WS_NL80211_ATTR_WPA_VERSIONS,         "NL80211_ATTR_WPA_VERSIONS" },
    { WS_NL80211_ATTR_AKM_SUITES,           "NL80211_ATTR_AKM_SUITES" },
    { WS_NL80211_ATTR_REQ_IE,               "NL80211_ATTR_REQ_IE" },
    { WS_NL80211_ATTR_RESP_IE,              "NL80211_ATTR_RESP_IE" },
    { WS_NL80211_ATTR_PREV_BSSID,           "NL80211_ATTR_PREV_BSSID" },
    { WS_NL80211_ATTR_KEY,                  "NL80211_ATTR_KEY" },
    { WS_NL80211_ATTR_KEYS,                 "NL80211_ATTR_KEYS" },
    { WS_NL80211_ATTR_PID,                  "NL80211_ATTR_PID" },
    { WS_NL80211_ATTR_4ADDR,                "NL80211_ATTR_4ADDR" },
    { WS_NL80211_ATTR_SURVEY_INFO,          "NL80211_ATTR_SURVEY_INFO" },
    { WS_NL80211_ATTR_PMKID,                "NL80211_ATTR_PMKID" },
    { WS_NL80211_ATTR_MAX_NUM_PMKIDS,       "NL80211_ATTR_MAX_NUM_PMKIDS" },
    { WS_NL80211_ATTR_DURATION,             "NL80211_ATTR_DURATION" },
    { WS_NL80211_ATTR_COOKIE,               "NL80211_ATTR_COOKIE" },
    { WS_NL80211_ATTR_WIPHY_COVERAGE_CLASS, "NL80211_ATTR_WIPHY_COVERAGE_CLASS" },
    { WS_NL80211_ATTR_TX_RATES,             "NL80211_ATTR_TX_RATES" },
    { WS_NL80211_ATTR_FRAME_MATCH,          "NL80211_ATTR_FRAME_MATCH" },
    { WS_NL80211_ATTR_ACK,                  "NL80211_ATTR_ACK" },
    { WS_NL80211_ATTR_PS_STATE,             "NL80211_ATTR_PS_STATE" },
    { WS_NL80211_ATTR_CQM,                  "NL80211_ATTR_CQM" },
    { WS_NL80211_ATTR_LOCAL_STATE_CHANGE,   "NL80211_ATTR_LOCAL_STATE_CHANGE" },
    { WS_NL80211_ATTR_AP_ISOLATE,           "NL80211_ATTR_AP_ISOLATE" },
    { WS_NL80211_ATTR_WIPHY_TX_POWER_SETTING, "NL80211_ATTR_WIPHY_TX_POWER_SETTING" },
    { WS_NL80211_ATTR_WIPHY_TX_POWER_LEVEL, "NL80211_ATTR_WIPHY_TX_POWER_LEVEL" },
    { WS_NL80211_ATTR_TX_FRAME_TYPES,       "NL80211_ATTR_TX_FRAME_TYPES" },
    { WS_NL80211_ATTR_RX_FRAME_TYPES,       "NL80211_ATTR_RX_FRAME_TYPES" },
    { WS_NL80211_ATTR_FRAME_TYPE,           "NL80211_ATTR_FRAME_TYPE" },
    { WS_NL80211_ATTR_CONTROL_PORT_ETHERTYPE, "NL80211_ATTR_CONTROL_PORT_ETHERTYPE" },
    { WS_NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT, "NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT" },
    { WS_NL80211_ATTR_SUPPORT_IBSS_RSN,     "NL80211_ATTR_SUPPORT_IBSS_RSN" },
    { WS_NL80211_ATTR_WIPHY_ANTENNA_TX,     "NL80211_ATTR_WIPHY_ANTENNA_TX" },
    { WS_NL80211_ATTR_WIPHY_ANTENNA_RX,     "NL80211_ATTR_WIPHY_ANTENNA_RX" },
    { WS_NL80211_ATTR_MCAST_RATE,           "NL80211_ATTR_MCAST_RATE" },
    { WS_NL80211_ATTR_OFFCHANNEL_TX_OK,     "NL80211_ATTR_OFFCHANNEL_TX_OK" },
    { WS_NL80211_ATTR_BSS_HT_OPMODE,        "NL80211_ATTR_BSS_HT_OPMODE" },
    { WS_NL80211_ATTR_KEY_DEFAULT_TYPES,    "NL80211_ATTR_KEY_DEFAULT_TYPES" },
    { WS_NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION, "NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION" },
    { WS_NL80211_ATTR_MESH_SETUP,           "NL80211_ATTR_MESH_SETUP" },
    { WS_NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX, "NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX" },
    { WS_NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX, "NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX" },
    { WS_NL80211_ATTR_SUPPORT_MESH_AUTH,    "NL80211_ATTR_SUPPORT_MESH_AUTH" },
    { WS_NL80211_ATTR_STA_PLINK_STATE,      "NL80211_ATTR_STA_PLINK_STATE" },
    { WS_NL80211_ATTR_WOWLAN_TRIGGERS,      "NL80211_ATTR_WOWLAN_TRIGGERS" },
    { WS_NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED, "NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED" },
    { WS_NL80211_ATTR_SCHED_SCAN_INTERVAL,  "NL80211_ATTR_SCHED_SCAN_INTERVAL" },
    { WS_NL80211_ATTR_INTERFACE_COMBINATIONS, "NL80211_ATTR_INTERFACE_COMBINATIONS" },
    { WS_NL80211_ATTR_SOFTWARE_IFTYPES,     "NL80211_ATTR_SOFTWARE_IFTYPES" },
    { WS_NL80211_ATTR_REKEY_DATA,           "NL80211_ATTR_REKEY_DATA" },
    { WS_NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS, "NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS" },
    { WS_NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN, "NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN" },
    { WS_NL80211_ATTR_SCAN_SUPP_RATES,      "NL80211_ATTR_SCAN_SUPP_RATES" },
    { WS_NL80211_ATTR_HIDDEN_SSID,          "NL80211_ATTR_HIDDEN_SSID" },
    { WS_NL80211_ATTR_IE_PROBE_RESP,        "NL80211_ATTR_IE_PROBE_RESP" },
    { WS_NL80211_ATTR_IE_ASSOC_RESP,        "NL80211_ATTR_IE_ASSOC_RESP" },
    { WS_NL80211_ATTR_STA_WME,              "NL80211_ATTR_STA_WME" },
    { WS_NL80211_ATTR_SUPPORT_AP_UAPSD,     "NL80211_ATTR_SUPPORT_AP_UAPSD" },
    { WS_NL80211_ATTR_ROAM_SUPPORT,         "NL80211_ATTR_ROAM_SUPPORT" },
    { WS_NL80211_ATTR_SCHED_SCAN_MATCH,     "NL80211_ATTR_SCHED_SCAN_MATCH" },
    { WS_NL80211_ATTR_MAX_MATCH_SETS,       "NL80211_ATTR_MAX_MATCH_SETS" },
    { WS_NL80211_ATTR_PMKSA_CANDIDATE,      "NL80211_ATTR_PMKSA_CANDIDATE" },
    { WS_NL80211_ATTR_TX_NO_CCK_RATE,       "NL80211_ATTR_TX_NO_CCK_RATE" },
    { WS_NL80211_ATTR_TDLS_ACTION,          "NL80211_ATTR_TDLS_ACTION" },
    { WS_NL80211_ATTR_TDLS_DIALOG_TOKEN,    "NL80211_ATTR_TDLS_DIALOG_TOKEN" },
    { WS_NL80211_ATTR_TDLS_OPERATION,       "NL80211_ATTR_TDLS_OPERATION" },
    { WS_NL80211_ATTR_TDLS_SUPPORT,         "NL80211_ATTR_TDLS_SUPPORT" },
    { WS_NL80211_ATTR_TDLS_EXTERNAL_SETUP,  "NL80211_ATTR_TDLS_EXTERNAL_SETUP" },
    { WS_NL80211_ATTR_DEVICE_AP_SME,        "NL80211_ATTR_DEVICE_AP_SME" },
    { WS_NL80211_ATTR_DONT_WAIT_FOR_ACK,    "NL80211_ATTR_DONT_WAIT_FOR_ACK" },
    { WS_NL80211_ATTR_FEATURE_FLAGS,        "NL80211_ATTR_FEATURE_FLAGS" },
    { WS_NL80211_ATTR_PROBE_RESP_OFFLOAD,   "NL80211_ATTR_PROBE_RESP_OFFLOAD" },
    { WS_NL80211_ATTR_PROBE_RESP,           "NL80211_ATTR_PROBE_RESP" },
    { WS_NL80211_ATTR_DFS_REGION,           "NL80211_ATTR_DFS_REGION" },
    { WS_NL80211_ATTR_DISABLE_HT,           "NL80211_ATTR_DISABLE_HT" },
    { WS_NL80211_ATTR_HT_CAPABILITY_MASK,   "NL80211_ATTR_HT_CAPABILITY_MASK" },
    { WS_NL80211_ATTR_NOACK_MAP,            "NL80211_ATTR_NOACK_MAP" },
    { WS_NL80211_ATTR_INACTIVITY_TIMEOUT,   "NL80211_ATTR_INACTIVITY_TIMEOUT" },
    { WS_NL80211_ATTR_RX_SIGNAL_DBM,        "NL80211_ATTR_RX_SIGNAL_DBM" },
    { WS_NL80211_ATTR_BG_SCAN_PERIOD,       "NL80211_ATTR_BG_SCAN_PERIOD" },
    { WS_NL80211_ATTR_WDEV,                 "NL80211_ATTR_WDEV" },
    { WS_NL80211_ATTR_USER_REG_HINT_TYPE,   "NL80211_ATTR_USER_REG_HINT_TYPE" },
    { WS_NL80211_ATTR_CONN_FAILED_REASON,   "NL80211_ATTR_CONN_FAILED_REASON" },
    { WS_NL80211_ATTR_AUTH_DATA,            "NL80211_ATTR_AUTH_DATA" },
    { WS_NL80211_ATTR_VHT_CAPABILITY,       "NL80211_ATTR_VHT_CAPABILITY" },
    { WS_NL80211_ATTR_SCAN_FLAGS,           "NL80211_ATTR_SCAN_FLAGS" },
    { WS_NL80211_ATTR_CHANNEL_WIDTH,        "NL80211_ATTR_CHANNEL_WIDTH" },
    { WS_NL80211_ATTR_CENTER_FREQ1,         "NL80211_ATTR_CENTER_FREQ1" },
    { WS_NL80211_ATTR_CENTER_FREQ2,         "NL80211_ATTR_CENTER_FREQ2" },
    { WS_NL80211_ATTR_P2P_CTWINDOW,         "NL80211_ATTR_P2P_CTWINDOW" },
    { WS_NL80211_ATTR_P2P_OPPPS,            "NL80211_ATTR_P2P_OPPPS" },
    { WS_NL80211_ATTR_LOCAL_MESH_POWER_MODE, "NL80211_ATTR_LOCAL_MESH_POWER_MODE" },
    { WS_NL80211_ATTR_ACL_POLICY,           "NL80211_ATTR_ACL_POLICY" },
    { WS_NL80211_ATTR_MAC_ADDRS,            "NL80211_ATTR_MAC_ADDRS" },
    { WS_NL80211_ATTR_MAC_ACL_MAX,          "NL80211_ATTR_MAC_ACL_MAX" },
    { WS_NL80211_ATTR_RADAR_EVENT,          "NL80211_ATTR_RADAR_EVENT" },
    { WS_NL80211_ATTR_EXT_CAPA,             "NL80211_ATTR_EXT_CAPA" },
    { WS_NL80211_ATTR_EXT_CAPA_MASK,        "NL80211_ATTR_EXT_CAPA_MASK" },
    { WS_NL80211_ATTR_STA_CAPABILITY,       "NL80211_ATTR_STA_CAPABILITY" },
    { WS_NL80211_ATTR_STA_EXT_CAPABILITY,   "NL80211_ATTR_STA_EXT_CAPABILITY" },
    { WS_NL80211_ATTR_PROTOCOL_FEATURES,    "NL80211_ATTR_PROTOCOL_FEATURES" },
    { WS_NL80211_ATTR_SPLIT_WIPHY_DUMP,     "NL80211_ATTR_SPLIT_WIPHY_DUMP" },
    { WS_NL80211_ATTR_DISABLE_VHT,          "NL80211_ATTR_DISABLE_VHT" },
    { WS_NL80211_ATTR_VHT_CAPABILITY_MASK,  "NL80211_ATTR_VHT_CAPABILITY_MASK" },
    { WS_NL80211_ATTR_MDID,                 "NL80211_ATTR_MDID" },
    { WS_NL80211_ATTR_IE_RIC,               "NL80211_ATTR_IE_RIC" },
    { WS_NL80211_ATTR_CRIT_PROT_ID,         "NL80211_ATTR_CRIT_PROT_ID" },
    { WS_NL80211_ATTR_MAX_CRIT_PROT_DURATION, "NL80211_ATTR_MAX_CRIT_PROT_DURATION" },
    { WS_NL80211_ATTR_PEER_AID,             "NL80211_ATTR_PEER_AID" },
    { WS_NL80211_ATTR_COALESCE_RULE,        "NL80211_ATTR_COALESCE_RULE" },
    { WS_NL80211_ATTR_CH_SWITCH_COUNT,      "NL80211_ATTR_CH_SWITCH_COUNT" },
    { WS_NL80211_ATTR_CH_SWITCH_BLOCK_TX,   "NL80211_ATTR_CH_SWITCH_BLOCK_TX" },
    { WS_NL80211_ATTR_CSA_IES,              "NL80211_ATTR_CSA_IES" },
    { WS_NL80211_ATTR_CSA_C_OFF_BEACON,     "NL80211_ATTR_CSA_C_OFF_BEACON" },
    { WS_NL80211_ATTR_CSA_C_OFF_PRESP,      "NL80211_ATTR_CSA_C_OFF_PRESP" },
    { WS_NL80211_ATTR_RXMGMT_FLAGS,         "NL80211_ATTR_RXMGMT_FLAGS" },
    { WS_NL80211_ATTR_STA_SUPPORTED_CHANNELS, "NL80211_ATTR_STA_SUPPORTED_CHANNELS" },
    { WS_NL80211_ATTR_STA_SUPPORTED_OPER_CLASSES, "NL80211_ATTR_STA_SUPPORTED_OPER_CLASSES" },
    { WS_NL80211_ATTR_HANDLE_DFS,           "NL80211_ATTR_HANDLE_DFS" },
    { WS_NL80211_ATTR_SUPPORT_5_MHZ,        "NL80211_ATTR_SUPPORT_5_MHZ" },
    { WS_NL80211_ATTR_SUPPORT_10_MHZ,       "NL80211_ATTR_SUPPORT_10_MHZ" },
    { WS_NL80211_ATTR_OPMODE_NOTIF,         "NL80211_ATTR_OPMODE_NOTIF" },
    { WS_NL80211_ATTR_VENDOR_ID,            "NL80211_ATTR_VENDOR_ID" },
    { WS_NL80211_ATTR_VENDOR_SUBCMD,        "NL80211_ATTR_VENDOR_SUBCMD" },
    { WS_NL80211_ATTR_VENDOR_DATA,          "NL80211_ATTR_VENDOR_DATA" },
    { WS_NL80211_ATTR_VENDOR_EVENTS,        "NL80211_ATTR_VENDOR_EVENTS" },
    { WS_NL80211_ATTR_QOS_MAP,              "NL80211_ATTR_QOS_MAP" },
    { WS_NL80211_ATTR_MAC_HINT,             "NL80211_ATTR_MAC_HINT" },
    { WS_NL80211_ATTR_WIPHY_FREQ_HINT,      "NL80211_ATTR_WIPHY_FREQ_HINT" },
    { WS_NL80211_ATTR_MAX_AP_ASSOC_STA,     "NL80211_ATTR_MAX_AP_ASSOC_STA" },
    { WS_NL80211_ATTR_TDLS_PEER_CAPABILITY, "NL80211_ATTR_TDLS_PEER_CAPABILITY" },
    { WS_NL80211_ATTR_SOCKET_OWNER,         "NL80211_ATTR_SOCKET_OWNER" },
    { WS_NL80211_ATTR_CSA_C_OFFSETS_TX,     "NL80211_ATTR_CSA_C_OFFSETS_TX" },
    { WS_NL80211_ATTR_MAX_CSA_COUNTERS,     "NL80211_ATTR_MAX_CSA_COUNTERS" },
    { WS_NL80211_ATTR_TDLS_INITIATOR,       "NL80211_ATTR_TDLS_INITIATOR" },
    { WS_NL80211_ATTR_USE_RRM,              "NL80211_ATTR_USE_RRM" },
    { WS_NL80211_ATTR_WIPHY_DYN_ACK,        "NL80211_ATTR_WIPHY_DYN_ACK" },
    { WS_NL80211_ATTR_TSID,                 "NL80211_ATTR_TSID" },
    { WS_NL80211_ATTR_USER_PRIO,            "NL80211_ATTR_USER_PRIO" },
    { WS_NL80211_ATTR_ADMITTED_TIME,        "NL80211_ATTR_ADMITTED_TIME" },
    { WS_NL80211_ATTR_SMPS_MODE,            "NL80211_ATTR_SMPS_MODE" },
    { WS_NL80211_ATTR_OPER_CLASS,           "NL80211_ATTR_OPER_CLASS" },
    { WS_NL80211_ATTR_MAC_MASK,             "NL80211_ATTR_MAC_MASK" },
    { WS_NL80211_ATTR_WIPHY_SELF_MANAGED_REG, "NL80211_ATTR_WIPHY_SELF_MANAGED_REG" },
    { WS_NL80211_ATTR_EXT_FEATURES,         "NL80211_ATTR_EXT_FEATURES" },
    { WS_NL80211_ATTR_SURVEY_RADIO_STATS,   "NL80211_ATTR_SURVEY_RADIO_STATS" },
    { WS_NL80211_ATTR_NETNS_FD,             "NL80211_ATTR_NETNS_FD" },
    { WS_NL80211_ATTR_SCHED_SCAN_DELAY,     "NL80211_ATTR_SCHED_SCAN_DELAY" },
    { WS_NL80211_ATTR_REG_INDOOR,           "NL80211_ATTR_REG_INDOOR" },
    { WS_NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS, "NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS" },
    { WS_NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL, "NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL" },
    { WS_NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS, "NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS" },
    { WS_NL80211_ATTR_SCHED_SCAN_PLANS,     "NL80211_ATTR_SCHED_SCAN_PLANS" },
    { WS_NL80211_ATTR_PBSS,                 "NL80211_ATTR_PBSS" },
    { WS_NL80211_ATTR_BSS_SELECT,           "NL80211_ATTR_BSS_SELECT" },
    { WS_NL80211_ATTR_STA_SUPPORT_P2P_PS,   "NL80211_ATTR_STA_SUPPORT_P2P_PS" },
    { WS_NL80211_ATTR_PAD,                  "NL80211_ATTR_PAD" },
    { WS_NL80211_ATTR_IFTYPE_EXT_CAPA,      "NL80211_ATTR_IFTYPE_EXT_CAPA" },
    { WS_NL80211_ATTR_MU_MIMO_GROUP_DATA,   "NL80211_ATTR_MU_MIMO_GROUP_DATA" },
    { WS_NL80211_ATTR_MU_MIMO_FOLLOW_MAC_ADDR, "NL80211_ATTR_MU_MIMO_FOLLOW_MAC_ADDR" },
    { WS_NL80211_ATTR_SCAN_START_TIME_TSF,  "NL80211_ATTR_SCAN_START_TIME_TSF" },
    { WS_NL80211_ATTR_SCAN_START_TIME_TSF_BSSID, "NL80211_ATTR_SCAN_START_TIME_TSF_BSSID" },
    { WS_NL80211_ATTR_MEASUREMENT_DURATION, "NL80211_ATTR_MEASUREMENT_DURATION" },
    { WS_NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY, "NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY" },
    { WS_NL80211_ATTR_MESH_PEER_AID,        "NL80211_ATTR_MESH_PEER_AID" },
    { WS_NL80211_ATTR_NAN_MASTER_PREF,      "NL80211_ATTR_NAN_MASTER_PREF" },
    { WS_NL80211_ATTR_BANDS,                "NL80211_ATTR_BANDS" },
    { WS_NL80211_ATTR_NAN_FUNC,             "NL80211_ATTR_NAN_FUNC" },
    { WS_NL80211_ATTR_NAN_MATCH,            "NL80211_ATTR_NAN_MATCH" },
    { WS_NL80211_ATTR_FILS_KEK,             "NL80211_ATTR_FILS_KEK" },
    { WS_NL80211_ATTR_FILS_NONCES,          "NL80211_ATTR_FILS_NONCES" },
    { WS_NL80211_ATTR_MULTICAST_TO_UNICAST_ENABLED, "NL80211_ATTR_MULTICAST_TO_UNICAST_ENABLED" },
    { WS_NL80211_ATTR_BSSID,                "NL80211_ATTR_BSSID" },
    { WS_NL80211_ATTR_SCHED_SCAN_RELATIVE_RSSI, "NL80211_ATTR_SCHED_SCAN_RELATIVE_RSSI" },
    { WS_NL80211_ATTR_SCHED_SCAN_RSSI_ADJUST, "NL80211_ATTR_SCHED_SCAN_RSSI_ADJUST" },
    { WS_NL80211_ATTR_TIMEOUT_REASON,       "NL80211_ATTR_TIMEOUT_REASON" },
    { 0, NULL }
};
static value_string_ext ws_nl80211_attrs_vals_ext = VALUE_STRING_EXT_INIT(ws_nl80211_attrs_vals);
/* }}} */


static int proto_netlink_nl80211;

static dissector_handle_t netlink_nl80211_handle;

static header_field_info *hfi_netlink_nl80211 = NULL;

#define NETLINK_NL80211_HFI_INIT HFI_INIT(proto_netlink_generic)

static gint ett_nl80211 = -1;
static gint ett_nl80211_attr = -1;

static header_field_info hfi_nl80211_attr_type NETLINK_NL80211_HFI_INIT =
    { "Attribute Type", "nl80211.attr_type", FT_UINT16, BASE_DEC | BASE_EXT_STRING,
      VALS(&ws_nl80211_attrs_vals_ext), 0x00, NULL, HFILL };

static header_field_info hfi_nl80211_attr_value NETLINK_NL80211_HFI_INIT =
    { "Attribute Value", "nl80211.attr_value", FT_BYTES, BASE_NONE,
      NULL, 0x00, NULL, HFILL };

static header_field_info hfi_nl80211_attr_value16 NETLINK_NL80211_HFI_INIT =
    { "Attribute Value", "nl80211.attr_value16", FT_UINT16, BASE_HEX_DEC,
      NULL, 0x00, NULL, HFILL };

static header_field_info hfi_nl80211_attr_value32 NETLINK_NL80211_HFI_INIT =
    { "Attribute Value", "nl80211.attr_value32", FT_UINT32, BASE_HEX_DEC,
      NULL, 0x00, NULL, HFILL };

static int
dissect_nl80211_attrs(tvbuff_t *tvb, void *data, proto_tree *tree, int nla_type, int offset, int len)
{
    enum ws_nl80211_commands type = (enum ws_nl80211_commands) nla_type;
    genl_info_t *genl_info = (genl_info_t *)data;

    switch (type) {
    /* TODO add more fields here? */
    default:
        /*
         * No specific dissection available, apply arbitrary heuristics to
         * determine whether we have an u16 or u32 field and treat others as
         * opaque bytes.
         */
        if (len) {
            if (len == 2) {
                proto_tree_add_item(tree, &hfi_nl80211_attr_value16, tvb, offset, len, genl_info->encoding);
            } else if (len == 4) {
                proto_tree_add_item(tree, &hfi_nl80211_attr_value32, tvb, offset, len, genl_info->encoding);
            } else {
                proto_tree_add_item(tree, &hfi_nl80211_attr_value, tvb, offset, len, genl_info->encoding);
            }
            offset += len;
        }
        break;
    }

    return offset;
}


static header_field_info hfi_nl80211_cmd NETLINK_NL80211_HFI_INIT =
    { "Command", "nl80211.cmd", FT_UINT8, BASE_DEC | BASE_EXT_STRING,
      &ws_nl80211_commands_vals_ext, 0x00, "Generic Netlink command", HFILL };

static int
dissect_netlink_nl80211(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data)
{
    genl_info_t *genl_info = (genl_info_t *)data;
    proto_tree *nlmsg_tree;
    proto_item *pi;
    int offset;

    DISSECTOR_ASSERT(genl_info);

    col_set_str(pinfo->cinfo, COL_PROTOCOL, "nl80211");
    col_clear(pinfo->cinfo, COL_INFO);

    offset = dissect_genl_header(tvb, genl_info, &hfi_nl80211_cmd);

    pi = proto_tree_add_item(tree, proto_registrar_get_nth(proto_netlink_nl80211), tvb, offset, -1, ENC_NA);
    nlmsg_tree = proto_item_add_subtree(pi, ett_nl80211);

    offset = dissect_netlink_attributes(tvb, &hfi_nl80211_attr_type, ett_nl80211_attr, genl_info, genl_info->data, nlmsg_tree, offset, -1, dissect_nl80211_attrs);

    return offset;
}

void
proto_register_netlink_nl80211(void)
{
#ifndef HAVE_HFI_SECTION_INIT
    static header_field_info *hfi[] = {
        &hfi_nl80211_cmd,
        &hfi_nl80211_attr_type,
        &hfi_nl80211_attr_value,
        &hfi_nl80211_attr_value16,
        &hfi_nl80211_attr_value32,
    };
#endif

    static gint *ett[] = {
        &ett_nl80211,
        &ett_nl80211_attr,
    };

    proto_netlink_nl80211 = proto_register_protocol("Linux 802.11 Netlink", "nl80211", "nl80211");
    hfi_netlink_nl80211 = proto_registrar_get_nth(proto_netlink_nl80211);

    proto_register_fields(proto_netlink_nl80211, hfi, array_length(hfi));
    proto_register_subtree_array(ett, array_length(ett));

    netlink_nl80211_handle = create_dissector_handle(dissect_netlink_nl80211, proto_netlink_nl80211);
}

void
proto_reg_handoff_netlink_nl80211(void)
{
    dissector_add_string("genl.family", "nl80211", netlink_nl80211_handle);
}

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 4
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=4 tabstop=8 expandtab:
 * :indentSize=4:tabSize=8:noTabs=true:
 */
