#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <time.h>
#include "xtelld.h"
#include "config.h"
#include <locale.h>

unsigned short int verbose = 0;

void verbose_message(char *s)
{
    if (verbose == 1) {
	printf("%s", s);
	fflush(NULL);
    }
}


/* write_to_log - write log if you can */
short int write_to_log(const char *fromluser, const char *toluser,
		       const char *message)
{
    FILE *file;
    int filedes;

    time_t tim = time(NULL);
    char bleah[20];
    strftime(bleah, sizeof(bleah), "%R %d-%b-%y", localtime(&tim));
    if ((filedes = logFILE(fromluser)) != -1) {
        file = fdopen(filedes, "w");
        if (!file)
            return -1;
	fprintf(file, "[%s] -> %s: %s\n", bleah, toluser, message);
	fclose(file);
	return 0;
    }
    return -1;
}



short int write_to_socket(int sock, const char *msg)
{
    int retval;

    verbose_message("*** Writing to socket...");
    retval = send(sock, msg, strlen(msg), 0);
    if (retval == -1) {
	return -1;
    }
    verbose_message("done.\n");
    return 0;
}

static int connection = -1;	/* socket */

short int make_new_connection(const struct hostent *hostentptr,
			      const unsigned short int port)
{
    static struct sockaddr_in sock2_name;	/* Address str. for socket2 */

    int retval;

    verbose_message("done.\n");

    sock2_name.sin_family = hostentptr->h_addrtype;
    sock2_name.sin_port = htons(port);
    sock2_name.sin_addr = *((struct in_addr *) hostentptr->h_addr);

    if ((connection = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
	perror("socket");
	exit(1);
    }

    verbose_message("*** Connecting...");
    retval =
	connect(connection, (struct sockaddr *) &sock2_name,
		sizeof(sock2_name));
    if (retval) {
	perror("connect");
	killsock(connection);
	close(connection);
	exit(1);
    }
    verbose_message("done.\n");
    return 0;
}

unsigned short int write_message(const struct hostent *hostentptr,
				 const unsigned short int port,
				 const char *msg)
{
    short int r;

    if (connection == -1) {	/* new connection */
	make_new_connection(hostentptr, port);
    }
    r = write_to_socket(connection, msg);
    if (r == -1) {		/* there was an error writting to socket - retry 
				   it exactly once, in case it was caused by timeout */
	killsock(connection);
	close(connection);
	make_new_connection(hostentptr, port);
	r = write_to_socket(connection, msg);
	if (r == -1) {
	    perror("Error sending data");
	    return -1;
	}
    }
    return 0;
}


/* returns 0 - went ok, -1 - network or other error, 1 - refused message */
short int write_buffer(const struct hostent *hostentptr,
		       const unsigned short int port,
		       const char *buffer,
		       const char *fromluser,
		       const char *toluser, const char *message)
{
    unsigned short int i;
    short int r;
    char recbuffer[MAX_REPLY_LENGTH];

    for (i = 1; i <= 2; i++) {
	r = write_message(hostentptr, port, buffer);
	if (r != -1) {
	    r = get_request(connection, recbuffer, sizeof(recbuffer));
	    if (r != -1) {
		break;
	    }
        };
        connection = -1;
    }
    if (r == -1) {
	perror("Error writing message");
	return -1;
    }
    if (recbuffer[0] != '2') {
	printf("%s\n", recbuffer);
	return 1;
    } else {
	write_to_log(fromluser, toluser, message);
	return 0;
    }
}



char *readmessage(const char *prompt)
{
#ifndef USE_READLINE
    int c;
    unsigned int size = 0;
    char *np;
#endif
    char *p;

    verbose_message("*** Waiting for you:\n");

#ifdef USE_READLINE
    p = readline(prompt);
    if (p)
	add_history(p);
    return p;
#else

    printf("%s", prompt);
    p = malloc(1);
    while ((c = getchar()) != EOF) {
	if (c == '\n')
	    break;
	size++;
	np = realloc(p, size + 1);
	if (np == NULL) {
	    perror("Realloc failed");
	    exit(1);
	}
	p = np;
	p[size - 1] = (char) c;
    }
    if (c == EOF && size == 0) {
	free(p);
	return NULL;
    }
    p[size] = '\0';
    return p;
#endif
}


void usage(void)
{
    fprintf(stderr,
	    "Usage: xtell [-v] user[:tty][@hostname[:port]] [message]\n");
}


int main(int argc, char **argv)
{
    char *p;
    struct passwd *passs;
    short int r;
    int l;

    char fromluser[MAX_LUSERNAME_LENGTH], toluser[MAX_LUSERNAME_LENGTH] =
	"", totty[MAX_TTY_LENGTH] = "";
    char buffer[MAX_SOCK_LENGTH];
    unsigned int toport = XTELL_DEFAULT_PORT;
    char bufftoluser[MAX_LUSERNAME_LENGTH + MAX_TTY_LENGTH + 2] = "";
    char buffhost[MAX_HOSTNAME + 10] = "", tohost[MAX_HOSTNAME] = "";

    struct hostent *hostentptr;

    char *maybeuser;

    int mstart;
    unsigned int i = 1;
    unsigned short int noargs = 0;	/* indicates there are no valid arguments */

    char *prompt = "xtell> ";
    char *t;
    t = setlocale (LC_CTYPE, "");


    if (argc == 1) {
/*	usage();
	exit(1);*/
	noargs = 1;
    }

    if ((p = getenv("XTELLPROMPT")) != NULL) {
	prompt = p;
    }


    if (!noargs) {
	if (!strcmp(argv[1], "--help")) {
	    usage();
	    exit(1);
	}

	if (!strcmp(argv[1], "--version")) {
	    printf("xtell %s\n", VERSION);
	    exit(1);
	}

	if (!strcmp(argv[1], "-v")) {
	    verbose = 1;
	    printf("*** Verbose mode is on\n");
	    i++;
	    if (argc == 2) {	/* bad number of parameters */
/*	    usage();
	    exit(1);*/
		noargs = 1;
	    };
	};

    }

    if (noargs) {
	p = readmessage("User: ");
        if (p == NULL)
            exit(1);
	maybeuser = p;
    } else {
	maybeuser = argv[i];
    };

    if ((p = strchr(maybeuser, '@')) == NULL) {

	if (noargs) {
	    p = readmessage("Host [localhost]: ");
            if (p == NULL)
                exit(1);
	    if (!strcmp(p, "")) {
		if (gethostname(buffhost, MAX_HOSTNAME) < 0) {
		    perror("Error in getting hostname");
		    strcpy(buffhost, "localhost");
		}
	    } else
		strncpy(buffhost, p, sizeof(buffhost) - 1);
	    free(p);
	} else {
	    if (gethostname(buffhost, MAX_HOSTNAME) < 0) {
		perror("Error in getting hostname");
		strcpy(buffhost, "localhost");
	    };

	}

	strncat(bufftoluser, maybeuser, sizeof(bufftoluser));
    } else {
	strncat(bufftoluser, maybeuser, p - maybeuser);
	strncat(buffhost, p + 1, strlen(maybeuser) - (p - maybeuser));
    }

    if ((p = strchr(bufftoluser, ':')) != NULL) {
	strncat(toluser, bufftoluser, p - bufftoluser);
	strncat(totty, p + 1, MAX_TTY_LENGTH);
    } else {
	strncpy(toluser, bufftoluser, sizeof(toluser));
    }

    if ((p = strchr(buffhost, ':')) != NULL) {
	strncat(tohost, buffhost, p - buffhost);
	toport = atoi(p + 1);
    } else {
	strncpy(tohost, buffhost, sizeof(tohost));
    }

    verbose_message("*** Getting host address...");
    if ((hostentptr = gethostbyname(tohost)) == NULL) {
	printf("%s\n", tohost);
	perror("Host not found");
	exit(1);
    }


    if ((passs = getpwuid(getuid())) != NULL)
	strncpy(fromluser, passs->pw_name, MAX_LUSERNAME_LENGTH);
    else {
#ifdef USE_CUSERID
	cuserid(fromluser);
#else
	strcpy(fromluser, "(unknown)");
#endif
    }



    if (argc > i + 1) {
	p = malloc(MAX_MSG_LENGTH + 1);
	p[0] = '\0';
	strcpy(buffer, fromluser);
	strcat(buffer, ":");
	strcat(buffer, toluser);
	strcat(buffer, ":");
	strcat(buffer, totty);
	strcat(buffer, ":");
	mstart = strlen(buffer);
	for (i++; i < argc; i++) {
	    strcat(buffer, argv[i]);
	    strcat(buffer, " ");
	    strcat(p, argv[i]);
	    strcat(p, " ");

//        snprintf (buffer, sizeof (buffer), "%s:%s:%s:%s\r\n", fromluser,
//                  toluser, totty, argv[i]);
	}
	strcat(buffer, "\r\n");

	r = write_buffer(hostentptr, toport, buffer, fromluser, toluser,
			 p);
	free(p);

    } else {

	while ((p = readmessage(prompt)) != NULL) {
	    if ((l = strlen(p)) >= MAX_MSG_LENGTH) {
		p = realloc(p, MAX_MSG_LENGTH + 1);
		p[MAX_MSG_LENGTH] = '\0';
		fprintf(stderr,
			"Warning: line too long, cutting %d characters\n",
			l - MAX_MSG_LENGTH);
	    }
	    strcpy(buffer, fromluser);
	    strcat(buffer, ":");
	    strcat(buffer, toluser);
	    strcat(buffer, ":");
	    strcat(buffer, totty);
	    strcat(buffer, ":");
	    mstart = strlen(buffer);
	    strcat(buffer, p);
	    strcat(buffer, "\r\n");
//          snprintf(buffer, sizeof(buffer), "%s:%s:%s:%s\r\n", fromluser,
//                   toluser, totty, p);

	    r = write_buffer(hostentptr, toport, buffer, fromluser,
			     toluser, p);
	    free(p);
	}
    }


    verbose_message("*** Telling the other side we are through: ");
    write_message(hostentptr, toport, "QUIT\r\n");
    verbose_message("done\n");
    killsock(connection);
    close(connection);
    return (0);

}				/* end main */
