
/* This file defines the API for the PICKLE Reader Library. 
	Version 1. */

/* This library is a very simple one, intended for use in interpreters
	that want to support reading PICKLE files. This library does not
	have functions to write or analyze PICKLE files, just to read them
	in the rather limited way that interpreters should want to. */

/* First, a few definitions which you may have to customize for your
	machine. */

/* pikLong must be typedef'd as a 32-bit signed integer. If "long" is not 
	32 bits on your system, change this line. */
typedef long pikLong; 
/* BIG_END_MODE or LITTLE_END_MODE is defined by the Makefile. */

/* Now some Useful Constants */

#define pikerr_None (0)
#define pikerr_NotFound (1)
#define pikerr_BadOption (2)
#define pikerr_NotAMap (3)
#define pikerr_CantRead (4)
#define pikerr_Memory (5)
#define pikerr_WrongSizeInts (11)
#define pikerr_WrongEndian (12)

#define pikmethod_DontRead (0)
#define pikmethod_FilePos (1)
#define pikmethod_Memory (2)

#define pik_NoChunk (-1)

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

typedef pikLong pikType;
typedef short pikErr;

#define pikMakeType(c1, c2, c3, c4)   \
	((((pikType)(c1)) << 24) | (((pikType)(c2)) << 16) \
	| (((pikType)(c3)) << 8) | ((pikType)(c4)))

typedef struct pikMapData *pikMapPtr;
struct pikFormatData {
	pikType name;
	pikLong version;
};
typedef struct pikFormatData pikFormat;
typedef pikLong pikChunkID;
struct pikChunkData {
	union {
		pikLong startpos; /* Set by pikmethod_FilePos */
		void *ptr; /* Set by pikmethod_Memory (non-Mac systems) */
		/*Handle han;*/ /* Set by pikmethod_Memory (Mac only) */
	} data;
	pikLong length;
	pikFormat format;
};
typedef struct pikChunkData pikChunk;

#ifdef __STDC__

extern short pikIsPickleHeader(char *header);
extern pikErr pikCreateMap(FILE *file, pikMapPtr *newmap);
extern pikErr pikDestroyMap(pikMapPtr map);
extern pikErr pikFindChunk(pikMapPtr map, pikType use, pikLong number, 
	short numformats, pikFormat *formatlist, pikChunkID *idfound);
extern pikErr pikLoadChunk(pikMapPtr map, pikChunkID id, short method, pikChunk *found);
extern pikErr pikUnloadChunk(pikMapPtr map, pikChunkID id);

#else

extern short pikIsPickleHeader();
extern pikErr pikCreateMap();
extern pikErr pikDestroyMap();
extern pikErr pikFindChunk();
extern pikErr pikLoadChunk();
extern pikErr pikUnloadChunk();

#endif

